/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util.encoders;

import com.enterprisedt.bouncycastle.util.encoders.DecoderException;
import com.enterprisedt.bouncycastle.util.encoders.Encoder;
import com.enterprisedt.bouncycastle.util.encoders.EncoderException;
import com.enterprisedt.bouncycastle.util.encoders.UrlBase64Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class UrlBase64 {
    private static final Encoder a = new UrlBase64Encoder();

    public static byte[] encode(byte[] data) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            a.encode(data, 0, data.length, byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new EncoderException("exception encoding URL safe base64 data: " + exception.getMessage(), exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int encode(byte[] data, OutputStream out) throws IOException {
        return a.encode(data, 0, data.length, out);
    }

    public static byte[] decode(byte[] data) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            a.decode(data, 0, data.length, byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new DecoderException("exception decoding URL safe base64 string: " + exception.getMessage(), exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int decode(byte[] data, OutputStream out) throws IOException {
        return a.decode(data, 0, data.length, out);
    }

    public static byte[] decode(String data) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            a.decode(data, byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new DecoderException("exception decoding URL safe base64 string: " + exception.getMessage(), exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int decode(String data, OutputStream out) throws IOException {
        return a.decode(data, out);
    }
}

