/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util.io;

import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.OutputStream;

public class BufferingOutputStream
extends OutputStream {
    private final OutputStream a;
    private final byte[] b;
    private int c;

    public BufferingOutputStream(OutputStream other) {
        this.a = other;
        this.b = new byte[4096];
    }

    public BufferingOutputStream(OutputStream other, int bufferSize) {
        this.a = other;
        this.b = new byte[bufferSize];
    }

    @Override
    public void write(byte[] bytes, int offset, int len) throws IOException {
        if (len < this.b.length - this.c) {
            System.arraycopy(bytes, offset, this.b, this.c, len);
            this.c += len;
        } else {
            int n2 = this.b.length - this.c;
            System.arraycopy(bytes, offset, this.b, this.c, n2);
            this.c += n2;
            this.flush();
            offset += n2;
            len -= n2;
            while (len >= this.b.length) {
                this.a.write(bytes, offset, this.b.length);
                offset += this.b.length;
                len -= this.b.length;
            }
            if (len > 0) {
                System.arraycopy(bytes, offset, this.b, this.c, len);
                this.c += len;
            }
        }
    }

    @Override
    public void write(int b2) throws IOException {
        this.b[this.c++] = (byte)b2;
        if (this.c == this.b.length) {
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        this.a.write(this.b, 0, this.c);
        this.c = 0;
        Arrays.fill(this.b, (byte)0);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.a.close();
    }
}

