/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.cipher;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.provider.key.RawSecretKey;
import com.enterprisedt.cryptix.util.core.ArrayUtil;
import com.enterprisedt.cryptix.util.core.Debug;
import java.security.InvalidKeyException;
import java.security.Key;
import xjava.security.Cipher;
import xjava.security.SymmetricCipher;

public final class IDEA
extends Cipher
implements SymmetricCipher {
    private static final boolean b = Debug.GLOBAL_DEBUG;
    private static final int c = b ? Debug.getLevel("IDEA") : 0;
    private short[] d = new short[52];
    private static final byte[][][] e = new byte[][][]{new byte[][]{{0, 1, 0, 2, 0, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8}, {0, 0, 0, 1, 0, 2, 0, 3}, {17, -5, -19, 43, 1, -104, 109, -27}}, new byte[][]{{58, -104, 78, 32, 0, 25, 93, -77, 46, -27, 1, -56, -60, 124, -22, 96}, {1, 2, 3, 4, 5, 6, 7, 8}, {-105, -68, -40, 32, 7, -128, -38, -122}}, new byte[][]{{0, 100, 0, -56, 1, 44, 1, -112, 1, -12, 2, 88, 2, -68, 3, 32}, {5, 50, 10, 100, 20, -56, 25, -6}, {101, -66, -121, -25, -94, 83, -118, -19}}};

    private static void d(String string) {
        Debug.log("IDEA: " + string);
    }

    public IDEA() {
        super(false, false, "CryptixEDT");
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    protected int engineBlockSize() {
        return 8;
    }

    @Override
    protected void engineInitEncrypt(Key key) throws InvalidKeyException, CryptixException {
        this.a(key);
    }

    @Override
    protected void engineInitDecrypt(Key key) throws InvalidKeyException, CryptixException {
        this.a(key);
        this.a();
    }

    @Override
    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        boolean bl;
        if (inLen < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n2 = inLen / 8;
        inLen = n2 * 8;
        boolean bl2 = bl = this.getState() == 1;
        if (in == out && (outOffset >= inOffset && (long)outOffset < (long)inOffset + (long)inLen || inOffset >= outOffset && (long)inOffset < (long)outOffset + (long)inLen)) {
            byte[] byArray = new byte[inLen];
            System.arraycopy(in, inOffset, byArray, 0, inLen);
            in = byArray;
            inOffset = 0;
        }
        if (bl) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.a(in, inOffset, out, outOffset);
                inOffset += 8;
                outOffset += 8;
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                this.b(in, inOffset, out, outOffset);
                inOffset += 8;
                outOffset += 8;
            }
        }
        return inLen;
    }

    private void a(Key key) throws InvalidKeyException, CryptixException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Null user key");
        }
        if (byArray.length != 16) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Invalid user key length");
        }
        this.d[0] = (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
        this.d[1] = (short)((byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF);
        this.d[2] = (short)((byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF);
        this.d[3] = (short)((byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF);
        this.d[4] = (short)((byArray[8] & 0xFF) << 8 | byArray[9] & 0xFF);
        this.d[5] = (short)((byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF);
        this.d[6] = (short)((byArray[12] & 0xFF) << 8 | byArray[13] & 0xFF);
        this.d[7] = (short)((byArray[14] & 0xFF) << 8 | byArray[15] & 0xFF);
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 8; i2 < 52; ++i2) {
            this.d[++n2 + 7 + n3] = (short)(this.d[(n2 & 7) + n3] << 9 | this.d[(n2 + 1 & 7) + n3] >>> 7 & 0x1FF);
            n3 += n2 & 8;
            n2 &= 7;
        }
    }

    private void a() {
        int n2 = 4;
        int n3 = 51;
        short[] sArray = new short[52];
        sArray[n3--] = IDEA.a(this.d[3]);
        sArray[n3--] = -this.d[2];
        sArray[n3--] = -this.d[1];
        sArray[n3--] = IDEA.a(this.d[0]);
        int n4 = 1;
        while (n4 < 8) {
            sArray[n3--] = this.d[n2 + 1];
            sArray[n3--] = this.d[n2];
            sArray[n3--] = IDEA.a(this.d[n2 + 5]);
            sArray[n3--] = -this.d[n2 + 3];
            sArray[n3--] = -this.d[n2 + 4];
            sArray[n3--] = IDEA.a(this.d[n2 + 2]);
            ++n4;
            n2 += 6;
        }
        sArray[n3--] = this.d[n2 + 1];
        sArray[n3--] = this.d[n2];
        sArray[n3--] = IDEA.a(this.d[n2 + 5]);
        sArray[n3--] = -this.d[n2 + 4];
        sArray[n3--] = -this.d[n2 + 3];
        sArray[n3--] = IDEA.a(this.d[n2 + 2]);
        System.arraycopy(sArray, 0, this.d, 0, 52);
    }

    private void a(byte[] byArray, int n2, byte[] byArray2, int n3) {
        short s2;
        short s3 = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
        short s4 = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
        short s5 = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
        short s6 = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF);
        int n4 = 0;
        int n5 = 8;
        while (n5-- > 0) {
            s3 = IDEA.a(s3, this.d[n4++]);
            s4 = (short)(s4 + this.d[n4++]);
            s5 = (short)(s5 + this.d[n4++]);
            s6 = IDEA.a(s6, this.d[n4++]);
            short s7 = s5;
            s5 = IDEA.a(s3 ^ s5, this.d[n4++]);
            s2 = s4;
            s4 = IDEA.a(s5 + (s4 ^ s6), this.d[n4++]);
            s5 = (short)(s5 + s4);
            s3 = (short)(s3 ^ s4);
            s6 = (short)(s6 ^ s5);
            s4 = (short)(s4 ^ s7);
            s5 = (short)(s5 ^ s2);
        }
        s2 = IDEA.a(s3, this.d[n4++]);
        byArray2[n3++] = (byte)(s2 >>> 8);
        byArray2[n3++] = (byte)s2;
        s2 = (short)(s5 + this.d[n4++]);
        byArray2[n3++] = (byte)(s2 >>> 8);
        byArray2[n3++] = (byte)s2;
        s2 = (short)(s4 + this.d[n4++]);
        byArray2[n3++] = (byte)(s2 >>> 8);
        byArray2[n3++] = (byte)s2;
        s2 = IDEA.a(s6, this.d[n4]);
        byArray2[n3++] = (byte)(s2 >>> 8);
        byArray2[n3] = (byte)s2;
    }

    private void b(byte[] byArray, int n2, byte[] byArray2, int n3) {
        this.a(byArray, n2, byArray2, n3);
    }

    private static short a(int n2, int n3) {
        n3 &= 0xFFFF;
        if ((n2 &= 0xFFFF) != 0) {
            if (n3 != 0) {
                int n4 = n2 * n3;
                return (short)(n3 - n2 + ((n3 = n4 & 0xFFFF) < (n2 = n4 >>> 16) ? 1 : 0));
            }
            return (short)(1 - n2);
        }
        return (short)(1 - n3);
    }

    private static short a(short s2) {
        int n2 = s2 & 0xFFFF;
        if (n2 <= 1) {
            return (short)n2;
        }
        int n3 = 65537 / n2;
        int n4 = 65537 % n2;
        if (n4 == 1) {
            return (short)(1 - n3);
        }
        int n5 = 1;
        do {
            int n6 = n2 / n4;
            n5 += n6 * n3;
            if ((n2 %= n4) == 1) {
                return (short)n5;
            }
            n6 = n4 / n2;
            n3 += n6 * n5;
        } while ((n4 %= n2) != 1);
        return (short)(1 - n3);
    }

    public static void main(String[] argv) {
        try {
            IDEA.self_test();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void self_test() throws Throwable {
        Cipher cipher = Cipher.getInstance("IDEA", "CryptixEDT");
        for (int i2 = 0; i2 < e.length; ++i2) {
            RawSecretKey rawSecretKey = new RawSecretKey("IDEA", e[i2][0]);
            cipher.initEncrypt(rawSecretKey);
            byte[] byArray = cipher.crypt(e[i2][1]);
            if (!ArrayUtil.areEqual(e[i2][2], byArray)) {
                throw new CryptixException("encrypt #" + i2 + " failed");
            }
            cipher.initDecrypt(rawSecretKey);
            byArray = cipher.crypt(e[i2][2]);
            if (ArrayUtil.areEqual(e[i2][1], byArray)) continue;
            throw new CryptixException("decrypt #" + i2 + " failed");
        }
        if (b && c > 0) {
            IDEA.d("Self-test OK");
        }
    }
}

