/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.elgamal;

import com.enterprisedt.cryptix.CryptixException;
import java.math.BigInteger;
import java.util.Random;

public final class ElGamalAlgorithm {
    private static final BigInteger a = BigInteger.valueOf(0L);
    private static final BigInteger b = BigInteger.valueOf(1L);

    private ElGamalAlgorithm() {
    }

    public static void encrypt(BigInteger M, BigInteger[] ab, BigInteger p2, BigInteger g2, BigInteger y, Random rng) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = p2.subtract(b);
        do {
            if ((bigInteger = new BigInteger(p2.bitLength() - 1, rng)).testBit(0)) continue;
            bigInteger = bigInteger.setBit(0);
        } while (!bigInteger.gcd(bigInteger2).equals(b));
        ab[0] = g2.modPow(bigInteger, p2);
        ab[1] = y.modPow(bigInteger, p2).multiply(M).mod(p2);
    }

    public static BigInteger decrypt(BigInteger a2, BigInteger b2, BigInteger p2, BigInteger g2, BigInteger x) {
        try {
            return b2.multiply(a2.modPow(x, p2).modInverse(p2)).mod(p2);
        }
        catch (ArithmeticException arithmeticException) {
            throw new CryptixException("ElGamal: " + arithmeticException.getClass().getName() + " while calculating a.modPow(x, p).modInverse(p) - maybe key was not generated properly?");
        }
    }

    public static void sign(BigInteger M, BigInteger[] ab, BigInteger p2, BigInteger g2, BigInteger x, Random rng) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3 = p2.subtract(b);
        do {
            if ((bigInteger2 = new BigInteger(p2.bitLength() - 1, rng)).testBit(0)) continue;
            bigInteger2 = bigInteger2.setBit(0);
        } while (!bigInteger2.gcd(bigInteger3).equals(b));
        ab[0] = bigInteger = g2.modPow(bigInteger2, p2);
        try {
            ab[1] = bigInteger2.modInverse(bigInteger3).multiply(M.subtract(x.multiply(bigInteger)).mod(bigInteger3)).mod(bigInteger3);
        }
        catch (ArithmeticException arithmeticException) {
            throw new CryptixException("ElGamal: ArithmeticException while calculating k.modInverse(p-1)");
        }
    }

    public static boolean verify(BigInteger M, BigInteger a2, BigInteger b2, BigInteger p2, BigInteger g2, BigInteger y) {
        BigInteger bigInteger = p2.subtract(b);
        if (M.compareTo(a) < 0 || M.compareTo(bigInteger) >= 0 || a2.compareTo(a) < 0 || a2.compareTo(bigInteger) >= 0 || b2.compareTo(a) < 0 || b2.compareTo(bigInteger) >= 0) {
            return false;
        }
        return y.modPow(a2, p2).multiply(a2.modPow(b2, p2)).mod(p2).equals(g2.modPow(M, p2));
    }
}

