/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.md;

import com.enterprisedt.cryptix.provider.md.SHA512Base;

public final class SHA384
extends SHA512Base
implements Cloneable {
    public SHA384() {
        super("SHA-384", 48);
    }

    private SHA384(SHA384 src) {
        super(src);
    }

    @Override
    public Object clone() {
        return new SHA384(this);
    }

    @Override
    protected void loadInitialValues(long[] context) {
        context[0] = -3766243637369397544L;
        context[1] = 7105036623409894663L;
        context[2] = -7973340178411365097L;
        context[3] = 1526699215303891257L;
        context[4] = 7436329637833083697L;
        context[5] = -8163818279084223215L;
        context[6] = -2662702644619276377L;
        context[7] = 5167115440072839076L;
    }

    @Override
    protected void generateDigest(long[] context, byte[] buf, int off) {
        for (int i2 = 0; i2 < context.length - 2; ++i2) {
            for (int i3 = 0; i3 < 8; ++i3) {
                buf[off + (i2 * 8 + (7 - i3))] = (byte)(context[i2] >>> 8 * i3);
            }
        }
    }
}

