/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.mode;

import com.enterprisedt.cryptix.provider.mode.a;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;
import xjava.security.Cipher;

public class CTR
extends a {
    protected byte[] feedbackBlock;

    public CTR() {
        super(false, false, "CryptixEDT");
    }

    public CTR(Cipher cipher) {
        this();
        this.engineSetCipher(cipher);
    }

    public CTR(Cipher cipher, byte[] iv) {
        this(cipher);
        this.setInitializationVector(iv);
    }

    @Override
    protected void engineSetCipher(Cipher cipher) {
        super.engineSetCipher(cipher);
        this.feedbackBlock = new byte[this.length];
    }

    @Override
    protected int engineBlockSize() {
        return this.length;
    }

    @Override
    protected void engineInitEncrypt(Key newkey) throws KeyException {
        this.cipher.initEncrypt(newkey);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
    }

    @Override
    protected void engineInitDecrypt(Key newkey) throws KeyException {
        this.cipher.initDecrypt(newkey);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
    }

    @Override
    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        if (this.ivBlock == null) {
            throw new InvalidParameterException("CTR: IV is not set");
        }
        this.cipher.update(this.ivBlock, 0, inLen, this.feedbackBlock, 0);
        int n2 = 1;
        for (int i2 = this.length - 1; i2 >= 0; --i2) {
            out[outOffset + i2] = (byte)(this.feedbackBlock[i2] ^ in[inOffset + i2]);
            int n3 = (this.ivBlock[i2] & 0xFF) + n2;
            this.ivBlock[i2] = (byte)n3;
            n2 = n3 > 255 ? 1 : 0;
        }
        return inLen;
    }
}

