/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.mode;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.provider.mode.a;
import com.enterprisedt.cryptix.util.core.ArrayUtil;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;
import xjava.security.Cipher;

public class PCBC
extends a {
    private byte[] b;

    public PCBC() {
        super(false, false, "CryptixEDT");
    }

    public PCBC(Cipher cipher) {
        this();
        this.engineSetCipher(cipher);
    }

    public PCBC(Cipher cipher, byte[] iv) {
        this(cipher);
        this.setInitializationVector(iv);
    }

    @Override
    protected void engineSetCipher(Cipher cipher) {
        super.engineSetCipher(cipher);
        this.b = new byte[this.length];
    }

    @Override
    protected int engineBlockSize() {
        return this.length;
    }

    @Override
    protected void engineInitEncrypt(Key newkey) throws KeyException {
        this.cipher.initEncrypt(newkey);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
        ArrayUtil.clear(this.b);
    }

    @Override
    protected void engineInitDecrypt(Key newkey) throws KeyException {
        this.cipher.initDecrypt(newkey);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
        ArrayUtil.clear(this.b);
    }

    @Override
    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        if (this.ivBlock == null) {
            throw new InvalidParameterException("PCBC: IV is not set");
        }
        if (inLen <= 0) {
            return 0;
        }
        switch (this.getState()) {
            case 1: {
                for (int i2 = 0; i2 < this.length; ++i2) {
                    int n2 = i2;
                    this.ivBlock[n2] = (byte)(this.ivBlock[n2] ^ in[inOffset + i2]);
                    int n3 = i2;
                    this.b[n3] = (byte)(this.b[n3] ^ this.ivBlock[i2]);
                }
                this.cipher.update(this.b, 0, this.length, this.ivBlock, 0);
                System.arraycopy(this.ivBlock, 0, out, outOffset, this.length);
                System.arraycopy(in, inOffset, this.b, 0, this.length);
                break;
            }
            case 2: {
                this.cipher.update(in, inOffset, this.length, this.b, 0);
                for (int i3 = 0; i3 < this.length; ++i3) {
                    out[outOffset + i3] = (byte)(this.ivBlock[i3] ^ this.b[i3]);
                    this.ivBlock[i3] = (byte)(in[inOffset + i3] ^ out[outOffset + i3]);
                }
                break;
            }
            default: {
                throw new CryptixException("PCBC: Cipher not initialized");
            }
        }
        return this.length;
    }
}

