/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.rsa;

import com.enterprisedt.cryptix.util.core.BI;
import com.enterprisedt.cryptix.util.core.Debug;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.RSAFactors;

public abstract class BaseRSAPrivateKey
implements CryptixRSAPrivateKey,
RSAFactors {
    private static final boolean a = Debug.GLOBAL_DEBUG;
    private static final int b = a ? Debug.getLevel("RSA", "BaseRSAPrivateKey") : 0;
    private static final BigInteger c = BigInteger.valueOf(0L);
    private static final BigInteger d = BigInteger.valueOf(1L);
    private BigInteger e;
    private BigInteger f;
    private BigInteger g;
    private BigInteger h;
    private BigInteger i;

    private static void a(String string) {
        Debug.log("BaseRSAPrivateKey: " + string);
    }

    protected BaseRSAPrivateKey() {
    }

    @Override
    public BigInteger getModulus() {
        return this.e;
    }

    @Override
    public BigInteger getExponent() {
        return this.f;
    }

    @Override
    public BigInteger getP() {
        return this.g;
    }

    @Override
    public BigInteger getQ() {
        return this.h;
    }

    @Override
    public BigInteger getInverseOfQModP() {
        return this.i;
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    protected void setRsaParams(BigInteger n2, BigInteger d2) {
        if (n2 == null) {
            throw new NullPointerException("n == null");
        }
        if (d2 == null) {
            throw new NullPointerException("d == null");
        }
        this.e = n2;
        this.f = d2;
    }

    protected void setRsaParams(BigInteger d2, BigInteger p2, BigInteger q2, BigInteger u2) {
        if (d2 == null) {
            throw new NullPointerException("d == null");
        }
        this.e = p2.multiply(q2);
        this.f = d2;
        this.g = p2;
        this.h = q2;
        if (u2 != null && !u2.multiply(q2).mod(p2).equals(d)) {
            if (a && b >= 1) {
                BaseRSAPrivateKey.a("uq != 1 (mod p)");
            }
            u2 = null;
        }
        if (u2 == null) {
            try {
                u2 = q2.modInverse(p2);
            }
            catch (ArithmeticException arithmeticException) {
                if (a && b >= 1) {
                    if (p2.compareTo(c) <= 0) {
                        BaseRSAPrivateKey.a("p <= 0");
                    }
                    if (p2.equals(q2)) {
                        BaseRSAPrivateKey.a("p == q");
                    }
                    if (!p2.isProbablePrime(80)) {
                        BaseRSAPrivateKey.a("p is composite");
                    }
                    if (!q2.isProbablePrime(80)) {
                        BaseRSAPrivateKey.a("q is composite");
                    }
                }
                throw new InvalidParameterException("gcd(q, p) != 1");
            }
        }
        this.i = u2;
    }

    public String toString() {
        if (a && b >= 5) {
            return "<----- RSAPrivateKey:\n         d: " + BI.dumpString(this.f) + "         p: " + BI.dumpString(this.g) + "         q: " + BI.dumpString(this.h) + "q^-1 mod p: " + BI.dumpString(this.i) + "----->\n";
        }
        return "<BaseRSAPrivateKey>";
    }
}

