/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.rsa;

import java.math.BigInteger;

public final class RSAAlgorithm {
    private static final BigInteger a = BigInteger.valueOf(1L);

    private RSAAlgorithm() {
    }

    public static BigInteger rsa(BigInteger X, BigInteger n2, BigInteger exp, BigInteger p2, BigInteger q2, BigInteger u2) {
        if (p2 == null) {
            return RSAAlgorithm.rsa(X, n2, exp);
        }
        BigInteger bigInteger = exp.mod(p2.subtract(a));
        BigInteger bigInteger2 = exp.mod(q2.subtract(a));
        return RSAAlgorithm.rsa(X, n2, exp, p2, q2, bigInteger, bigInteger2, u2);
    }

    public static BigInteger rsa(BigInteger X, BigInteger modulus, BigInteger exp, BigInteger primeP, BigInteger primeQ, BigInteger primeExponentP, BigInteger primeExponentQ, BigInteger crtCoefficient) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (!crtCoefficient.equals(primeQ.modInverse(primeP))) {
            bigInteger2 = primeQ;
            primeQ = primeP;
            primeP = bigInteger2;
            bigInteger2 = primeExponentQ;
            primeExponentQ = primeExponentP;
            primeExponentP = bigInteger2;
        }
        if ((bigInteger2 = X.mod(primeP).modPow(primeExponentP, primeP)).equals(bigInteger = X.mod(primeQ).modPow(primeExponentQ, primeQ))) {
            return bigInteger;
        }
        BigInteger bigInteger3 = bigInteger2.subtract(bigInteger).mod(primeP);
        BigInteger bigInteger4 = bigInteger3.multiply(crtCoefficient).mod(primeP);
        return primeQ.multiply(bigInteger4).add(bigInteger);
    }

    public static BigInteger rsa(BigInteger X, BigInteger n2, BigInteger exp) {
        return X.modPow(exp, n2);
    }
}

