/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.rsa;

import com.enterprisedt.cryptix.provider.rsa.a;
import com.enterprisedt.cryptix.util.core.ArrayUtil;
import com.enterprisedt.net.puretls.crypto.Blindable;
import com.enterprisedt.net.puretls.crypto.PKCS1Pad;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import xjava.security.IllegalBlockSizeException;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.CryptixRSAPublicKey;
import xjava.security.interfaces.RSAFactors;

public class RSASignature
extends Signature
implements Blindable {
    protected byte[] data = null;
    private BigInteger a;
    private BigInteger b;
    private BigInteger c;
    private BigInteger d;
    private BigInteger e;
    private BigInteger f;
    private SecureRandom g = null;

    public RSASignature(String name) {
        super(name);
    }

    public RSASignature() {
        super("RawRSAPKCS#1");
    }

    @Override
    protected void engineInitVerify(PublicKey key) throws InvalidKeyException {
        if (!(key instanceof CryptixRSAPublicKey)) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Not a RSA Public Key");
        }
        CryptixRSAPublicKey cryptixRSAPublicKey = (CryptixRSAPublicKey)key;
        this.a = cryptixRSAPublicKey.getModulus();
        this.b = cryptixRSAPublicKey.getExponent();
    }

    @Override
    protected void engineInitSign(PrivateKey key) throws InvalidKeyException {
        if (!(key instanceof CryptixRSAPrivateKey)) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Not a RSA Private Key");
        }
        CryptixRSAPrivateKey cryptixRSAPrivateKey = (CryptixRSAPrivateKey)key;
        this.a = cryptixRSAPrivateKey.getModulus();
        this.b = cryptixRSAPrivateKey.getExponent();
        if (key instanceof RSAFactors) {
            RSAFactors rSAFactors = (RSAFactors)((Object)key);
            this.d = rSAFactors.getP();
            this.e = rSAFactors.getQ();
            this.f = rSAFactors.getInverseOfQModP();
        }
    }

    @Override
    protected void engineUpdate(byte b2) throws SignatureException {
        throw new SignatureException(this.getAlgorithm() + ": Must be called with a complete input");
    }

    @Override
    protected void engineUpdate(byte[] b2, int off, int len) throws SignatureException {
        if (this.data != null) {
            throw new SignatureException(this.getAlgorithm() + ": Raw RSA may only be updated once");
        }
        this.data = new byte[len];
        System.arraycopy(b2, off, this.data, 0, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (this.data == null) {
            throw new SignatureException(this.getAlgorithm() + ": Must supply input");
        }
        byte[] byArray = PKCS1Pad.pkcs1PadBuf(this.data, this.a, 2);
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = com.enterprisedt.cryptix.provider.rsa.a.a(bigInteger, this.a, this.b, this.c, this.d, this.e, this.f, this.g);
        byte[] byArray2 = this.sigToBytes(bigInteger2);
        return byArray2;
    }

    @Override
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        if (this.data == null) {
            throw new SignatureException(this.getAlgorithm() + ": Must supply input");
        }
        if (signature.length != this.a()) {
            throw new IllegalBlockSizeException("Wrong input length");
        }
        BigInteger bigInteger = new BigInteger(1, signature);
        if (bigInteger.compareTo(this.a) > 0) {
            throw new IllegalBlockSizeException("Signature greater than modulus");
        }
        byte[] byArray = com.enterprisedt.cryptix.provider.rsa.a.a(bigInteger, this.a, this.b, null, this.d, this.e, this.f, null).toByteArray();
        byte[] byArray2 = null;
        try {
            byArray2 = PKCS1Pad.pkcs1UnpadBuf(byArray, 2, this.a);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            return false;
        }
        return ArrayUtil.areEqual(byArray2, this.data);
    }

    @Override
    public void setBlindingInfo(SecureRandom rng, CryptixRSAPublicKey pubKey) {
        this.g = rng;
        this.c = pubKey.getExponent();
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException(this.getAlgorithm() + ": No settable parameters");
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException(this.getAlgorithm() + ": No settable parameters");
    }

    protected byte[] sigToBytes(BigInteger num) {
        int n2;
        byte[] byArray = num.toByteArray();
        if (byArray.length == (n2 = this.a())) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        if (byArray.length < n2) {
            int n3;
            for (n3 = 0; n3 < n2 - byArray.length; ++n3) {
                byArray2[n3] = 0;
            }
            System.arraycopy(byArray, 0, byArray2, n3, byArray.length);
        } else {
            int n4;
            for (n4 = 0; n4 < byArray.length - n2; ++n4) {
                if (byArray[n4] == 0) continue;
                throw new InternalError("RSA signature error");
            }
            System.arraycopy(byArray, n4, byArray2, 0, n2);
        }
        return byArray2;
    }

    private int a() {
        int n2 = this.a.bitLength() / 8;
        return n2 += this.a.bitLength() % 8 > 0 ? 1 : 0;
    }
}

