/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.rsa;

import com.enterprisedt.cryptix.provider.rsa.BaseRSAPrivateKey;
import com.enterprisedt.cryptix.util.core.BI;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class RawRSAPrivateKey
extends BaseRSAPrivateKey {
    public RawRSAPrivateKey(BigInteger n2, BigInteger d2) {
        this.setRsaParams(n2, d2);
    }

    public RawRSAPrivateKey(BigInteger d2, BigInteger p2, BigInteger q2) {
        this.setRsaParams(d2, p2, q2, null);
    }

    public RawRSAPrivateKey(BigInteger d2, BigInteger p2, BigInteger q2, BigInteger u2) {
        this.setRsaParams(d2, p2, q2, u2);
    }

    public RawRSAPrivateKey(InputStream is) throws IOException {
        BigInteger bigInteger = BI.fromStream(is);
        BigInteger bigInteger2 = BI.fromStream(is);
        BigInteger bigInteger3 = BI.fromStream(is);
        BigInteger bigInteger4 = BI.fromStream(is);
        this.setRsaParams(bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        try {
            BI.toStream(this.getExponent(), bufferedOutputStream);
            BI.toStream(this.getP(), bufferedOutputStream);
            BI.toStream(this.getQ(), bufferedOutputStream);
            BI.toStream(this.getInverseOfQModP(), bufferedOutputStream);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

