/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.util.core;

import com.enterprisedt.cryptix.util.core.Hex;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class BI {
    private BI() {
    }

    public static BigInteger fromStream(InputStream is) throws IOException {
        int n2 = is.read() << 8 | is.read();
        byte[] byArray = new byte[(n2 + 7) / 8];
        is.read(byArray);
        return new BigInteger(1, byArray);
    }

    public static void toStream(BigInteger x, OutputStream os) throws IOException {
        int n2 = x.bitLength();
        os.write(n2 >>> 8);
        os.write(n2 & 0xFF);
        os.write(BI.getMagnitude(x));
    }

    public static byte[] getMagnitude(BigInteger x) {
        int n2;
        byte[] byArray = x.toByteArray();
        for (n2 = 0; byArray[n2] == 0 && n2 < byArray.length - 1; ++n2) {
        }
        byte[] byArray2 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray.length - n2);
        return byArray2;
    }

    public static String dumpString(BigInteger x, String m2) {
        if (x == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(m2).append("Multi-Precision Integer ").append(x.bitLength()).append(" bits long...\n");
        stringBuffer.append(m2).append("      sign: ");
        if (x.signum() == -1) {
            stringBuffer.append("Negative\n");
        } else {
            stringBuffer.append("Positive\n");
        }
        stringBuffer.append(m2).append(" magnitude: ").append(Hex.dumpString(BI.getMagnitude(x))).append('\n');
        return stringBuffer.toString();
    }

    public static String dumpString(BigInteger x) {
        return BI.dumpString(x, "");
    }
}

