/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.util.math;

import com.enterprisedt.cryptix.util.core.ArrayUtil;
import java.io.Serializable;
import java.security.SecureRandom;

public class BigRegister
implements Serializable,
Cloneable {
    public static final int MAXIMUM_SIZE = 4096;
    private static final byte[] a = new byte[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] b = new byte[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3};
    private static final byte[] c = new byte[]{0, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};
    private static final String[] d = new String[]{"0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"};
    private static final SecureRandom e = new SecureRandom();
    private byte[] f;
    private int g;
    private static final long serialVersionUID = 2535877383275048954L;

    public BigRegister(int size) {
        if (size < 2) {
            throw new IllegalArgumentException("size < 2");
        }
        if (size > 4096) {
            throw new IllegalArgumentException("size > MAXIMUM_SIZE");
        }
        this.g = size;
        this.f = new byte[(size + 7) / 8];
    }

    private BigRegister(BigRegister r2) {
        this.g = r2.g;
        this.f = (byte[])r2.f.clone();
    }

    public synchronized Object clone() {
        return new BigRegister(this);
    }

    public synchronized void and(BigRegister source) {
        if (this.g != source.g) {
            throw new IllegalArgumentException();
        }
        for (int i2 = 0; i2 < this.f.length; ++i2) {
            int n2 = i2;
            this.f[n2] = (byte)(this.f[n2] & source.f[i2]);
        }
    }

    public synchronized void andNot(BigRegister source) {
        if (this.g != source.g) {
            throw new IllegalArgumentException();
        }
        for (int i2 = 0; i2 < this.f.length; ++i2) {
            int n2 = i2;
            this.f[n2] = (byte)(this.f[n2] & ~source.f[i2]);
        }
    }

    public synchronized void or(BigRegister source) {
        if (this.g != source.g) {
            throw new IllegalArgumentException();
        }
        for (int i2 = 0; i2 < this.f.length; ++i2) {
            int n2 = i2;
            this.f[n2] = (byte)(this.f[n2] | source.f[i2]);
        }
        this.a();
    }

    public synchronized void not() {
        for (int i2 = 0; i2 < this.f.length; ++i2) {
            this.f[i2] = ~this.f[i2];
        }
        this.a();
    }

    public synchronized void xor(BigRegister source) {
        if (this.g != source.g) {
            throw new IllegalArgumentException();
        }
        for (int i2 = 0; i2 < this.f.length; ++i2) {
            int n2 = i2;
            this.f[n2] = (byte)(this.f[n2] ^ source.f[i2]);
        }
        this.a();
    }

    public synchronized void shiftLeft(int n2) {
        if (n2 == 0) {
            return;
        }
        if (n2 < 0) {
            this.shiftRight(-n2);
            return;
        }
        if (n2 >= this.g) {
            this.reset();
            return;
        }
        int n3 = this.lowestSetBit();
        if (n3 == -1) {
            return;
        }
        if (n3 >= this.g - n2) {
            this.reset();
            return;
        }
        n3 = n2 / 8;
        int n4 = n2 % 8;
        int n5 = this.f.length;
        byte[] byArray = new byte[n5];
        if (n4 == 0) {
            System.arraycopy(this.f, 0, byArray, n3, n5 - n3);
        } else {
            int n6 = 8 - n4;
            int n7 = n3;
            int n8 = 0;
            while (n7 < n5) {
                byArray[n7] = (byte)(this.f[n8] << n4 | (n8 == 0 ? 0 : (this.f[n8 - 1] & 0xFF) >>> n6));
                ++n7;
                ++n8;
            }
        }
        this.f = byArray;
        this.a();
    }

    public synchronized void shiftRight(int n2) {
        if (n2 == 0) {
            return;
        }
        if (n2 < 0) {
            this.shiftLeft(-n2);
            return;
        }
        if (n2 >= this.g) {
            this.reset();
            return;
        }
        int n3 = this.highestSetBit();
        if (n3 < 0) {
            return;
        }
        if (n3 < n2) {
            this.reset();
            return;
        }
        n3 = n2 / 8;
        int n4 = n2 % 8;
        int n5 = this.f.length;
        byte[] byArray = new byte[n5];
        if (n4 == 0) {
            System.arraycopy(this.f, n3, byArray, 0, n5 - n3);
        } else {
            int n6 = 0;
            for (int i2 = n3; n6 < n5 && i2 < n5; ++n6, ++i2) {
                byArray[n6] = (byte)(((i2 == n5 - 1 ? 0 : this.f[i2 + 1] << 8) | this.f[i2] & 0xFF) >>> n4);
            }
        }
        this.f = byArray;
        this.a();
    }

    public synchronized void rotateLeft(int n2) {
        if ((n2 %= this.g) == 0) {
            return;
        }
        if (n2 < 0) {
            this.rotateRight(-n2);
        } else {
            BigRegister bigRegister = (BigRegister)this.clone();
            bigRegister.shiftRight(this.g - n2);
            this.shiftLeft(n2);
            this.or(bigRegister);
        }
    }

    public synchronized void rotateRight(int n2) {
        if ((n2 %= this.g) == 0) {
            return;
        }
        if (n2 < 0) {
            this.rotateLeft(-n2);
        } else {
            BigRegister bigRegister = (BigRegister)this.clone();
            bigRegister.shiftLeft(this.g - n2);
            this.shiftRight(n2);
            this.or(bigRegister);
        }
    }

    public synchronized void invertOrder() {
        byte[] byArray = new byte[this.f.length];
        int n2 = 0;
        int n3 = this.g - 1;
        while (n2 < this.g) {
            if (this.testBit(n2)) {
                int n4 = n3 / 8;
                byArray[n4] = (byte)(byArray[n4] | 1 << n3 % 8);
            }
            ++n2;
            --n3;
        }
        this.f = byArray;
    }

    public synchronized boolean testBit(int n2) {
        if (n2 < 0 || n2 > this.g) {
            throw new IllegalArgumentException();
        }
        return (this.f[n2 / 8] & 1 << n2 % 8) != 0;
    }

    public synchronized boolean isSameValue(BigRegister x) {
        if (x.g != this.g) {
            return false;
        }
        return ArrayUtil.areEqual(this.f, x.f);
    }

    public synchronized int compareTo(BigRegister x) {
        if (this.g > x.g) {
            return 1;
        }
        if (this.g < x.g) {
            return -1;
        }
        return ArrayUtil.compared(this.f, x.f, true);
    }

    public synchronized void setBit(int n2) {
        if (n2 < 0 || n2 > this.g) {
            throw new IllegalArgumentException();
        }
        int n3 = n2 / 8;
        this.f[n3] = (byte)(this.f[n3] | 1 << n2 % 8);
    }

    public synchronized void setBits(int n2, int count, long value) {
        if (n2 < 0 || n2 > this.g || count < 1 || count > 64 || n2 + count > this.g) {
            throw new IllegalArgumentException();
        }
        int n3 = 0;
        int n4 = n2;
        while (n3 < count) {
            if ((value & 1L) == 1L) {
                int n5 = n4 / 8;
                this.f[n5] = (byte)(this.f[n5] | 1 << n4 % 8);
            }
            value >>>= 1;
            ++n3;
            ++n4;
        }
    }

    public synchronized void clearBit(int n2) {
        if (n2 < 0 || n2 > this.g) {
            throw new IllegalArgumentException();
        }
        int n3 = n2 / 8;
        this.f[n3] = (byte)(this.f[n3] & ~(1 << n2 % 8));
    }

    public synchronized void flipBit(int n2) {
        if (n2 < 0 || n2 > this.g) {
            throw new IllegalArgumentException();
        }
        int n3 = n2 / 8;
        this.f[n3] = (byte)(this.f[n3] ^ 1 << n2 % 8);
    }

    public synchronized int getBit(int n2) {
        if (n2 < 0 || n2 > this.g) {
            throw new IllegalArgumentException();
        }
        return (this.f[n2 / 8] & 0xFF) >> n2 % 8 & 1;
    }

    public synchronized long getBits(int n2, int count) {
        if (n2 < 0 || n2 > this.g || count < 1 || count > 64 || n2 + count > this.g) {
            throw new IllegalArgumentException();
        }
        long l2 = 0L;
        int n3 = 0;
        int n4 = n2 + count - 1;
        while (n3 < count) {
            l2 = l2 << 1 | (long)((this.f[n4 / 8] & 0xFF) >> n4 % 8 & 1);
            ++n3;
            --n4;
        }
        return l2;
    }

    public synchronized int byteValue() {
        return this.f[0] & 0xFF;
    }

    public synchronized int intValue() {
        int n2 = 0;
        int n3 = this.f[n2++] & 0xFF;
        try {
            n3 |= (this.f[n2++] & 0xFF) << 8 | (this.f[n2++] & 0xFF) << 16 | (this.f[n2] & 0xFF) << 24;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return n3;
    }

    public synchronized long longValue() {
        int n2 = 0;
        long l2 = (long)this.f[n2++] & 0xFFL;
        try {
            l2 |= ((long)this.f[n2++] & 0xFFL) << 8 | ((long)this.f[n2++] & 0xFFL) << 16 | ((long)this.f[n2++] & 0xFFL) << 24 | ((long)this.f[n2++] & 0xFFL) << 32 | ((long)this.f[n2++] & 0xFFL) << 40 | ((long)this.f[n2++] & 0xFFL) << 48 | ((long)this.f[n2] & 0xFFL) << 56;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return l2;
    }

    public synchronized BigRegister valueOf(long n2) {
        BigRegister bigRegister = new BigRegister(this.g);
        int n3 = Math.min(8, this.f.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            bigRegister.f[i2] = (byte)(n2 >>> 8 * i2);
        }
        bigRegister.a();
        return bigRegister;
    }

    public synchronized void reset() {
        ArrayUtil.clear(this.f);
    }

    public synchronized void atRandom() {
        this.atRandom(e);
    }

    public synchronized void atRandom(SecureRandom source) {
        source.nextBytes(this.f);
        this.a();
    }

    public synchronized void load(BigRegister source) {
        if (this.g != source.g) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(source.f, 0, this.f, 0, this.f.length);
    }

    public synchronized void load(byte[] source) {
        int n2 = source.length;
        int n3 = this.f.length;
        if (n2 > n3) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(source, 0, this.f, 0, n2);
        if (n2 < n3) {
            ArrayUtil.clear(this.f, n2, n3 - n2);
        }
        this.a();
    }

    public synchronized byte[] toByteArray() {
        return (byte[])this.f.clone();
    }

    public synchronized int getSize() {
        return this.g;
    }

    public synchronized int countSetBits() {
        int n2 = 0;
        for (byte by : this.f) {
            n2 += by < 0 ? 8 : a[by & 0xFF];
        }
        return n2;
    }

    public synchronized int highestSetBit() {
        int n2;
        for (n2 = this.f.length - 1; n2 > 0 && this.f[n2] == 0; --n2) {
        }
        if (this.f[n2] == 0) {
            return -1;
        }
        int n3 = this.f[n2] >>> 4 & 0xF;
        int n4 = 4;
        if (n3 == 0) {
            n3 = this.f[n2] & 0xF;
            n4 -= 4;
        }
        return n2 * 8 + (n4 += b[n3]);
    }

    public synchronized int lowestSetBit() {
        int n2;
        int n3 = this.f.length;
        for (n2 = 0; n2 < n3 && this.f[n2] == 0; ++n2) {
        }
        if (n2 == n3) {
            return -1;
        }
        int n4 = this.f[n2] & 0xF;
        int n5 = 0;
        if (n4 == 0) {
            n4 = this.f[n2] >>> 4 & 0xF;
            n5 += 4;
        }
        return n2 * 8 + (n5 += c[n4]);
    }

    public synchronized String toString() {
        int n2;
        int n3;
        String string;
        StringBuffer stringBuffer = new StringBuffer(8 * this.f.length + 64);
        stringBuffer.append("Binary dump of a BigRegister [").append(this.g).append("-bit]...\n");
        stringBuffer.append("Byte #:|........|........|........|........|........|........|........|........|\n");
        int n4 = this.f.length;
        int n5 = n4-- % 8;
        if (n5 != 0) {
            string = "      " + String.valueOf(this.f.length);
            stringBuffer.append(string.substring(string.length() - 6)).append(':');
            for (n3 = 0; n3 < 8 - n5; ++n3) {
                stringBuffer.append("         ");
            }
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = this.f[n4--] & 0xFF;
                stringBuffer.append(' ').append(d[n2 >>> 4 & 0xF]).append(d[n2 & 0xF]);
            }
            stringBuffer.append('\n');
        }
        int n6 = (n4 + 1) / 8;
        for (n3 = 0; n3 < n6; ++n3) {
            string = "      " + String.valueOf(8 * (n6 - n3));
            stringBuffer.append(string.substring(string.length() - 6)).append(':');
            for (int i2 = 0; i2 < 8; ++i2) {
                n2 = this.f[n4--] & 0xFF;
                stringBuffer.append(' ').append(d[n2 >>> 4 & 0xF]).append(d[n2 & 0xF]);
            }
            stringBuffer.append('\n');
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    private synchronized void a() {
        int n2 = 8 - this.g % 8;
        if (n2 != 8) {
            int n3 = this.f.length - 1;
            this.f[n3] = (byte)(this.f[n3] & 255 >>> n2);
        }
    }
}

