/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.ControlChannelIOException;
import com.enterprisedt.net.ftp.DataChannelCallback;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPConnectionClosedException;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.IPEndpoint;
import com.enterprisedt.net.ftp.internal.FTPActiveDataSocket;
import com.enterprisedt.net.ftp.internal.FTPDataSocket;
import com.enterprisedt.net.ftp.internal.FTPPassiveDataSocket;
import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.proxy.PlainSocket;
import com.enterprisedt.util.proxy.StreamSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Random;
import java.util.Vector;

public class FTPControlSocket {
    public static final String cvsId = "@(#)$Id: FTPControlSocket.java,v 1.69 2017/10/25 11:05:53 bruceb Exp $";
    public static final int MAX_ACTIVE_RETRY = 100;
    public static final int CONTROL_PORT = 21;
    protected static final String EPSV_START = "(|||";
    protected static final String EPSV_END = "|)";
    private static Logger a = Logger.getLogger("FTPControlSocket");
    private boolean b = true;
    protected boolean listenOnAllInterfaces = true;
    protected StreamSocket controlSock = null;
    protected Writer writer = null;
    protected Reader reader = null;
    private FTPMessageListener c = null;
    protected String forcedActiveIP;
    private int d = -1;
    private int e = -1;
    private int f = 0;
    private String g;
    protected InetAddress remoteAddr;
    protected boolean autoPassiveIPSubstitution = false;
    protected DataChannelCallback dataChannelCallback = null;

    protected FTPControlSocket(InetAddress remoteAddr, int controlPort, int timeout, String encoding, FTPMessageListener messageListener) throws IOException, FTPException {
        this(remoteAddr, PlainSocket.createPlainSocket(remoteAddr, controlPort, timeout), timeout, encoding, messageListener);
    }

    protected FTPControlSocket(InetAddress remoteAddr, StreamSocket controlSock, int timeout, String encoding, FTPMessageListener messageListener) throws IOException, FTPException {
        this.remoteAddr = remoteAddr;
        this.controlSock = controlSock;
        this.c = messageListener;
        this.g = encoding;
        try {
            this.a(timeout);
            this.initStreams();
            this.c();
        }
        catch (IOException iOException) {
            a.error("Failed to initialize control socket", iOException);
            controlSock.close();
            controlSock = null;
            throw iOException;
        }
        catch (FTPException fTPException) {
            a.error("Failed to initialize control socket", fTPException);
            controlSock.close();
            controlSock = null;
            throw fTPException;
        }
    }

    protected void setAutoPassiveIPSubstitution(boolean autoPassiveIPSubstitution) {
        this.autoPassiveIPSubstitution = autoPassiveIPSubstitution;
    }

    private void c() throws IOException, FTPException {
        FTPReply fTPReply = this.b();
        String[] stringArray = new String[]{"220", "230"};
        this.validateReply(fTPReply, stringArray);
    }

    protected void initStreams() throws IOException {
        InputStream inputStream = this.controlSock.getInputStream();
        this.reader = new InputStreamReader(inputStream, this.g);
        OutputStream outputStream = this.controlSock.getOutputStream();
        this.writer = new OutputStreamWriter(outputStream, this.g);
    }

    public boolean isSecureMode() {
        return false;
    }

    void a(boolean bl) {
        this.b = bl;
    }

    void b(boolean bl) {
        this.listenOnAllInterfaces = bl;
    }

    void a(int n2) throws IOException {
        if (this.controlSock == null) {
            throw new IllegalStateException("Failed to set timeout - no control socket");
        }
        this.controlSock.setSoTimeout(n2);
    }

    void a(FTPMessageListener fTPMessageListener) {
        this.c = fTPMessageListener;
    }

    public void close() throws IOException {
        this.controlSock.close();
    }

    public void logout() throws IOException {
        IOException iOException = null;
        try {
            this.writer.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        try {
            this.reader.close();
        }
        catch (IOException iOException3) {
            iOException = iOException3;
        }
        try {
            this.controlSock.close();
        }
        catch (IOException iOException4) {
            iOException = iOException4;
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    FTPDataSocket a(FTPConnectMode fTPConnectMode) throws IOException, FTPException {
        if (fTPConnectMode == FTPConnectMode.ACTIVE) {
            return this.a();
        }
        return this.createDataSocketPASV();
    }

    FTPDataSocket a() throws IOException, FTPException {
        try {
            int n2;
            int n3 = 0;
            int n4 = 100;
            if (this.d >= 0 && this.e >= 0 && (n2 = this.e - this.d + 1) < 100) {
                n4 = n2;
            }
            while (n3 < n4) {
                ++n3;
                try {
                    FTPDataSocket fTPDataSocket = this.newActiveDataSocket(this.f);
                    int n5 = fTPDataSocket.getLocalPort();
                    InetAddress inetAddress = fTPDataSocket.getLocalAddress();
                    this.a(inetAddress, n5);
                    FTPDataSocket fTPDataSocket2 = fTPDataSocket;
                    return fTPDataSocket2;
                }
                catch (SocketException socketException) {
                    if (n3 >= n4) continue;
                    a.warn("Detected socket in use - retrying and selecting new port");
                    this.d();
                }
            }
            throw new FTPException("Exhausted active port retry count - giving up");
        }
        finally {
            this.d();
        }
    }

    private void d() {
        if (this.d < 0 && this.e < 0) {
            return;
        }
        this.f = this.f == 0 ? this.d + new Random().nextInt(this.e - this.d) : ++this.f;
        if (this.f > this.e) {
            this.f = this.d;
        }
        a.debug("Next active port will be: " + this.f);
    }

    void a(InetAddress inetAddress, int n2) throws IOException, FTPException {
        this.setDataPort(inetAddress, n2);
    }

    private short a(byte by) {
        return by < 0 ? (short)(by + 256) : (short)by;
    }

    protected byte[] toByteArray(int value) {
        byte[] byArray = new byte[]{(byte)(value >> 8), (byte)(value & 0xFF)};
        return byArray;
    }

    void a(DataChannelCallback dataChannelCallback) {
        this.dataChannelCallback = dataChannelCallback;
    }

    void a(String string) {
        this.forcedActiveIP = string;
    }

    public void setActivePortRange(int lowest, int highest) {
        this.d = lowest;
        this.e = highest;
        this.f = this.d;
    }

    private byte[] d(String string) throws FTPException {
        byte[] byArray = new byte[4];
        int n2 = string.length();
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2 && n3 <= 4; ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isDigit(c2)) {
                stringBuffer.append(c2);
            } else if (c2 != '.') {
                throw new FTPException("Incorrectly formatted IP address: " + string);
            }
            if (c2 != '.' && i2 + 1 != n2) continue;
            try {
                byArray[n3++] = (byte)Integer.parseInt(stringBuffer.toString());
                stringBuffer.setLength(0);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new FTPException("Incorrectly formatted IP address: " + string);
            }
        }
        return byArray;
    }

    protected void setDataPort(InetAddress host, int portNo) throws IOException, FTPException {
        Object object;
        Object object2;
        String string = host.getHostAddress();
        byte[] byArray = host.getAddress();
        byte[] byArray2 = this.toByteArray(portNo);
        if (this.forcedActiveIP != null) {
            a.info("Forcing use of fixed IP for PORT command");
            byArray = this.d(this.forcedActiveIP);
            string = this.forcedActiveIP;
        }
        if (this.dataChannelCallback != null) {
            object2 = new IPEndpoint(string, portNo);
            object = this.dataChannelCallback.onPORTCommand((IPEndpoint)object2);
            byArray = this.d(((IPEndpoint)object).getIPAddress());
            byArray2 = this.toByteArray(((IPEndpoint)object).getPort());
            a.info("Changed PORT endpoint from " + ((IPEndpoint)object2).toString() + " => " + ((IPEndpoint)object).toString());
        }
        object2 = new StringBuffer("PORT ").append(this.a(byArray[0])).append(",").append(this.a(byArray[1])).append(",").append(this.a(byArray[2])).append(",").append(this.a(byArray[3])).append(",").append(this.a(byArray2[0])).append(",").append(this.a(byArray2[1])).toString();
        object = this.sendCommand((String)object2);
        String[] stringArray = new String[]{"200", "250"};
        this.validateReply((FTPReply)object, stringArray);
    }

    protected FTPDataSocket createDataSocketPASV() throws IOException, FTPException {
        Object object;
        FTPReply fTPReply = this.sendCommand("PASV");
        this.validateReply(fTPReply, "227");
        String string = fTPReply.getReplyText();
        int[] nArray = this.b(string);
        String string2 = nArray[0] + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
        int n2 = (nArray[4] << 8) + nArray[5];
        String string3 = string2;
        if (this.autoPassiveIPSubstitution) {
            if (this.usingProxy()) {
                string3 = this.controlSock.getRemoteHost();
                a.debug("Using proxy");
            } else {
                string3 = this.remoteAddr.getHostAddress();
            }
            if (!string2.equals(string3)) {
                object = new StringBuffer("Substituting server supplied IP (");
                ((StringBuffer)object).append(string2).append(") with remote host IP (").append(string3).append(")");
                a.info(((StringBuffer)object).toString());
            }
        }
        if (this.dataChannelCallback != null) {
            object = new IPEndpoint(string3, n2);
            IPEndpoint iPEndpoint = this.dataChannelCallback.onPASVResponse((IPEndpoint)object);
            string3 = iPEndpoint.getIPAddress();
            n2 = iPEndpoint.getPort();
            a.info("Changed PASV endpoint from " + ((IPEndpoint)object).toString() + " => " + iPEndpoint.toString());
        }
        return this.newPassiveDataSocket(string3, n2);
    }

    protected boolean usingProxy() {
        return false;
    }

    int[] b(String string) throws FTPException {
        int n2 = string.indexOf(40);
        int n3 = string.indexOf(41);
        if (n2 < 0) {
            for (n2 = 0; n2 < string.length() && !Character.isDigit(string.charAt(n2)); ++n2) {
            }
            --n2;
        }
        if (n3 < 0) {
            for (n3 = string.length() - 1; n3 > 0 && !Character.isDigit(string.charAt(n3)); --n3) {
            }
            if (++n3 >= string.length()) {
                string = string + ")";
            }
        }
        String string2 = string.substring(n2 + 1, n3).trim();
        int[] nArray = new int[6];
        int n4 = string2.length();
        int n5 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n4 && n5 <= 6; ++i2) {
            char c2 = string2.charAt(i2);
            if (Character.isDigit(c2)) {
                stringBuffer.append(c2);
            } else if (c2 != ',' && c2 != ' ') {
                throw new FTPException("Malformed PASV reply: " + string);
            }
            if (c2 != ',' && i2 + 1 != n4) continue;
            try {
                nArray[n5++] = Integer.parseInt(stringBuffer.toString());
                stringBuffer.setLength(0);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new FTPException("Malformed PASV reply: " + string);
            }
        }
        return nArray;
    }

    protected FTPDataSocket newPassiveDataSocket(String remoteHost, int port) throws IOException {
        return new FTPPassiveDataSocket(remoteHost, port, this.controlSock.getSoTimeout());
    }

    protected FTPDataSocket newActiveDataSocket(int port) throws IOException {
        ServerSocket serverSocket = this.listenOnAllInterfaces ? new ServerSocket(port) : new ServerSocket(port, 0, this.controlSock.getLocalAddress());
        a.debug("ListenOnAllInterfaces=" + this.listenOnAllInterfaces);
        serverSocket.setSoTimeout(this.controlSock.getSoTimeout());
        FTPActiveDataSocket fTPActiveDataSocket = new FTPActiveDataSocket(serverSocket);
        fTPActiveDataSocket.setLocalAddress(this.controlSock.getLocalAddress());
        return fTPActiveDataSocket;
    }

    public FTPReply sendCommand(String command) throws IOException, IOException, FTPException {
        this.c(command);
        return this.b();
    }

    void c(String string) throws IOException {
        this.a("---> " + string, true);
        try {
            this.writer.write(string + "\r\n");
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new ControlChannelIOException(iOException.getMessage());
        }
    }

    private String e() throws IOException {
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (true) {
            try {
                n2 = this.reader.read();
            }
            catch (IOException iOException) {
                a.error("Read failed ('" + stringBuffer2.toString() + "' read so far)");
                throw new ControlChannelIOException(iOException.getMessage());
            }
            if (n2 < 0) {
                String string = "Control channel unexpectedly closed ('" + stringBuffer2.toString() + "' read so far)";
                a.error(string);
                throw new ControlChannelIOException(string);
            }
            if (n2 == 10) break;
            if (n2 != 13) {
                stringBuffer.append((char)n2);
                stringBuffer2.append((char)n2);
                continue;
            }
            stringBuffer2.append("<cr>");
        }
        return stringBuffer.toString();
    }

    private String e(String string) {
        int n2 = 0;
        for (int i2 = 0; i2 < string.length() && !Character.isDigit(string.charAt(i2)); ++i2) {
            ++n2;
        }
        if (n2 > 0) {
            string = n2 == string.length() ? "" : string.substring(n2);
        }
        return string;
    }

    FTPReply b() throws IOException, FTPException {
        String string = this.e();
        while (string.length() == 0) {
            string = this.e();
        }
        string = this.e(string);
        this.a(string, false);
        String string2 = string.substring(0, 3);
        StringBuffer stringBuffer = new StringBuffer("");
        if (string.length() > 3) {
            stringBuffer.append(string.substring(4));
        }
        Vector<String> vector = null;
        if (string.length() > 3 && string.charAt(3) == '-') {
            vector = new Vector<String>();
            if (string.length() > 4 && (string = string.substring(4).trim()).length() > 0) {
                vector.addElement(string);
            }
            boolean bl = false;
            while (!bl) {
                string = this.e();
                if (string == null) {
                    String string3 = "Control channel unexpectedly closed";
                    a.error(string3);
                    throw new ControlChannelIOException(string3);
                }
                if (string.length() == 0) continue;
                this.a(string, false);
                if (string.length() > 3 && this.f(string.substring(0, 3)) && string.charAt(3) == ' ') {
                    string2 = string.substring(0, 3);
                    if ((string = string.substring(3).trim()).length() > 0) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(" ");
                        }
                        stringBuffer.append(string);
                        vector.addElement(string);
                    }
                    bl = true;
                    continue;
                }
                stringBuffer.append(" ").append(string);
                vector.addElement(string);
            }
        }
        if (vector != null) {
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return new FTPReply(string2, stringBuffer.toString(), (String[])objectArray);
        }
        return new FTPReply(string2, stringBuffer.toString());
    }

    private boolean f(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public FTPReply validateReply(String reply, String[] expectedReplyCodes) throws IOException, FTPException {
        FTPReply fTPReply = new FTPReply(reply);
        return this.validateReply(fTPReply, expectedReplyCodes);
    }

    public FTPReply validateReply(FTPReply reply, String[] expectedReplyCodes) throws FTPException {
        for (int i2 = 0; i2 < expectedReplyCodes.length; ++i2) {
            if (!this.a(reply, expectedReplyCodes[i2])) continue;
            return reply;
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i3 = 0; i3 < expectedReplyCodes.length; ++i3) {
            stringBuffer.append(expectedReplyCodes[i3]);
            if (i3 + 1 >= expectedReplyCodes.length) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        a.info("Expected reply codes = " + stringBuffer.toString());
        throw new FTPException(reply);
    }

    public FTPReply validateReply(FTPReply reply, String expectedReplyCode) throws FTPException {
        if (this.a(reply, expectedReplyCode)) {
            return reply;
        }
        a.info("Expected reply code = [" + expectedReplyCode + "]");
        throw new FTPException(reply);
    }

    private boolean a(FTPReply fTPReply, String string) throws FTPConnectionClosedException {
        String string2 = fTPReply.getReplyCode();
        if ("421".equals(string2)) {
            throw new FTPConnectionClosedException(fTPReply.getReplyText(), string2);
        }
        if (this.b) {
            return string2.equals(string);
        }
        return string2.charAt(0) == string.charAt(0);
    }

    protected boolean isIPV6(InetAddress host) {
        String string = host.getClass().getName();
        a.debug("Checking if IPV6:" + string + " (" + host.getHostAddress() + ")");
        return string.indexOf("Inet6Address") >= 0;
    }

    void a(String string, boolean bl) {
        if (string.startsWith("---> PASS")) {
            string = "---> PASS ********";
        } else if (string.startsWith("---> ACCT")) {
            string = "---> ACCT ********";
        }
        a.debug(string);
        if (this.c != null) {
            if (bl) {
                this.c.logCommand(string);
            } else {
                this.c.logReply(string);
            }
        }
    }
}

