/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.DateParseException;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.net.ftp.MVSFileParser;
import com.enterprisedt.net.ftp.NetwareFileParser;
import com.enterprisedt.net.ftp.OS400FileParser;
import com.enterprisedt.net.ftp.UnixFileParser;
import com.enterprisedt.net.ftp.VMSFileParser;
import com.enterprisedt.net.ftp.WindowsFileParser;
import com.enterprisedt.util.debug.Logger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class FTPFileFactory {
    public static final String cvsId = "@(#)$Id: FTPFileFactory.java,v 1.28 2015/01/06 11:30:31 bruceb Exp $";
    private static Logger a = Logger.getLogger("FTPFileFactory");
    private String b;
    private WindowsFileParser c = new WindowsFileParser();
    private FTPFileParser d = new UnixFileParser();
    private VMSFileParser e = new VMSFileParser();
    private NetwareFileParser f = new NetwareFileParser();
    private MVSFileParser g = new MVSFileParser();
    private OS400FileParser h = new OS400FileParser();
    private FTPFileParser i = null;
    private boolean j = false;
    private boolean k = false;
    private Locale[] l;
    private int m = 0;
    private List n = new ArrayList();

    public FTPFileFactory(String system) throws FTPException {
        this.n.add(this.d);
        this.n.add(this.c);
        this.n.add(this.e);
        this.n.add(this.f);
        this.n.add(this.g);
        this.n.add(this.h);
        this.a(system);
    }

    public FTPFileFactory(FTPFileParser parser) {
        this.n.add(this.d);
        this.n.add(this.c);
        this.n.add(this.e);
        this.n.add(this.f);
        this.n.add(this.g);
        this.n.add(this.h);
        this.i = parser;
        this.j = true;
    }

    public String toString() {
        return this.i.getClass().getName();
    }

    public VMSFileParser getVMSParser() {
        return this.e;
    }

    public void addParser(FTPFileParser parser) {
        this.n.add(parser);
    }

    public void setLocale(Locale locale) {
        this.i.setLocale(locale);
        for (FTPFileParser fTPFileParser : this.n) {
            fTPFileParser.setLocale(locale);
        }
    }

    public void setLocales(Locale[] locales) {
        this.l = locales;
        this.setLocale(locales[0]);
        this.m = 1;
    }

    private void a(String string) {
        this.k = false;
        String string2 = this.b = string != null ? string.trim() : null;
        if (string.toUpperCase().startsWith("WINDOWS")) {
            a.debug("Selected Windows parser");
            this.i = this.c;
        } else if (string.toUpperCase().indexOf("UNIX") >= 0 || string.toUpperCase().indexOf("AIX") >= 0) {
            a.debug("Selected Unix parser");
            this.i = this.d;
        } else if (string.toUpperCase().indexOf("VMS") >= 0) {
            a.debug("Selected VMS parser");
            this.i = this.e;
        } else if (string.toUpperCase().indexOf("NETWARE") >= 0) {
            a.debug("Selected Netware parser");
            this.i = this.f;
        } else if (string.toUpperCase().indexOf("MVS") >= 0) {
            a.debug("Selected MVS parser");
            this.i = this.g;
        } else if (string.toUpperCase().indexOf("OS/400") >= 0) {
            a.debug("Selected OS/400 parser");
            this.i = this.h;
        } else {
            this.i = this.d;
            a.warn("Unknown SYST '" + string + "' - defaulting to Unix parsing");
        }
    }

    private void a() {
        this.i.setIgnoreDateParseErrors(false);
        for (FTPFileParser fTPFileParser : this.n) {
            fTPFileParser.setIgnoreDateParseErrors(false);
        }
    }

    public void detectParser(String[] files) {
        if (this.i.isValidFormat(files)) {
            a.debug("Confirmed format " + this.i.toString());
            this.k = true;
            return;
        }
        for (FTPFileParser fTPFileParser : this.n) {
            if (!fTPFileParser.isValidFormat(files)) continue;
            this.i = fTPFileParser;
            a.debug("Detected format " + this.i.toString());
            this.k = true;
            return;
        }
        this.i = this.d;
        a.warn("Could not detect format. Using default " + this.i.toString());
    }

    public FTPFile parse(String line) throws ParseException {
        if (this.i.isMultiLine()) {
            throw new ParseException("Cannot use this method with multi-line parsers", 0);
        }
        FTPFile fTPFile = null;
        try {
            fTPFile = this.i.parse(line);
        }
        catch (DateParseException dateParseException) {
            this.i.setIgnoreDateParseErrors(true);
            fTPFile = this.i.parse(line);
        }
        return fTPFile;
    }

    public FTPFile[] parse(String[] files) throws ParseException {
        this.a();
        FTPFile[] fTPFileArray = new FTPFile[files.length];
        if (files.length == 0) {
            return fTPFileArray;
        }
        if (!this.j && !this.k) {
            this.detectParser(files);
        }
        int n2 = 0;
        for (int i2 = 0; i2 < files.length; ++i2) {
            if (files[i2] == null || files[i2].trim().length() == 0) continue;
            try {
                FTPFile fTPFile = null;
                if (this.i.isMultiLine()) {
                    StringBuffer stringBuffer = new StringBuffer(files[i2]);
                    while (i2 + 1 < files.length && files[i2 + 1].indexOf(59) < 0) {
                        stringBuffer.append(" ").append(files[i2 + 1]);
                        ++i2;
                    }
                    fTPFile = this.i.parse(stringBuffer.toString());
                } else {
                    fTPFile = this.i.parse(files[i2]);
                }
                if (fTPFile == null) continue;
                fTPFileArray[n2++] = fTPFile;
                continue;
            }
            catch (DateParseException dateParseException) {
                if (this.l != null && this.l.length > this.m) {
                    a.info("Trying " + this.l[this.m].toString() + " locale");
                    this.setLocale(this.l[this.m]);
                    ++this.m;
                    n2 = 0;
                    i2 = -1;
                    continue;
                }
                n2 = 0;
                i2 = -1;
                this.i.setIgnoreDateParseErrors(true);
                a.debug("Ignoring date parsing errors");
            }
        }
        FTPFile[] fTPFileArray2 = new FTPFile[n2];
        System.arraycopy(fTPFileArray, 0, fTPFileArray2, 0, n2);
        return fTPFileArray2;
    }

    public String getSystem() {
        return this.b;
    }
}

