/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.util.debug.Logger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;

public class MVSFileParser
extends FTPFileParser {
    private static Logger a = Logger.getLogger("MVSFileParser");
    private String b;
    private String c;
    private SimpleDateFormat d;
    private SimpleDateFormat e;
    private boolean f = false;

    @Override
    public boolean isValidFormat(String[] listing) {
        String[] stringArray;
        a.debug("Checking MVS Parser for Valid Format...");
        if (listing.length > 0 && ((stringArray = this.splitMVSLine(listing[0])).length == 10 || stringArray.length == 8)) {
            if (stringArray[0].equals("Volume")) {
                this.f = false;
                a.info("Detected MVS Directory Listing Format");
                return this.isValidDirectoryFormat(listing);
            }
            if (stringArray[0].equals("Name")) {
                this.f = true;
                a.info("Detected MVS Partitioned Dataset Listing Format");
                return this.isValidPDSFormat(listing);
            }
        }
        return false;
    }

    @Override
    public FTPFile parse(String raw) throws ParseException {
        String[] stringArray = this.splitMVSLine(raw);
        FTPFile fTPFile = null;
        fTPFile = this.f ? this.parsePDSLine(stringArray, raw) : this.parseFolder(stringArray, raw);
        return fTPFile;
    }

    @Override
    public void setLocale(Locale arg0) {
        a.debug("Ignoring the set locale.");
    }

    public String toString() {
        return "MVS";
    }

    protected FTPFile parsePDSLine(String[] aLine, String raw) throws ParseException {
        FTPFile fTPFile = null;
        if (aLine[0].equals("Name")) {
            a.debug("Skipping header");
            return null;
        }
        fTPFile = new FTPFile(raw);
        fTPFile.setName(aLine[0]);
        fTPFile.setDir(false);
        if (aLine.length == 1) {
            return fTPFile;
        }
        if (this.e == null && this.b != null) {
            this.e = new SimpleDateFormat(this.b + " HH:mm");
        }
        if (this.e != null) {
            fTPFile.setCreated(this.d.parse(aLine[2]));
            String string = aLine[3] + ' ' + aLine[4];
            fTPFile.setLastModified(this.e.parse(string));
        }
        return fTPFile;
    }

    protected FTPFile parseFolder(String[] aLine, String raw) {
        if (aLine[0].equals("Volume")) {
            a.debug("Skipping header");
            return null;
        }
        if (aLine[0].equals("ARCIVE")) {
            a.debug("Skipping ARCIVE file - not supported");
            return null;
        }
        if (aLine[0].equals("Migrated")) {
            a.debug("Skipping Migrated file - not supported");
            return null;
        }
        if (aLine.length != 10) {
            a.debug("Skipping invalid line: " + raw);
            return null;
        }
        if (aLine[5].charAt(0) != 'F' && aLine[5].charAt(0) != 'V') {
            a.debug("Skipping unsupported recf - needs to start with F or V");
            return null;
        }
        if (aLine[8].charAt(0) != 'P') {
            a.debug("Skipping unsupported organization - must be PS, PO, or PO-E");
            return null;
        }
        FTPFile fTPFile = new FTPFile(raw);
        fTPFile.setName(aLine[9]);
        fTPFile.setCreated(new Date());
        fTPFile.setLastModified(new Date());
        if (aLine[8].equals("PS")) {
            a.debug("Found a file (PS) - " + aLine[9]);
            fTPFile.setDir(false);
            long l2 = -1L;
            try {
                l2 = Long.parseLong(aLine[4]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            fTPFile.setSize(l2);
        } else {
            a.debug("Found a folder (PO/PO-E) - " + aLine[9]);
            fTPFile.setDir(true);
        }
        return fTPFile;
    }

    protected String[] splitMVSLine(String raw) {
        if (raw == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(raw);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            stringArray[n2] = string.trim();
            ++n2;
        }
        return stringArray;
    }

    protected boolean isValidDirectoryFormat(String[] listing) {
        for (int i2 = 1; i2 < listing.length; ++i2) {
            String[] stringArray = this.splitMVSLine(listing[i2]);
            if (stringArray.length == 2 && stringArray[0].equals("Migrated")) {
                a.debug("Detected a migrated entry");
                continue;
            }
            if (stringArray.length != 10 && !stringArray[0].equals("ARCIVE")) {
                a.debug("Invalid Directory Line: " + listing[i2]);
                continue;
            }
            if (this.b != null) {
                if (this.checkDateFormat(stringArray[2])) continue;
                return false;
            }
            if (stringArray.length != 10) continue;
            this.guessDateFormat(stringArray[2]);
        }
        return true;
    }

    protected boolean isValidPDSFormat(String[] listing) {
        for (int i2 = 1; i2 < listing.length; ++i2) {
            String[] stringArray = this.splitMVSLine(listing[i2]);
            if (stringArray.length == 1) continue;
            if (stringArray.length != 9) {
                a.error("Invalid PDS Line: " + listing[i2]);
                return false;
            }
            if (this.b != null) {
                if (this.checkDateFormat(stringArray[3])) continue;
                return false;
            }
            this.guessDateFormat(stringArray[2]);
        }
        return true;
    }

    protected boolean checkDateFormat(String dateStr) {
        try {
            this.d.parse(dateStr);
        }
        catch (ParseException parseException) {
            a.debug("Date parse exception - probably swapped day/month");
            if (this.c != null) {
                a.debug("Choosing alternate format");
                this.b = this.c;
                this.d = new SimpleDateFormat(this.b);
                this.c = null;
                try {
                    this.d.parse(dateStr);
                }
                catch (ParseException parseException2) {
                    return false;
                }
            }
            a.error("FAIL - no alternate to fall back on. Date cannot be parsed - " + dateStr);
            return false;
        }
        return true;
    }

    protected void guessDateFormat(String dateStr) {
        a.debug("Guessing the date format...");
        String[] stringArray = dateStr.split("/");
        String string = null;
        int n2 = -1;
        int n3 = -1;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            int n4 = Integer.parseInt(stringArray[i2]);
            if (stringArray[i2].length() == 4) {
                string = "yyyy";
                n2 = i2;
                continue;
            }
            if (n4 > 31) {
                string = "yy";
                n2 = i2;
                continue;
            }
            if (n4 <= 12) continue;
            n3 = i2;
        }
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (n3 >= 0) {
                String[] stringArray2 = new String[3];
                stringArray2[n2] = string;
                stringArray2[n3] = "dd";
                for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                    stringBuffer.append(i3 > 0 ? "/" : "");
                    stringBuffer.append(stringArray2[i3] == null ? "MM" : stringArray2[i3]);
                }
                a.debug("Easy one - found obvious year, and obvious day");
            } else {
                StringBuffer stringBuffer2 = new StringBuffer();
                if (n2 == 0) {
                    stringBuffer.append(string).append("/MM/dd");
                    stringBuffer2.append(string).append("/dd/MM");
                } else {
                    stringBuffer.append("MM/dd/").append(string);
                    stringBuffer2.append("dd/MM/").append(string);
                }
                this.c = stringBuffer2.toString();
                a.debug("Ambiguous one - found obvious year, but day/month could be wrong so created alternate");
            }
            this.b = stringBuffer.toString();
            this.d = new SimpleDateFormat(this.b);
            a.debug("Decided on " + this.b);
            try {
                this.d.parse(dateStr);
            }
            catch (ParseException parseException) {
                a.debug("Parse failed - Invalid Date: " + dateStr);
            }
        } else {
            a.debug("Could not figure out year from this date format");
            return;
        }
    }

    public boolean isPartitionedDataset() {
        return this.f;
    }

    public String getDateFormatString() {
        return this.b;
    }

    public void setDateFormatString(String value) {
        this.b = value;
    }
}

