/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.DateParseException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.util.debug.Logger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class OS400FileParser
extends FTPFileParser {
    private static String[] a = new String[]{"dd'/'MM'/'yy' 'HH':'mm':'ss", "dd'.'MM'.'yy' 'HH':'mm':'ss"};
    private static String[] b = new String[]{"MM'/'dd'/'yy' 'HH':'mm':'ss", "MM'.'dd'.'yy' 'HH':'mm':'ss"};
    private static String[] c = new String[]{"yy'/'MM'/'dd' 'HH':'mm':'ss", "yy'.'MM'.'dd' 'HH':'mm':'ss"};
    private String[][] d = new String[][]{a, b, c};
    private static Logger e = Logger.getLogger("OS400FileParser");
    private int f = 0;
    private Locale g = Locale.getDefault();

    @Override
    public void setLocale(Locale locale) {
        this.g = locale;
    }

    public String toString() {
        return "OS400";
    }

    @Override
    public boolean isValidFormat(String[] listing) {
        int n2 = Math.min(listing.length, 10);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (listing[i2].indexOf("*DIR") > 0) {
                bl = true;
                continue;
            }
            if (listing[i2].indexOf("*FILE") > 0) {
                bl6 = true;
                continue;
            }
            if (listing[i2].indexOf("*FLR") > 0) {
                bl5 = true;
                continue;
            }
            if (listing[i2].indexOf("*DDIR") > 0) {
                bl2 = true;
                continue;
            }
            if (listing[i2].indexOf("*STMF") > 0) {
                bl4 = true;
                continue;
            }
            if (listing[i2].indexOf("*LIB") > 0) {
                bl3 = true;
                continue;
            }
            if (listing[i2].indexOf("*MEM") <= 0) continue;
            bl7 = true;
        }
        if (bl || bl6 || bl2 || bl3 || bl4 || bl5 || bl7) {
            return true;
        }
        e.debug("Not in OS/400 format");
        return false;
    }

    @Override
    public FTPFile parse(String raw) throws DateParseException {
        String[] stringArray = this.split(raw);
        if (stringArray.length <= 0) {
            return null;
        }
        if (stringArray.length >= 2 && stringArray[1].equals("*MEM")) {
            String string = stringArray[0];
            String string2 = stringArray[2];
            FTPFile fTPFile = new FTPFile(raw, string2, 0L, false, null);
            fTPFile.setOwner(string);
            return fTPFile;
        }
        if (stringArray.length < 6) {
            return null;
        }
        String string = stringArray[0];
        long l2 = 0L;
        try {
            l2 = Long.parseLong(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            e.warn("Failed to parse size: " + stringArray[1]);
        }
        String string3 = stringArray[2] + " " + stringArray[3];
        Date date = this.a(string3);
        boolean bl = false;
        if (stringArray[4] == "*DIR" || stringArray[4] == "*DDIR") {
            bl = true;
        }
        int n2 = raw.indexOf(stringArray[4]);
        String string4 = this.trimStart(raw.substring(n2 += stringArray[4].length()));
        if (string4.endsWith("/")) {
            bl = true;
            string4 = string4.substring(0, string4.length() - 1);
        }
        FTPFile fTPFile = new FTPFile(raw, string4, l2, bl, date);
        fTPFile.setOwner(string);
        return fTPFile;
    }

    private Date a(String string) throws DateParseException {
        Date date = null;
        if (this.f >= this.d.length) {
            e.warn("Exhausted formats - failed to parse date");
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 2);
        int n2 = this.f;
        int n3 = this.f;
        while (n3 < this.d.length) {
            for (int i2 = 0; i2 < this.d[n3].length; ++i2) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.d[this.f][i2], this.g);
                    date = simpleDateFormat.parse(string);
                    if (!date.after(calendar.getTime())) {
                        return date;
                    }
                    e.debug("Swapping to alternate date format (found date in future)");
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            ++n3;
            ++this.f;
        }
        if (this.f >= this.d.length) {
            e.warn("Exhausted formats - failed to parse date");
            return null;
        }
        if (this.f > n2) {
            throw new DateParseException(null);
        }
        return date;
    }
}

