/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.ConnectResult;
import com.enterprisedt.net.ftp.async.internal.ConnectFTPSETask;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.SecureConnectionContext;
import com.enterprisedt.net.ftp.ssl.SSLFTPClient;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;

public class ConnectFTPSITask
extends ConnectFTPSETask {
    private static Logger a = Logger.getLogger("ConnectFTPSITask");

    public ConnectFTPSITask(FTPTaskProcessor taskProcessor, ConnectResult result, AsyncCallback.Connect callback) {
        super(taskProcessor, result, callback);
    }

    @Override
    protected void login(FTPClientInterface ftp, SecureConnectionContext context) throws IOException, FTPException {
        SSLFTPClient sSLFTPClient = (SSLFTPClient)ftp;
        try {
            sSLFTPClient.setImplicitFTPS(true);
            a.debug("Implicit mode");
            if (this.getContext().getAccountDetails() == null) {
                sSLFTPClient.login(this.getContext().getUserName(), this.getContext().getPassword());
            } else {
                sSLFTPClient.login(this.getContext().getUserName(), this.getContext().getPassword(), this.getContext().getAccountDetails());
            }
            a.info("Logged in");
        }
        catch (FTPException fTPException) {
            try {
                sSLFTPClient.quitImmediately();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw fTPException;
        }
        catch (IOException iOException) {
            try {
                sSLFTPClient.quitImmediately();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iOException;
        }
        try {
            a.debug("Trying PBSZ/PROT");
            sSLFTPClient.pbsz(0);
            sSLFTPClient.prot('P');
        }
        catch (FTPException fTPException) {
            // empty catch block
        }
    }
}

