/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.WildcardFilter;
import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.DeleteMultipleFilesResult;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.Task;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.net.ftp.pro.ProFTPClientInterface;
import com.enterprisedt.util.debug.Logger;
import java.io.FileFilter;

public class DeleteMultipleFilesTask
extends Task {
    private static Logger a = Logger.getLogger("DeleteFilesTask");
    private DeleteMultipleFilesResult b;
    private AsyncCallback.DeleteMultipleFiles c;

    public DeleteMultipleFilesTask(FTPTaskProcessor taskProcessor, DeleteMultipleFilesResult result, AsyncCallback.DeleteMultipleFiles callback) {
        super(taskProcessor, TaskType.p, result);
        this.b = result;
        this.c = callback;
    }

    @Override
    public void run(FTPConnection conn) {
        this.setState(TaskState.RUNNING_STATE);
        try {
            this.configureConnection(conn);
            if (!this.getState().equals(TaskState.RUNNING_STATE)) {
                a.debug("Task cancelled [" + this.toString() + "]");
            } else {
                ProFTPClientInterface proFTPClientInterface = conn.getClient();
                FileFilter fileFilter = this.b.getFilter();
                if (fileFilter == null && this.b.getWildcard() != null) {
                    fileFilter = new WildcardFilter(this.b.getWildcard());
                }
                if (this.b.getRemoteDirectory() == null) {
                    conn.getClient().mdelete(fileFilter);
                } else {
                    conn.getClient().mdelete(this.b.getRemoteDirectory(), fileFilter, this.b.isRecursive());
                }
                this.b.setSuccessful(true);
                this.setState(TaskState.COMPLETED_SUCCESS_STATE);
                conn.setLastUsedTime(System.currentTimeMillis());
            }
        }
        catch (Throwable throwable) {
            a.error(this.toString() + " failed", throwable);
            this.b.setThrowable(throwable);
            this.setState(TaskState.COMPLETED_FAILURE_STATE);
        }
        this.b.notifyComplete();
        this.b.setLocalContext(this.getContext());
        if (this.c != null) {
            try {
                this.c.onDeleteMultipleFiles(this.b);
            }
            catch (Throwable throwable) {
                this.taskProcessor.a(this.b, throwable);
            }
        }
        this.b.setLocalContext(null);
        try {
            if (!this.b.endAsyncCalled()) {
                this.b.endAsync();
            }
        }
        catch (Throwable throwable) {
            this.taskProcessor.a(this.b, throwable);
        }
    }

    @Override
    public boolean cancel() {
        TaskState taskState = this.getState();
        if (taskState.equals(TaskState.PENDING_STATE)) {
            this.setState(TaskState.DISCARDED_STATE);
            return true;
        }
        if (taskState.equals(TaskState.RUNNING_STATE)) {
            return false;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getId() + ":" + this.getTaskType().getName() + "[" + this.b.getRemoteDirectory() + "]";
    }
}

