/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.DisconnectResult;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPConnectionPool;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.Task;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.util.debug.Logger;

public class DisconnectTask
extends Task {
    private static Logger a = Logger.getLogger("DisconnectTask");
    private AsyncCallback.Disconnect b;
    private DisconnectResult c;
    private boolean d = false;

    public DisconnectTask(FTPTaskProcessor taskProcessor, boolean persistentThreads, DisconnectResult result, AsyncCallback.Disconnect callback) {
        super(taskProcessor, TaskType.b, result);
        this.d = persistentThreads;
        this.c = result;
        this.b = callback;
    }

    @Override
    public String toString() {
        return this.getId() + ":" + this.getTaskType().getName() + "[" + this.getContext().getRemoteHost() + "]";
    }

    public AsyncCallback.Disconnect getCallback() {
        return this.b;
    }

    @Override
    public void run(FTPConnection conn) {
        a.debug("Running DisconnectTask " + this.toString() + " on thread " + Thread.currentThread().getName());
        try {
            FTPConnectionPool fTPConnectionPool = this.taskProcessor.b();
            fTPConnectionPool.disconnect(this.c.isImmediate());
            if (!this.d) {
                this.taskProcessor.shutdown(this.c.isImmediate());
            }
            this.c.setSuccessful(true);
        }
        catch (Throwable throwable) {
            a.error(this.toString() + " failed", throwable);
            this.c.setThrowable(throwable);
        }
        this.c.notifyComplete();
        this.c.setLocalContext(this.getContext());
        if (this.b != null) {
            try {
                this.b.onDisconnect(this.c);
            }
            catch (Throwable throwable) {
                this.taskProcessor.a(this.c, throwable);
            }
        }
        this.c.setLocalContext(null);
        try {
            if (!this.c.endAsyncCalled()) {
                this.c.endAsync();
            }
        }
        catch (Throwable throwable) {
            this.taskProcessor.a(this.c, throwable);
        }
        a.debug("Completed DisconnectTask " + this.toString());
    }
}

