/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPInputStream;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import com.enterprisedt.net.ftp.Protocol;
import com.enterprisedt.net.ftp.TransferDirection;
import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.DownloadStreamResult;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.SingleTransferTask;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.net.ftp.ssh.SSHFTPClient;
import com.enterprisedt.net.ftp.ssh.SSHFTPInputStream;
import com.enterprisedt.util.debug.Logger;

public class DownloadStreamTask
extends SingleTransferTask {
    private static Logger a = Logger.getLogger("DownloadStreamTask");
    private AsyncCallback.DownloadStream b;
    private DownloadStreamResult c;
    private Object d = new Object();
    private boolean e = false;

    public DownloadStreamTask(FTPTaskProcessor taskProcessor, DownloadStreamResult result, AsyncCallback.DownloadStream callback) {
        super(taskProcessor, result, TaskType.d);
        this.b = callback;
        this.c = result;
    }

    @Override
    public String toString() {
        return this.getId() + ":" + this.getTaskType().getName() + "[" + this.result.getRemoteFileName() + "=>stream]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(FTPConnection conn) {
        block18: {
            this.setState(TaskState.RUNNING_STATE);
            try {
                Object object;
                this.configureConnection(conn);
                if (!this.getState().equals(TaskState.RUNNING_STATE)) {
                    a.debug("Task cancelled [" + this.toString() + "]");
                    break block18;
                }
                this.setupProgressMonitoring(this.result.getNotifyInterval());
                FileTransferInputStream fileTransferInputStream = null;
                if (this.getContext().getProtocol().equals(Protocol.SFTP)) {
                    object = new SSHFTPInputStream((SSHFTPClient)conn.getClient(), conn.convertPath(this.result.getRemoteFileName()));
                    ((SSHFTPInputStream)object).setMonitor(this, conn.getClient().getMonitorInterval());
                    fileTransferInputStream = object;
                } else {
                    object = new FTPInputStream((FTPClient)((Object)conn.getClient()), conn.convertPath(this.result.getRemoteFileName()));
                    ((FTPInputStream)object).setMonitor(this, conn.getClient().getMonitorInterval());
                    fileTransferInputStream = object;
                }
                ((DownloadStreamResult)this.result).setInputStream(fileTransferInputStream);
                this.result.setLocalContext(this.getContext());
                if (this.b != null) {
                    this.b.onDownloadingStream(fileTransferInputStream, (DownloadStreamResult)this.result);
                }
                object = this.d;
                synchronized (object) {
                    try {
                        if (!this.e) {
                            a.debug("Waiting until stream transfer complete");
                            this.d.wait();
                            a.debug("Lock released");
                        }
                        this.result.setSuccessful(true);
                        this.setState(TaskState.COMPLETED_SUCCESS_STATE);
                    }
                    catch (InterruptedException interruptedException) {
                        a.error("Wait for task completion", interruptedException);
                    }
                }
                conn.setLastUsedTime(System.currentTimeMillis());
            }
            catch (Throwable throwable) {
                a.error(this.toString() + " failed (releasing lock)", throwable);
                this.result.setThrowable(throwable);
                this.setState(TaskState.COMPLETED_FAILURE_STATE);
                ((DownloadStreamResult)this.result).setInputStreamFailure(throwable);
            }
        }
        this.result.notifyComplete();
        if (this.b != null) {
            try {
                this.b.onDownloadStream(this.c);
            }
            catch (Throwable throwable) {
                this.taskProcessor.a(this.result, throwable);
            }
        }
        this.result.setLocalContext(null);
        try {
            if (!this.c.endAsyncCalled()) {
                this.c.endAsync();
            }
        }
        catch (Throwable throwable) {
            this.taskProcessor.a(this.result, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferComplete(TransferDirection direction, String remoteFile) {
        Object object = this.d;
        synchronized (object) {
            super.transferComplete(direction, remoteFile);
            a.debug("Stream transfer complete - notifying task [" + remoteFile + "]");
            this.e = true;
            this.d.notifyAll();
        }
    }
}

