/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.WriteMode;
import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.UploadByteArrayResult;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.SingleTransferTask;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.util.debug.Logger;

public class UploadByteArrayTask
extends SingleTransferTask {
    private static Logger a = Logger.getLogger("UploadByteArrayTask");
    private AsyncCallback.UploadByteArray b;
    private UploadByteArrayResult c;

    public UploadByteArrayTask(FTPTaskProcessor taskProcessor, UploadByteArrayResult result, AsyncCallback.UploadByteArray callback) {
        super(taskProcessor, result, TaskType.c);
        this.b = callback;
        this.c = result;
    }

    @Override
    public String toString() {
        return this.getId() + ":" + this.getTaskType().getName() + "[bytearray => " + this.c.getRemoteFileName() + "]";
    }

    @Override
    public void run(FTPConnection conn) {
        this.setState(TaskState.RUNNING_STATE);
        try {
            this.configureConnection(conn);
            if (!this.getState().equals(TaskState.RUNNING_STATE)) {
                a.debug("Task cancelled [" + this.toString() + "]");
            } else {
                this.setupProgressMonitoring(this.c.getNotifyInterval());
                boolean bl = this.c.getWriteMode().equals(WriteMode.APPEND);
                conn.getClient().put(this.c.getLocalBytes(), conn.convertPath(this.c.getRemoteFileName()), bl);
                this.c.setSuccessful(true);
                this.setState(TaskState.COMPLETED_SUCCESS_STATE);
                conn.setLastUsedTime(System.currentTimeMillis());
            }
        }
        catch (Throwable throwable) {
            a.error(this.toString() + " failed (releasing lock)", throwable);
            this.result.setThrowable(throwable);
            this.setState(TaskState.COMPLETED_FAILURE_STATE);
        }
        this.result.notifyComplete();
        this.result.setLocalContext(this.getContext());
        if (this.b != null) {
            try {
                this.b.onUploadByteArray(this.c);
            }
            catch (Throwable throwable) {
                this.taskProcessor.a(this.result, throwable);
            }
        }
        this.result.setLocalContext(null);
        try {
            if (!this.c.endAsyncCalled()) {
                this.c.endAsync();
            }
        }
        catch (Throwable throwable) {
            this.taskProcessor.a(this.result, throwable);
        }
    }
}

