/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.WriteMode;
import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.UploadFileResult;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.SingleTransferTask;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.util.debug.Logger;

public class UploadFileTask
extends SingleTransferTask {
    private static Logger a = Logger.getLogger("UploadFileTask");
    private AsyncCallback.UploadFile b;
    private UploadFileResult c;

    public UploadFileTask(FTPTaskProcessor taskProcessor, UploadFileResult result, AsyncCallback.UploadFile callback) {
        super(taskProcessor, result, TaskType.c);
        this.b = callback;
        this.c = result;
    }

    @Override
    public String toString() {
        return this.getId() + ":" + this.getTaskType().getName() + "[" + this.c.getLocalFileName() + "=>" + this.result.getRemoteFileName() + "]";
    }

    @Override
    public void run(FTPConnection conn) {
        this.setState(TaskState.RUNNING_STATE);
        try {
            this.configureConnection(conn);
            if (!this.getState().equals(TaskState.RUNNING_STATE)) {
                a.debug("Task cancelled [" + this.toString() + "]");
            } else {
                this.setupProgressMonitoring(this.c.getNotifyInterval());
                if (this.c.getWriteMode().equals(WriteMode.RESUME)) {
                    a.debug("Resuming transfer");
                    conn.getClient().resume();
                }
                boolean bl = this.c.getWriteMode().equals(WriteMode.APPEND);
                String string = conn.getClient().put(this.c.getLocalFileName(), conn.convertPath(this.c.getRemoteFileName()), bl);
                ((UploadFileResult)this.result).setRemoteFileName(string);
                this.c.setSuccessful(true);
                this.setState(TaskState.COMPLETED_SUCCESS_STATE);
                conn.setLastUsedTime(System.currentTimeMillis());
            }
        }
        catch (Throwable throwable) {
            a.error(this.toString() + " failed", throwable);
            this.c.setThrowable(throwable);
            this.setState(TaskState.COMPLETED_FAILURE_STATE);
        }
        this.c.notifyComplete();
        this.result.setLocalContext(this.getContext());
        if (this.b != null) {
            try {
                this.b.onUploadFile(this.c);
            }
            catch (Throwable throwable) {
                this.taskProcessor.a(this.result, throwable);
            }
        }
        this.result.setLocalContext(null);
        try {
            if (!this.c.endAsyncCalled()) {
                this.c.endAsync();
            }
        }
        catch (Throwable throwable) {
            this.taskProcessor.a(this.result, throwable);
        }
    }
}

