/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.pro;

import com.enterprisedt.net.ftp.FTPControlSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.internal.FTPDataSocket;
import com.enterprisedt.net.ftp.pro.ProFTPActiveDataSocket;
import com.enterprisedt.net.ftp.pro.ProFTPPassiveDataSocket;
import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.proxy.ProxyServerSocket;
import com.enterprisedt.util.proxy.ProxySettings;
import com.enterprisedt.util.proxy.ProxyType;
import com.enterprisedt.util.proxy.StreamSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class ProFTPControlSocket
extends FTPControlSocket {
    private static Logger a = Logger.getLogger("ProFTPControlSocket");
    private ProxySettings b;

    ProFTPControlSocket(ProxySettings proxySettings, InetAddress remoteAddr, StreamSocket sock, int timeout, String encoding, FTPMessageListener messageListener) throws IOException, FTPException {
        super(remoteAddr, sock, timeout, encoding, messageListener);
        this.b = proxySettings;
    }

    @Override
    protected boolean usingProxy() {
        return this.b != null && !this.b.getProxyType().equals(ProxyType.NO_PROXY);
    }

    @Override
    protected void setDataPort(InetAddress host, int portNo) throws IOException, FTPException {
        if (!this.isIPV6(this.controlSock.getInetAddress())) {
            super.setDataPort(host, portNo);
        } else {
            String string = host.getHostAddress();
            if (!this.isIPV6(host)) {
                string = "::" + string;
            }
            if (this.forcedActiveIP != null) {
                a.info("Forcing use of fixed IP for EPRT command");
                string = this.forcedActiveIP;
            }
            String string2 = new StringBuffer("EPRT |2|").append(string).append("|").append(portNo).append("|").toString();
            FTPReply fTPReply = this.sendCommand(string2);
            this.validateReply(fTPReply, "200");
        }
    }

    @Override
    protected FTPDataSocket createDataSocketPASV() throws IOException, FTPException {
        if (!this.isIPV6(this.controlSock.getInetAddress())) {
            return super.createDataSocketPASV();
        }
        FTPReply fTPReply = this.sendCommand("EPSV");
        this.validateReply(fTPReply, "229");
        String string = fTPReply.getReplyText();
        int n2 = string.indexOf("(|||");
        int n3 = string.indexOf("|)");
        String string2 = string.substring(n2 += "(|||".length(), n3).trim();
        int n4 = Integer.parseInt(string2);
        String string3 = this.remoteAddr.getHostAddress();
        a.debug("Creating new passive socket at (" + string3 + ":" + n4 + ")");
        return this.newPassiveDataSocket(string3, n4);
    }

    @Override
    protected FTPDataSocket newPassiveDataSocket(String remoteHost, int port) throws IOException {
        return new ProFTPPassiveDataSocket(remoteHost, port, this.controlSock.getSoTimeout(), this.b);
    }

    @Override
    protected FTPDataSocket newActiveDataSocket(int port) throws IOException {
        if (this.b.getProxyType().equals(ProxyType.HTTP)) {
            throw new IOException("Cannot use active mode with HTTP proxies");
        }
        ProxyServerSocket proxyServerSocket = new ProxyServerSocket(this.b);
        InetAddress inetAddress = null;
        if (this.b.getProxyType().equals(ProxyType.NO_PROXY)) {
            a.debug("newActiveDataSocket: localAddress=" + this.controlSock.getLocalAddress().toString());
            inetAddress = this.listenOnAllInterfaces ? new Socket().getLocalAddress() : this.controlSock.getLocalAddress();
            proxyServerSocket.setLocalAddress(this.controlSock.getLocalAddress());
        } else {
            inetAddress = this.remoteAddr;
        }
        proxyServerSocket.setSoTimeout(this.controlSock.getSoTimeout());
        proxyServerSocket.bind(port, inetAddress);
        a.debug("ListenOnAllInterfaces=" + this.listenOnAllInterfaces);
        return new ProFTPActiveDataSocket(proxyServerSocket);
    }
}

