/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.script;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.Protocol;
import com.enterprisedt.net.ftp.VersionDetails;
import com.enterprisedt.net.ftp.pro.ProFTPClientInterface;
import com.enterprisedt.net.ftp.script.ASCIICommand;
import com.enterprisedt.net.ftp.script.AuthCommand;
import com.enterprisedt.net.ftp.script.BinaryCommand;
import com.enterprisedt.net.ftp.script.CccCommand;
import com.enterprisedt.net.ftp.script.CdCommand;
import com.enterprisedt.net.ftp.script.CdUpCommand;
import com.enterprisedt.net.ftp.script.CommandCollector;
import com.enterprisedt.net.ftp.script.CommandResult;
import com.enterprisedt.net.ftp.script.CommentCommand;
import com.enterprisedt.net.ftp.script.DebugCommand;
import com.enterprisedt.net.ftp.script.DeleteCommand;
import com.enterprisedt.net.ftp.script.DirCommand;
import com.enterprisedt.net.ftp.script.EchoCommand;
import com.enterprisedt.net.ftp.script.GetCommand;
import com.enterprisedt.net.ftp.script.HelpCommand;
import com.enterprisedt.net.ftp.script.LicenseCommand;
import com.enterprisedt.net.ftp.script.LocalCdCommand;
import com.enterprisedt.net.ftp.script.MDeleteCommand;
import com.enterprisedt.net.ftp.script.MGetCommand;
import com.enterprisedt.net.ftp.script.MPutCommand;
import com.enterprisedt.net.ftp.script.MkDirCommand;
import com.enterprisedt.net.ftp.script.OpenCommand;
import com.enterprisedt.net.ftp.script.ProtectCommand;
import com.enterprisedt.net.ftp.script.PutCommand;
import com.enterprisedt.net.ftp.script.PwdCommand;
import com.enterprisedt.net.ftp.script.QuitCommand;
import com.enterprisedt.net.ftp.script.QuoteCommand;
import com.enterprisedt.net.ftp.script.RecordCommand;
import com.enterprisedt.net.ftp.script.RenameCommand;
import com.enterprisedt.net.ftp.script.RmDirCommand;
import com.enterprisedt.net.ftp.script.ScriptCommand;
import com.enterprisedt.net.ftp.script.ScriptResult;
import com.enterprisedt.net.ftp.script.ScriptVariable;
import com.enterprisedt.net.ftp.script.SetCommand;
import com.enterprisedt.net.ftp.script.SiteCommand;
import com.enterprisedt.net.ftp.script.TypeCommand;
import com.enterprisedt.net.ftp.script.VersionCommand;
import com.enterprisedt.util.debug.FileAppender;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.getopt.GetOpt;
import com.enterprisedt.util.license.EDTProduct;
import com.enterprisedt.util.license.LicensePropertiesBase;
import com.enterprisedt.util.license.LicensePropertiesFactory;
import com.enterprisedt.util.proxy.ProxySettings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class ScriptEngine {
    private static Logger a = Logger.getLogger("ScriptEngine");
    private final EDTProduct[] b = new EDTProduct[]{EDTProduct.EDTFTPJ_PRO};
    private final SimpleDateFormat c = new SimpleDateFormat("d MMM yyyy HH:mm:ss");
    private LicensePropertiesBase d;
    private Map e = new TreeMap();
    private Map f = new TreeMap();
    private ProFTPClientInterface g;
    private String h;
    private boolean i = true;
    private String j;
    private String k;
    private String l;
    private int m = 0;
    private int n = 0;
    private int o = 0;
    private int p = 0;
    private boolean q = true;
    private String r;
    private String s;
    private BufferedWriter t;
    private Level u = Level.ALL;
    private Protocol v = Protocol.FTP;
    private ProxySettings w = new ProxySettings();
    private FTPConnectMode x = FTPConnectMode.PASV;
    private SetCommand y = new SetCommand();
    private CommandCollector z = new CommandCollector();
    private String A = null;
    private String B = null;
    private String C = null;
    private String D = null;
    private boolean E = false;
    private String F = null;
    private String G = null;
    private String H = null;
    private String I = null;
    private int J = 771;
    private String K;
    private String L;
    private String M = null;

    public ScriptEngine() throws IOException {
        this.d = LicensePropertiesFactory.createLicenseProperties();
        this.d.checkLicence(this.b);
        a.debug(VersionDetails.report(this));
        this.e.put("license", new LicenseCommand());
        this.e.put("licence", new LicenseCommand());
        this.e.put("lic", new LicenseCommand());
        this.e.put("record", new RecordCommand());
        this.e.put("stop", new RecordCommand());
        this.e.put("comment", new CommentCommand());
        this.e.put("help", new HelpCommand());
        this.e.put("echo", new EchoCommand());
        this.e.put("print", new EchoCommand());
        this.e.put("debug", new DebugCommand());
        this.e.put("cd", new CdCommand());
        this.e.put("cdup", new CdUpCommand());
        this.e.put("lcd", new LocalCdCommand());
        this.e.put("pwd", new PwdCommand());
        this.e.put("dir", new DirCommand());
        this.e.put("ls", new DirCommand());
        this.e.put("set", this.y);
        this.e.put("open", new OpenCommand());
        this.e.put("connect", new OpenCommand());
        this.e.put("binary", new BinaryCommand());
        this.e.put("bin", new BinaryCommand());
        this.e.put("ascii", new ASCIICommand());
        this.e.put("asc", new ASCIICommand());
        this.e.put("get", new GetCommand());
        this.e.put("put", new PutCommand());
        this.e.put("append", new PutCommand());
        this.e.put("mget", new MGetCommand());
        this.e.put("mput", new MPutCommand());
        this.e.put("delete", new DeleteCommand());
        this.e.put("del", new DeleteCommand());
        this.e.put("mdel", new MDeleteCommand());
        this.e.put("mdelete", new MDeleteCommand());
        this.e.put("rename", new RenameCommand());
        this.e.put("ren", new RenameCommand());
        this.e.put("quit", new QuitCommand());
        this.e.put("bye", new QuitCommand());
        this.e.put("close", new QuitCommand());
        this.e.put("exit", new QuitCommand());
        this.e.put("disconnect", new QuitCommand());
        this.e.put("mkdir", new MkDirCommand());
        this.e.put("rmdir", new RmDirCommand());
        this.e.put("auth", new AuthCommand());
        this.e.put("prot", new ProtectCommand());
        this.e.put("protect", new ProtectCommand());
        this.e.put("clear", new ProtectCommand());
        this.e.put("private", new ProtectCommand());
        this.e.put("ccc", new CccCommand());
        this.e.put("version", new VersionCommand());
        this.e.put("ver", new VersionCommand());
        this.e.put("quote", new QuoteCommand());
        this.e.put("site", new SiteCommand());
        this.e.put("type", new TypeCommand());
        Logger.setLevel(this.u);
        this.K = new File(".").getCanonicalPath();
    }

    public ScriptEngine(String user, String password) throws IOException {
        this.d = LicensePropertiesFactory.createLicenseProperties();
        this.d.checkLicence(this.b);
        a.debug(VersionDetails.report(this));
        this.e.put("license", new LicenseCommand());
        this.e.put("licence", new LicenseCommand());
        this.e.put("lic", new LicenseCommand());
        this.e.put("record", new RecordCommand());
        this.e.put("stop", new RecordCommand());
        this.e.put("comment", new CommentCommand());
        this.e.put("help", new HelpCommand());
        this.e.put("echo", new EchoCommand());
        this.e.put("print", new EchoCommand());
        this.e.put("debug", new DebugCommand());
        this.e.put("cd", new CdCommand());
        this.e.put("cdup", new CdUpCommand());
        this.e.put("lcd", new LocalCdCommand());
        this.e.put("pwd", new PwdCommand());
        this.e.put("dir", new DirCommand());
        this.e.put("ls", new DirCommand());
        this.e.put("set", this.y);
        this.e.put("open", new OpenCommand());
        this.e.put("connect", new OpenCommand());
        this.e.put("binary", new BinaryCommand());
        this.e.put("bin", new BinaryCommand());
        this.e.put("ascii", new ASCIICommand());
        this.e.put("asc", new ASCIICommand());
        this.e.put("get", new GetCommand());
        this.e.put("put", new PutCommand());
        this.e.put("append", new PutCommand());
        this.e.put("mget", new MGetCommand());
        this.e.put("mput", new MPutCommand());
        this.e.put("delete", new DeleteCommand());
        this.e.put("del", new DeleteCommand());
        this.e.put("mdel", new MDeleteCommand());
        this.e.put("mdelete", new MDeleteCommand());
        this.e.put("rename", new RenameCommand());
        this.e.put("ren", new RenameCommand());
        this.e.put("quit", new QuitCommand());
        this.e.put("bye", new QuitCommand());
        this.e.put("close", new QuitCommand());
        this.e.put("exit", new QuitCommand());
        this.e.put("disconnect", new QuitCommand());
        this.e.put("mkdir", new MkDirCommand());
        this.e.put("rmdir", new RmDirCommand());
        this.e.put("auth", new AuthCommand());
        this.e.put("prot", new ProtectCommand());
        this.e.put("protect", new ProtectCommand());
        this.e.put("clear", new ProtectCommand());
        this.e.put("private", new ProtectCommand());
        this.e.put("ccc", new CccCommand());
        this.e.put("version", new VersionCommand());
        this.e.put("ver", new VersionCommand());
        this.e.put("quote", new QuoteCommand());
        this.e.put("site", new SiteCommand());
        this.e.put("type", new TypeCommand());
        Logger.setLevel(this.u);
        this.K = new File(".").getCanonicalPath();
        this.h = user;
        this.j = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResult runCommand(String command) {
        ScriptCommand scriptCommand;
        if ((command = command.trim()).length() == 0) {
            return null;
        }
        int n2 = command.indexOf(32);
        String string = "";
        String string2 = command;
        if (n2 > 0) {
            string2 = string2.substring(0, n2);
            string = command.substring(n2 + 1).trim();
        }
        if ((scriptCommand = (ScriptCommand)this.e.get(string2 = string2.toLowerCase().trim())) == null) {
            if (command.indexOf(61) > 0) {
                scriptCommand = this.y;
                string2 = "set";
                string = command;
            } else {
                String string3 = "Cannot interpret command '" + command + "'";
                a.error(string3);
                return new CommandResult(true, string3, string3);
            }
        }
        if (this.t != null && scriptCommand.recordable()) {
            try {
                this.t.write(command);
                this.t.newLine();
            }
            catch (IOException iOException) {
                a.error("Failed to write command to record file", iOException);
            }
        }
        if ((this.g == null || !this.g.connected()) && scriptCommand.mustBeConnected()) {
            String string4 = "Cannot execute command - not connected";
            return new CommandResult(true, string4, string4);
        }
        CommandResult commandResult = null;
        boolean bl = false;
        try {
            this.z.clearLogs();
            commandResult = scriptCommand.execute(this, this.g, string2, string);
            commandResult.setServerMessageLog(this.z.getLogs());
        }
        catch (IOException iOException) {
            a.error("Command failed:" + command, iOException);
            String string5 = "Command '" + command + "' failed - disconnected";
            if (this.g != null && this.g.connected()) {
                try {
                    this.g.quit();
                }
                catch (Exception exception) {
                    a.error("quit() failed", exception);
                    try {
                        this.g.quitImmediately();
                    }
                    catch (Exception exception2) {
                        a.error("quitImmediately() failed", exception2);
                    }
                }
            }
            commandResult = new CommandResult(true, string5, string5);
            commandResult.setLastException(iOException);
            commandResult.setServerMessageLog(this.z.getLogs());
        }
        catch (Exception exception) {
            a.error("Command failed:" + command, exception);
            String string6 = "Command failed: " + command + " : " + exception.getMessage();
            commandResult = new CommandResult(true, string6, string6);
            commandResult.setLastException(exception);
            commandResult.setServerMessageLog(this.z.getLogs());
        }
        finally {
            if (this.g instanceof FTPClient && commandResult != null) {
                commandResult.setLastFTPReply(((FTPClient)((Object)this.g)).getLastReply());
            }
            if (bl) {
                this.g = null;
            }
        }
        return commandResult;
    }

    public void quit() {
        if (this.g != null && this.g.connected()) {
            try {
                this.g.quit();
            }
            catch (Exception exception) {
                a.error("Failed to quit", exception);
            }
            if (this.q) {
                System.out.println("Connection closed");
            }
        }
    }

    public ScriptResult executeScript(String scriptPath) {
        return this.executeScript(scriptPath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptResult executeScript(String scriptPath, boolean exitAtEnd) {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(scriptPath);
            ScriptResult scriptResult = this.executeScript(fileReader, exitAtEnd);
            return scriptResult;
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), iOException);
            System.out.println("Failed to read script file " + scriptPath + " (" + iOException.getMessage() + ")");
            ScriptResult scriptResult = null;
            return scriptResult;
        }
        finally {
            try {
                fileReader.close();
            }
            catch (IOException iOException) {
                a.error(iOException.getMessage(), iOException);
            }
        }
    }

    public ScriptResult executeScript(Reader scriptStream) {
        return this.executeScript(scriptStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptResult executeScript(Reader scriptStream, boolean exitAtEnd) {
        ScriptResult scriptResult = new ScriptResult();
        String[] stringArray = null;
        try {
            stringArray = this.a(scriptStream);
        }
        catch (IOException iOException) {
            String string = "Failed to read commands: " + iOException.getMessage();
            System.out.println(string);
            scriptResult.a(iOException);
            scriptResult.a(true);
            return scriptResult;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                CommandResult commandResult = this.runCommand(stringArray[i2]);
                if (commandResult == null) continue;
                String string = commandResult.getServerMessageLog();
                scriptResult.a(string);
                if (commandResult.getLastException() != null) {
                    scriptResult.a(commandResult.getLastException());
                }
                scriptResult.a(commandResult.getLastFTPReply());
                scriptResult.a(commandResult.forceScriptExit());
                scriptResult.a(commandResult.getDownloadCount());
                scriptResult.b(commandResult.getUploadCount());
                scriptResult.c(commandResult.getDeleteCount());
                if (this.q) {
                    if (this.i) {
                        System.out.println(stringArray[i2]);
                    }
                    if (string != null) {
                        String[] stringArray2 = commandResult.getServerMessageLogs();
                        for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                            System.out.println(stringArray2[i3]);
                        }
                    }
                    if (commandResult.getDebug() != null) {
                        System.out.println(commandResult.getDebug());
                    }
                }
                if (!commandResult.forceScriptExit()) continue;
                break;
            }
        }
        finally {
            if (exitAtEnd) {
                this.quit();
            }
        }
        return scriptResult;
    }

    public Map getCommandMap() {
        return this.e;
    }

    public Map getVariablesMap() {
        return this.f;
    }

    LicensePropertiesBase a() {
        return this.d;
    }

    public boolean isEchoCommand() {
        return this.i;
    }

    public void setEchoCommand(boolean echoCommand) {
        this.i = echoCommand;
    }

    public ScriptVariable getVariable(String name) {
        return (ScriptVariable)this.f.get(name);
    }

    public void setVariable(String name, String value) {
        this.f.put(name, new ScriptVariable(name, value));
    }

    public String getConfigFlags() {
        return this.I;
    }

    public void setConfigFlags(String configFlags) {
        this.I = configFlags;
    }

    public String getKnownHosts() {
        return this.l;
    }

    public void setKnownHosts(String knownHosts) {
        this.l = knownHosts;
    }

    public String getServerPublicKey() {
        return this.F;
    }

    public void setServerPublicKey(String serverPublicKey) {
        this.F = serverPublicKey;
    }

    public String getClientPrivateKey() {
        return this.G;
    }

    public void setClientPrivateKey(String clientPrivateKey) {
        this.G = clientPrivateKey;
    }

    public String getClientPrivateKeyPass() {
        return this.H;
    }

    public void setClientPrivateKeyPass(String clientPrivateKeyPass) {
        this.H = clientPrivateKeyPass;
    }

    public void startRecording(String file) throws IOException {
        if (file != null) {
            this.s = file;
        }
        this.t = new BufferedWriter(new FileWriter(this.s, true));
        this.t.write("# start recording " + this.c.format(new Date()));
        this.t.newLine();
    }

    public void stopRecording() throws IOException {
        try {
            this.t.write("# stop recording: " + this.c.format(new Date()));
            this.t.newLine();
            this.t.close();
        }
        finally {
            this.t = null;
        }
    }

    public boolean isRecording() {
        return this.t != null;
    }

    public String getRecordFile() {
        return this.s;
    }

    public void setRecordFile(String file) {
        this.s = file;
    }

    public void writeToRecordFile(String msg) throws IOException {
        if (this.isRecording()) {
            this.t.write(msg);
            this.t.newLine();
        }
    }

    public FTPConnectMode getConnectMode() {
        return this.x;
    }

    public void setConnectMode(FTPConnectMode mode) {
        a.debug("Setting connectmode=" + mode.toString());
        this.x = mode;
    }

    public String getLocalDir() {
        return this.K;
    }

    public void setLocalDir(String localDir) {
        this.K = localDir;
    }

    public String getAccountInfo() {
        return this.L;
    }

    public void setAccountInfo(String accountInfo) {
        this.L = accountInfo;
    }

    public String getParser() {
        return this.M;
    }

    public void setParser(String parser) {
        this.M = parser;
    }

    public CommandCollector getMessageCollector() {
        return this.z;
    }

    public boolean isDebug() {
        return this.q;
    }

    public void setDebug(boolean debug) {
        this.q = debug;
    }

    public ProFTPClientInterface getFtp() {
        return this.g;
    }

    public void setFtp(ProFTPClientInterface ftp) {
        this.g = ftp;
    }

    public String getLogFile() {
        return this.r;
    }

    public void setLogFile(String logfile) throws IOException {
        this.r = logfile;
        Logger.clearAppenders();
        Logger.addAppender(new FileAppender(logfile));
    }

    public Level getLogLevel() {
        return this.u;
    }

    public void setLogLevel(Level logLevel) {
        this.u = logLevel;
        Logger.setLevel(logLevel);
    }

    public String getPassword() {
        return this.j;
    }

    public void setPassword(String password) {
        this.j = password;
    }

    public int getMaxSSLVersion() {
        return this.J;
    }

    public void setMaxSSLVersion(int maxSSLVersion) {
        this.J = maxSSLVersion;
    }

    public String getClientCertificate() {
        return this.A;
    }

    public void setClientCertificate(String clientCertificate) {
        this.A = clientCertificate;
    }

    public String getClientPassphrase() {
        return this.B;
    }

    public void setClientPassphrase(String clientPassphrase) {
        this.B = clientPassphrase;
    }

    public String getServerCertificate() {
        return this.C;
    }

    public void setServerCertificate(String serverCertificate) {
        this.C = serverCertificate;
    }

    public String getCommonName() {
        return this.D;
    }

    public void setCommonName(String commonName) {
        this.D = commonName;
    }

    public boolean getIgnoreCommonName() {
        return this.E;
    }

    public void setIgnoreCommonName(boolean ignoreCommonName) {
        this.E = ignoreCommonName;
    }

    public int getPort() {
        return this.m;
    }

    public void setPort(int port) {
        this.m = port;
        a.debug("Setting port = " + port);
    }

    public void setActivePortRange(int low, int high) {
        this.n = low;
        this.o = high;
        a.debug("Setting active port range " + low + "-" + high);
    }

    public int getActiveLowPort() {
        return this.n;
    }

    public int getActiveHighPort() {
        return this.o;
    }

    public Protocol getProtocol() {
        return this.v;
    }

    public void setProtocol(Protocol protocol) {
        this.v = protocol;
    }

    public ProxySettings getProxySettings() {
        return this.w;
    }

    public String getRemoteHost() {
        return this.k;
    }

    public void setRemoteHost(String remoteHost) {
        this.k = remoteHost;
    }

    public boolean canConnect() {
        return this.k != null && this.h != null && this.j != null;
    }

    public int getTimeout() {
        return this.p;
    }

    public void setTimeout(int timeout) {
        this.p = timeout;
    }

    public String getUser() {
        return this.h;
    }

    public void setUser(String user) {
        this.h = user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] a(Reader reader) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() <= 0 || string.startsWith("#") || string.startsWith("//")) continue;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void main(String[] args) {
        Object object;
        ScriptEngine.b();
        ScriptEngine.a(args);
        ScriptEngine scriptEngine = null;
        try {
            scriptEngine = new ScriptEngine();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (args.length == 0) {
            object = "Script file must be supplied";
            a.error((String)object);
            System.out.println((String)object);
            ScriptEngine.c();
            System.exit(-1);
        }
        if (!args[0].trim().startsWith("-")) {
            a.debug("Reading obsolete arguments");
            string = args[0];
            if (args.length == 3) {
                string3 = args[1];
                string4 = args[2];
            }
        } else {
            int n2;
            object = new GetOpt("ScriptEngine", args, "c:f:hu:p:v");
            block13: while ((n2 = ((GetOpt)object).getopt()) != -1) {
                switch (n2) {
                    case 99: {
                        string2 = ((GetOpt)object).getOptArg();
                        continue block13;
                    }
                    case 102: {
                        string = ((GetOpt)object).getOptArg();
                        continue block13;
                    }
                    case 104: {
                        bl = true;
                        continue block13;
                    }
                    case 117: {
                        string3 = ((GetOpt)object).getOptArg();
                        continue block13;
                    }
                    case 112: {
                        string4 = ((GetOpt)object).getOptArg();
                        continue block13;
                    }
                    case 118: {
                        bl3 = true;
                        continue block13;
                    }
                    case 63: {
                        bl2 = true;
                        continue block13;
                    }
                }
                bl2 = true;
            }
        }
        if (bl3) {
            System.out.println(VersionCommand.versionMessage());
            System.exit(0);
        }
        if (bl || bl2 || string == null) {
            ScriptEngine.c();
            int n3 = bl ? 0 : 1;
            System.exit(n3);
        }
        a.info("Reading script " + string);
        ScriptResult scriptResult = null;
        try {
            if (string3 != null) {
                scriptEngine.setUser(string3);
            }
            if (string4 != null) {
                scriptEngine.setPassword(string4);
            }
            if (string2 != null && (scriptResult = scriptEngine.executeScript(string2, false)).isForceScriptExit()) {
                System.exit(1);
            }
            scriptResult = scriptEngine.executeScript(string);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.exit(1);
        }
        if (scriptResult != null) {
            int n4 = scriptResult.isForceScriptExit() ? 1 : 0;
            System.exit(n4);
        }
        System.exit(1);
    }

    private static void b() {
        try {
            Logger.clearAppenders();
            Logger.addAppender(new FileAppender("runscript.log"));
            Logger.setLevel(Level.DEBUG);
        }
        catch (IOException iOException) {
            System.out.println("Failed to initialize: " + iOException.getMessage());
            System.exit(1);
        }
    }

    private static void a(String[] stringArray) {
        if (stringArray.length == 0) {
            a.debug("No args supplied");
        } else {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                a.debug("args[" + i2 + "]=" + stringArray[i2]);
            }
        }
    }

    private static void c() {
        String string = "[-h] [-c configfile] [-f scriptfile] [-u user] [-p password] [-v]";
        System.out.println(string);
        System.out.println("-f scriptfile   :  script to execute. ");
        System.out.println("-c configfile   :  config script to execute before main scriptfile. ");
        System.out.println("-h              :  display this help");
        System.out.println("-u user         :  set the user name");
        System.out.println("-p password     :  set the user password");
        System.out.println("-v              :  print version details");
    }
}

