/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.script;

import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.Protocol;
import com.enterprisedt.net.ftp.pro.ProFTPClientInterface;
import com.enterprisedt.net.ftp.script.CommandResult;
import com.enterprisedt.net.ftp.script.ScriptCommandImpl;
import com.enterprisedt.net.ftp.script.ScriptEngine;
import com.enterprisedt.net.ftp.script.ScriptVariable;
import com.enterprisedt.net.ftp.ssl.SSLFTPClient;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.proxy.ProxyType;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class SetCommand
extends ScriptCommandImpl {
    static String a = "********";

    public SetCommand() {
        this.setMustBeConnected(false);
    }

    @Override
    public String helpMessage() {
        return "set - set the value of a variable. Sets various parameters used during the session, many of which are optional. Syntax is set name=value. Note that 'set' can be omitted.  User defined variables can be created this way. If an unknown variable is set using the 'set' command, then a variable of that name and value is created. Use 'echo' to display the values of variables, and 'set' with no parameters to show all the currently set variables";
    }

    @Override
    public CommandResult execute(ScriptEngine engine, ProFTPClientInterface ftp, String command, String args) throws IOException, FTPException {
        if (args == null || args.length() == 0) {
            return new CommandResult(null, this.a(engine));
        }
        int n2 = args.indexOf(61);
        if (n2 < 0) {
            n2 = args.indexOf(32);
        }
        if (n2 < 0) {
            String string = "Invalid command - no value supplied";
            return new CommandResult(string, string);
        }
        String string = args.substring(0, n2).trim();
        String string2 = args.substring(n2 + 1).trim();
        if (string2.startsWith("`") && string2.endsWith("`")) {
            String string3 = string2.substring(1, string2.length() - 1);
            return this.b(engine, string, string3);
        }
        if ((string = string.toLowerCase()).equals("prot") || string.equals("protocol")) {
            if (ftp != null && ftp.connected()) {
                String string4 = "Cannot change protocol while connected";
                return new CommandResult(true, string4, string4);
            }
            Protocol protocol = Protocol.FTP;
            String string5 = string2.toLowerCase();
            if (string5.equals("ftp")) {
                protocol = Protocol.FTP;
            } else if (string5.equals("sftp")) {
                protocol = Protocol.SFTP;
            } else if (string5.equals("ftps") || string5.equals("ftpse")) {
                protocol = Protocol.FTPS_EXPLICIT;
            } else if (string5.equals("ftpsi")) {
                protocol = Protocol.FTPS_IMPLICIT;
            } else {
                String string6 = "Unknown protocol '" + string5 + "'";
                return new CommandResult(true, string6, string6);
            }
            engine.setProtocol(protocol);
            engine.setVariable("protocol", string5);
            String string7 = "Set protocol = " + protocol.toString();
            return new CommandResult(string7, string7);
        }
        if (string.equals("configflags")) {
            engine.setConfigFlags(string2);
            engine.setVariable("configflags", string2);
            String string8 = "Set configflags = " + string2;
            return new CommandResult(string8, string8);
        }
        if (string.equals("recordfile")) {
            engine.setRecordFile(string2);
            engine.setVariable("recordfile", string2);
            String string9 = "Set recordfile = " + string2;
            return new CommandResult(string9, string9);
        }
        if (string.equals("connectmode")) {
            string2 = string2.toLowerCase();
            FTPConnectMode fTPConnectMode = null;
            if (string2.equals("passive") || string2.equals("pasv")) {
                fTPConnectMode = FTPConnectMode.PASV;
            } else if (string2.equals("active")) {
                fTPConnectMode = FTPConnectMode.ACTIVE;
            } else {
                String string10 = "Unknown connect mode '" + string2 + "'";
                return new CommandResult(true, string10, string10);
            }
            engine.setConnectMode(fTPConnectMode);
            engine.setVariable("connectmode", string2);
            String string11 = "Set connect mode = " + fTPConnectMode.toString();
            return new CommandResult(string11, string11);
        }
        if (string.equals("tlsdebug")) {
            engine.setVariable(string, string2);
            System.getProperties().put("edtftp.log.puretls.level", string2);
            return new CommandResult(null, "Set cryptodebug on");
        }
        if (string.equals("cryptodebug")) {
            if ((string2 = string2.toLowerCase()).equals("true") || string2.equals("on")) {
                System.getProperties().put("edtftp.log.cryptix.debug", string2);
                System.getProperties().put("edtftp.log.cryptix.slowdebug", string2);
                System.getProperties().put("edtftp.log.cryptix.trace", string2);
                String string12 = "Set cryptodebug on";
                engine.setVariable(string, string2);
                return new CommandResult(string12, string12);
            }
        } else {
            if (string.equals("user") || string.equals("username")) {
                engine.setUser(string2);
                engine.setVariable(string, string2);
                String string13 = "Set user = " + string2;
                return new CommandResult(string13, string13);
            }
            if (string.equals("password") || string.equals("pwd") || string.equals("pass")) {
                engine.setPassword(string2);
                engine.setVariable(string, a);
                String string14 = "Set password";
                return new CommandResult(string14, string14);
            }
            if (string.equals("clientcert") || string.equals("clientcertificate")) {
                engine.setClientCertificate(string2);
                engine.setVariable(string, string2);
                String string15 = "Set client certificate";
                return new CommandResult(string15, string15);
            }
            if (string.equals("certpassword") || string.equals("certpwd")) {
                engine.setClientPassphrase(string2);
                engine.setVariable(string, a);
                String string16 = "Set client certificate passphrase";
                return new CommandResult(string16, string16);
            }
            if (string.equals("servercert") || string.equals("servercertificate")) {
                engine.setServerCertificate(string2);
                engine.setVariable(string, string2);
                String string17 = "Set server certificate";
                return new CommandResult(string17, string17);
            }
            if (string.equals("cn") || string.equals("commonname")) {
                engine.setCommonName(string2);
                engine.setVariable(string, string2);
                String string18 = "Set server common name";
                return new CommandResult(string18, string18);
            }
            if (string.equals("ignorecn") || string.equals("ignorecommonname")) {
                if ((string2 = string2.toLowerCase()).equals("true")) {
                    engine.setIgnoreCommonName(true);
                } else if (string2.equals("false")) {
                    engine.setIgnoreCommonName(false);
                } else {
                    String string19 = "Unknown flag for ignorecommonname '" + string2 + "' (expecting 'true' or 'false')";
                    return new CommandResult(true, string19, string19);
                }
                engine.setVariable(string, string2);
                String string20 = "Set server common name";
                return new CommandResult(string20, string20);
            }
            if (string.equals("knownhosts")) {
                engine.setKnownHosts(string2);
                engine.setVariable(string, string2);
                String string21 = "Set knownhosts";
                return new CommandResult(string21, string21);
            }
            if (string.equals("serverkey") || string.equals("serverpublickey")) {
                engine.setServerPublicKey(string2);
                engine.setVariable(string, string2);
                String string22 = "Set server public key";
                return new CommandResult(string22, string22);
            }
            if (string.equals("maxssl") || string.equals("maxsslversion")) {
                int n3 = SSLFTPClient.SSLVersion.getVersionFromString(string2);
                engine.setMaxSSLVersion(n3);
                engine.setVariable(string, string2);
                String string23 = "Set max SSL version to " + string2;
                return new CommandResult(string23, string23);
            }
            if (string.equals("clientkey") || string.equals("clientprivatekey")) {
                engine.setClientPrivateKey(string2);
                engine.setVariable(string, string2);
                String string24 = "Set client private key";
                return new CommandResult(string24, string24);
            }
            if (string.equals("clientkeypass") || string.equals("clientprivatekeypass")) {
                engine.setClientPrivateKeyPass(string2);
                engine.setVariable(string, a);
                String string25 = "Set client private key passphrase";
                return new CommandResult(string25, string25);
            }
            if (string.equals("host") || string.equals("remotehost")) {
                string2 = string2.toLowerCase();
                engine.setRemoteHost(string2);
                engine.setVariable(string, string2);
                String string26 = "Set host = " + string2;
                return new CommandResult(string26, string26);
            }
            if (string.equals("port")) {
                try {
                    engine.setPort(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    String string27 = "Failed to set port - value '" + string2 + "' not understood";
                    return new CommandResult(true, string27, string27);
                }
                engine.setVariable(string, string2);
                String string28 = "Set port = " + string2;
                return new CommandResult(string28, string28);
            }
            if (string.equals("dataports")) {
                int n4 = string2.indexOf(45);
                if (n4 > 0 && n4 + 1 < string2.length()) {
                    try {
                        int n5 = Integer.parseInt(string2.substring(0, n4));
                        int n6 = Integer.parseInt(string2.substring(++n4));
                        if (n6 > n5) {
                            engine.setActivePortRange(n5, n6);
                            engine.setVariable(string, string2);
                            String string29 = "Set dataports = " + string2;
                            return new CommandResult(string29, string29);
                        }
                        String string30 = "Failed to set dataports - the high port (" + n6 + ") must be greater than the low port (" + n5 + ")";
                        return new CommandResult(true, string30, string30);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                String string31 = "Failed to set dataports - value '" + string2 + "' not understood";
                return new CommandResult(true, string31, string31);
            }
            if (string.equals("localdir")) {
                engine.setLocalDir(string2);
                engine.setVariable(string, string2);
                String string32 = "Set local directory = " + string2;
                return new CommandResult(string32, string32);
            }
            if (string.equals("acct")) {
                engine.setAccountInfo(string2);
                engine.setVariable(string, string2);
                String string33 = "Set account info = " + string2;
                return new CommandResult(string33, string33);
            }
            if (string.equals("parser")) {
                engine.setParser(string2);
                engine.setVariable(string, string2);
                String string34 = "Set parser = " + string2;
                return new CommandResult(string34, string34);
            }
            if (string.equals("proxytype")) {
                if (ftp != null && ftp.connected()) {
                    String string35 = "Cannot change proxy setttings while connected";
                    return new CommandResult(true, string35, string35);
                }
                ProxyType proxyType = ProxyType.NO_PROXY;
                String string36 = string2.toLowerCase();
                if (string36.equals("http")) {
                    proxyType = ProxyType.HTTP;
                } else if (string36.equals("socks4")) {
                    proxyType = ProxyType.SOCKS4;
                } else if (string36.equals("socks5")) {
                    proxyType = ProxyType.SOCKS5;
                } else if (string36.equals("none") || string36.equals("noproxy")) {
                    proxyType = ProxyType.NO_PROXY;
                } else {
                    String string37 = "Unknown proxy type '" + string36 + "'";
                    return new CommandResult(true, string37, string37);
                }
                engine.getProxySettings().setProxyType(proxyType);
                String string38 = "Set proxy type = " + proxyType.toString();
                return new CommandResult(string38, string38);
            }
            if (string.equals("proxyaddress")) {
                engine.getProxySettings().setProxyAddress(string2);
                String string39 = "Set proxy address = " + string2;
                return new CommandResult(string39, string39);
            }
            if (string.equals("publicproxyaddress")) {
                engine.getProxySettings().setPublicProxyAddress(string2);
                String string40 = "Set public proxy address = " + string2;
                return new CommandResult(string40, string40);
            }
            if (string.equals("proxyport")) {
                engine.getProxySettings().setProxyPort(Integer.valueOf(string2));
                String string41 = "Set proxy port = " + string2;
                return new CommandResult(string41, string41);
            }
            if (string.equals("proxyuser")) {
                engine.getProxySettings().setProxyUserName(string2);
                String string42 = "Set proxy username = " + string2;
                return new CommandResult(string42, string42);
            }
            if (string.equals("proxypassword")) {
                engine.getProxySettings().setProxyPassword(string2);
                String string43 = "Set proxy password";
                return new CommandResult(string43, string43);
            }
            if (string.equals("debug")) {
                if ((string2 = string2.toLowerCase()).equals("off") || string2.equals("false")) {
                    engine.setDebug(false);
                } else if (string2.equals("on") || string2.equals("true")) {
                    engine.setDebug(true);
                }
                engine.setVariable(string, string2);
                String string44 = "Set debug " + (engine.isDebug() ? "on" : "off");
                return new CommandResult(string44, string44);
            }
            if (string.equals("logfile")) {
                engine.setLogFile(string2);
                engine.setVariable(string, string2);
                String string45 = "Set logfile = " + string2;
                return new CommandResult(string45, string45);
            }
            if (string.equals("loglevel")) {
                int n7 = 4;
                try {
                    n7 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    engine.setLogLevel(Level.DEBUG);
                    engine.setVariable(string, Integer.toString(Level.DEBUG.getLevel()));
                    String string46 = "Failed to read loglevel '" + string2 + " - set default log level = " + Level.DEBUG;
                    return new CommandResult(string46, string46);
                }
                Level level = Level.DEBUG;
                switch (n7) {
                    case 0: {
                        level = Level.OFF;
                        break;
                    }
                    case 1: {
                        level = Level.FATAL;
                        break;
                    }
                    case 2: {
                        level = Level.ERROR;
                        break;
                    }
                    case 3: {
                        level = Level.INFO;
                        break;
                    }
                    case 4: {
                        level = Level.DEBUG;
                        break;
                    }
                    case 5: {
                        level = Level.ALL;
                        break;
                    }
                    default: {
                        level = Level.DEBUG;
                    }
                }
                engine.setLogLevel(level);
                engine.setVariable(string, string2);
                String string47 = "Set log level = " + level.toString();
                return new CommandResult(string47, string47);
            }
            if (string.equals("timeout")) {
                try {
                    engine.setTimeout(Integer.parseInt(string2));
                    engine.setVariable(string, string2);
                    String string48 = "Set timeout = " + string2;
                    return new CommandResult(string48, string48);
                }
                catch (NumberFormatException numberFormatException) {
                    String string49 = "Could not set timeout - invalid value '" + string2 + "'";
                    return new CommandResult(true, string49, string49);
                }
            }
            return this.a(engine, string, string2);
        }
        return new CommandResult();
    }

    private String a(ScriptEngine scriptEngine) {
        Map map = scriptEngine.getVariablesMap();
        Iterator iterator = map.keySet().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ScriptVariable scriptVariable = (ScriptVariable)map.get(string);
            stringBuffer.append(string).append("=").append(scriptVariable.getValue());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("\n\r");
        }
        return stringBuffer.toString();
    }

    private CommandResult a(ScriptEngine scriptEngine, String string, String string2) {
        String string3;
        if (string2.charAt(0) == '$') {
            string3 = string2.substring(1);
            ScriptVariable scriptVariable = scriptEngine.getVariable(string3);
            if (scriptVariable == null) {
                String string4 = "Unknown variable '" + string3 + "'";
                return new CommandResult(string4, string4);
            }
            string2 = scriptVariable.getValue();
        }
        scriptEngine.setVariable(string, string2);
        string3 = "Created variable '" + string + "'";
        return new CommandResult(string3, string3);
    }

    private CommandResult b(ScriptEngine scriptEngine, String string, String string2) {
        CommandResult commandResult = scriptEngine.runCommand(string2);
        scriptEngine.setVariable(string, commandResult.getShellOutput());
        String string3 = "Created variable '" + string + "' from output of '" + string2 + "' command";
        return new CommandResult(string3, string3);
    }
}

