/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssh;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import com.enterprisedt.net.ftp.TransferDirection;
import com.enterprisedt.net.ftp.ssh.SSHFTPClient;
import com.enterprisedt.net.j2ssh.SftpClient;
import com.enterprisedt.net.j2ssh.sftp.SftpFileInputStream;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;

public abstract class AbstractSFTPInputStream
extends FileTransferInputStream {
    private static Logger a = Logger.getLogger("AbstractSFTPInputStream");
    protected SSHFTPClient client;
    protected SftpClient sftp;
    protected SftpFileInputStream in;

    public AbstractSFTPInputStream(SSHFTPClient client, String remoteFile) throws IOException, FTPException {
        this.client = client;
        this.sftp = client.a();
        this.remoteFile = remoteFile;
        this.monitorInterval = client.getMonitorInterval();
        this.monitor = client.getProgressMonitor();
    }

    protected void start() throws IOException {
        this.start(true);
    }

    protected void start(boolean firstTime) throws IOException {
        try {
            this.in = this.sftp.getInputStream(this.remoteFile);
        }
        catch (FTPException fTPException) {
            throw new IOException(fTPException.getMessage());
        }
        if (firstTime && this.monitorEx != null) {
            this.monitorEx.transferStarted(TransferDirection.DOWNLOAD, this.remoteFile);
        }
        this.started = true;
        this.closed = false;
        this.monitorCount = 0L;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.in.close();
            try {
                this.client.cancelResume();
            }
            catch (FTPException fTPException) {
                // empty catch block
            }
            if (this.monitor != null) {
                this.monitor.bytesTransferred(this.pos);
            }
            a.debug("Transferred " + this.pos + " bytes from remote host");
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, this.remoteFile);
            }
        }
    }
}

