/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssh;

import com.enterprisedt.net.ftp.DirectoryListCallback;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPProgressMonitorEx;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTypes;
import com.enterprisedt.net.ftp.RecursiveOperations;
import com.enterprisedt.net.ftp.TransferDirection;
import com.enterprisedt.net.ftp.WildcardFilter;
import com.enterprisedt.net.ftp.pro.ProFTPClientInterface;
import com.enterprisedt.net.ftp.ssh.SCPClient;
import com.enterprisedt.net.ftp.ssh.SSHFTPPublicKey;
import com.enterprisedt.net.ftp.ssh.a;
import com.enterprisedt.net.ftp.ssh.e;
import com.enterprisedt.net.j2ssh.FileTransferProgress;
import com.enterprisedt.net.j2ssh.SftpClient;
import com.enterprisedt.net.j2ssh.SshClient;
import com.enterprisedt.net.j2ssh.sftp.FileAttributes;
import com.enterprisedt.net.j2ssh.sftp.SftpFile;
import com.enterprisedt.util.debug.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SSHFTPClient
extends SCPClient
implements ProFTPClientInterface {
    private static Logger a = Logger.getLogger("SSHFTPClient");
    public static final String DEFAULT_ENCODING = "US-ASCII";
    public static final String EOL_CRLF = "\r\n";
    public static final String EOL_LF = "\n";
    private e b = new e();
    private FTPProgressMonitorEx c = null;
    private SftpClient d = null;
    private int e = 32;
    private FTPTransferType f = FTPTransferType.BINARY;
    private RecursiveOperations g = new RecursiveOperations();
    private boolean h = false;
    private int i = 32648;
    private int j = SftpClient.DEFAULT_BLOCKSIZE;
    private boolean k = false;
    private long l = 0L;
    private int m = 0;
    private String n = "UTF-8";
    private String o;
    private long p = 60000L;
    private String q = null;
    private int r = -1;
    private boolean s = true;
    private boolean t = true;
    private boolean u = true;
    private boolean v = false;

    public SSHFTPClient() {
        this.a(this.ssh);
        a.debug("Created SFTP client.");
    }

    public void setSCPMode(boolean on) {
        this.v = on;
    }

    public boolean isSCPMode() {
        return this.v;
    }

    public void setConfigFlags(int configFlags) throws FTPException {
        this.checkConnection(false);
        this.m = configFlags;
    }

    public int getConfigFlags() {
        return this.m;
    }

    public boolean isParallelMode() {
        return this.s;
    }

    public void setParallelMode(boolean parallelWriteMode) {
        this.s = parallelWriteMode;
        if (this.d != null) {
            this.d.setParallelMode(parallelWriteMode);
        }
    }

    public int getMaxQueuedReadRequests() {
        return this.e;
    }

    public void setMaxQueuedReadRequests(int maxQueuedReadRequests) {
        this.e = maxQueuedReadRequests;
        if (this.d != null) {
            this.d.setMaxQueuedReadRequests(maxQueuedReadRequests);
        }
    }

    public boolean checkDirReadableForChDir() {
        return this.t;
    }

    public void setCheckDirReadableForChDir(boolean checkDirReadableForChDir) {
        this.t = checkDirReadableForChDir;
        if (this.d != null) {
            this.d.setCheckDirReadableForChDir(checkDirReadableForChDir);
        }
    }

    @Override
    public boolean getFileLockingEnabled() {
        return this.u;
    }

    @Override
    public void setFileLockingEnabled(boolean fileLockingEnabled) {
        this.u = fileLockingEnabled;
        if (this.d != null) {
            this.d.setFileLockingEnabled(fileLockingEnabled);
        }
    }

    @Override
    public void setMaxTransferRate(int thresholdBytesPerSecond) {
        this.r = thresholdBytesPerSecond;
        if (this.d != null) {
            this.d.setMaxTransferRate(thresholdBytesPerSecond);
        }
    }

    @Override
    public int getMaxTransferRate() {
        return this.r;
    }

    public long getServerResponseTimeout() {
        return this.p;
    }

    public void setServerResponseTimeout(long serverResponseTimeout) throws FTPException {
        this.setTimeout((int)serverResponseTimeout);
    }

    @Override
    public void setControlEncoding(String controlEncoding) throws FTPException {
        this.checkConnection(false);
        this.n = controlEncoding;
    }

    public static SSHFTPPublicKey getHostPublicKey(String remoteHost) throws FTPException {
        return SSHFTPClient.getHostPublicKey(remoteHost, 22);
    }

    public static SSHFTPPublicKey getHostPublicKey(String remoteHost, int remotePort) throws FTPException {
        SSHFTPClient sSHFTPClient = new SSHFTPClient();
        sSHFTPClient.setRemoteHost(remoteHost);
        sSHFTPClient.setRemotePort(remotePort);
        sSHFTPClient.setAuthentication("", "");
        try {
            sSHFTPClient.connect();
        }
        catch (Exception exception) {
            Logger logger = Logger.getLogger(SSHFTPClient.class);
            logger.debug("Expected exception", exception);
        }
        return sSHFTPClient.getValidator().getHostPublicKey();
    }

    @Override
    public void setTimeout(int millis) throws FTPException {
        this.checkConnection(false);
        this.p = millis;
        this.ssh.setSocketTimeout(millis);
    }

    @Override
    public void setDetectTransferMode(boolean detectTransferMode) {
        this.h = detectTransferMode;
    }

    @Override
    public boolean getDetectTransferMode() {
        return this.h;
    }

    public int getMaxPacketSize() {
        return this.i;
    }

    public void setMaxPacketSize(int maxPacketSize) throws FTPException {
        this.checkConnection(false);
        this.i = maxPacketSize;
        this.ssh.setMaxPacketSize(maxPacketSize);
    }

    public void setTransferBufferSize(int size) {
        this.j = size;
    }

    public int getTransferBufferSize() {
        return this.j;
    }

    public void setRemoteEOL(String remoteEOL) {
        this.o = remoteEOL;
        a.debug("Setting remote EOL manually");
    }

    public String getRemoteEOL() {
        return this.o;
    }

    @Override
    public FTPTransferType getType() {
        return this.f;
    }

    @Override
    public void setType(FTPTransferType type) {
        this.f = type;
        if (this.d != null) {
            this.d.setType(this.f);
            this.d.setRemoteEOL(this.o != null ? this.o : this.ssh.getRemoteEOLString());
        }
    }

    public String getSFTPSubsystemPath() {
        return this.q;
    }

    SftpClient a() {
        return this.d;
    }

    public void setSFTPSubsystemPath(String sftpSubsystemPath) {
        this.q = sftpSubsystemPath;
    }

    @Override
    public void resumeNextDownload(long offset) throws FTPException {
        this.resume();
        if (offset < 0L) {
            throw new FTPException("Offset must be >= 0");
        }
        this.l = offset;
    }

    @Override
    public void resume() throws FTPException {
        if (this.f.equals(FTPTransferType.ASCII)) {
            throw new FTPException("Resume only supported for BINARY transfers");
        }
        this.k = true;
    }

    @Override
    public void cancelResume() throws IOException, FTPException {
        this.k = false;
    }

    @Override
    public void cancelTransfer() {
        a.debug("cancelTransfer() called");
        this.b.c();
    }

    public boolean isTransferCancelled() {
        return this.b.isCancelled();
    }

    @Override
    public void connect() throws IOException, FTPException {
        this.checkConnection(false);
        if (this.v) {
            a.debug("SCP mode");
            super.connect();
            return;
        }
        this.connectSSH();
        int n2 = 0;
        if ((this.m & ConfigFlags.DISABLE_CHMOD_AFTER_PUT) != 0) {
            n2 |= 1;
            a.debug("DISABLE_CHMOD_AFTER_PUT is set");
        }
        if ((this.m & ConfigFlags.DISABLE_WAIT_FOR_CHANNEL_CLOSE) != 0) {
            n2 |= 2;
            a.debug("DISABLE_WAIT_FOR_CHANNEL_CLOSE is set");
        }
        if ((this.m & ConfigFlags.DISABLE_CHMOD_AFTER_CREATE_DIR) != 0) {
            n2 |= 4;
            a.debug("DISABLE_CHMOD_AFTER_CREATE_DIR is set");
        }
        this.d = this.ssh.openSftpClient(this.q, n2);
        this.d.setType(this.f);
        this.d.setRemoteEOL(this.o != null ? this.o : this.ssh.getRemoteEOLString());
        this.d.setBlockSize(this.j);
        this.d.setControlEncoding(this.n);
        this.d.setServerResponseTimeout(this.p);
        this.d.setMaxTransferRate(this.r);
        this.d.setParallelMode(this.s);
        this.d.setCheckDirReadableForChDir(this.t);
        this.d.setMaxQueuedReadRequests(this.e);
    }

    public String getDetectedRemoteEOL() {
        return this.ssh.getRemoteEOLString();
    }

    @Override
    public boolean connected() {
        if (this.v) {
            return super.connected();
        }
        return this.d == null ? false : !this.d.isClosed();
    }

    @Override
    public void setProgressMonitor(FTPProgressMonitor monitor, long interval) {
        this.b.a(monitor);
        this.b.a(interval);
    }

    @Override
    public void setProgressMonitor(FTPProgressMonitor monitor) {
        this.b.a(monitor);
    }

    @Override
    public long getMonitorInterval() {
        return this.b.b();
    }

    @Override
    public void setMonitorInterval(long interval) {
        this.b.a(interval);
    }

    public FTPProgressMonitor getProgressMonitor() {
        return this.b.a();
    }

    @Override
    public FTPProgressMonitorEx getProgressMonitorEx() {
        return this.c;
    }

    @Override
    public void setProgressMonitorEx(FTPProgressMonitorEx monitorEx) {
        this.c = monitorEx;
        this.b.a(monitorEx);
    }

    @Override
    public long size(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        return this.d.stat(remoteFile).getSize().longValue();
    }

    private void a(String string) throws FTPException {
        if (string == null) {
            throw new FTPException("A remote filename must be supplied for this protocol (SFTP)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String put(String localPath, String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            a.debug("SCP put");
            return super.put(localPath, remoteFile);
        }
        this.a(remoteFile);
        FTPTransferType fTPTransferType = this.f;
        this.d(localPath);
        if (this.c != null) {
            this.c.transferStarted(TransferDirection.UPLOAD, remoteFile);
        }
        try {
            this.d.put(localPath, remoteFile, (FileTransferProgress)this.b, false, this.k);
            ++this.uploadCount;
        }
        finally {
            this.f = fTPTransferType;
            this.k = false;
            if (this.c != null) {
                this.c.transferComplete(TransferDirection.UPLOAD, remoteFile);
            }
        }
        return remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String put(String localPath, String remoteFile, boolean append) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            if (append) {
                throw new FTPException("Append not supported for SCP");
            }
            return super.put(localPath, remoteFile);
        }
        this.a(remoteFile);
        FTPTransferType fTPTransferType = this.f;
        this.d(localPath);
        if (this.c != null) {
            this.c.transferStarted(TransferDirection.UPLOAD, remoteFile);
        }
        try {
            this.d.put(localPath, remoteFile, (FileTransferProgress)this.b, append, this.k);
            ++this.uploadCount;
        }
        finally {
            this.f = fTPTransferType;
            this.k = false;
            if (this.c != null) {
                this.c.transferComplete(TransferDirection.UPLOAD, remoteFile);
            }
        }
        return remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String put(InputStream srcStream, String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("Put stream not supported for SCP");
        }
        this.a(remoteFile);
        FTPTransferType fTPTransferType = this.f;
        this.d(remoteFile);
        if (this.c != null) {
            this.c.transferStarted(TransferDirection.UPLOAD, remoteFile);
        }
        try {
            this.d.put(srcStream, remoteFile, (FileTransferProgress)this.b, false, this.k);
            ++this.uploadCount;
        }
        finally {
            this.f = fTPTransferType;
            this.k = false;
            if (this.c != null) {
                this.c.transferComplete(TransferDirection.UPLOAD, remoteFile);
            }
        }
        return remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String put(InputStream srcStream, String remoteFile, boolean append) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("Append not supported for SCP");
        }
        this.a(remoteFile);
        FTPTransferType fTPTransferType = this.f;
        this.d(remoteFile);
        if (this.c != null) {
            this.c.transferStarted(TransferDirection.UPLOAD, remoteFile);
        }
        try {
            this.d.put(srcStream, remoteFile, (FileTransferProgress)this.b, append, this.k);
            ++this.uploadCount;
        }
        finally {
            this.f = fTPTransferType;
            this.k = false;
            if (this.c != null) {
                this.c.transferComplete(TransferDirection.UPLOAD, remoteFile);
            }
        }
        return remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String put(byte[] bytes, String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("Put bytes not supported for SCP");
        }
        this.a(remoteFile);
        FTPTransferType fTPTransferType = this.f;
        this.d(remoteFile);
        if (this.c != null) {
            this.c.transferStarted(TransferDirection.UPLOAD, remoteFile);
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            this.d.put(byteArrayInputStream, remoteFile, (FileTransferProgress)this.b, false, this.k);
            ++this.uploadCount;
            ((InputStream)byteArrayInputStream).close();
        }
        finally {
            this.f = fTPTransferType;
            this.k = false;
            if (this.c != null) {
                this.c.transferComplete(TransferDirection.UPLOAD, remoteFile);
            }
        }
        return remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String put(byte[] bytes, String remoteFile, boolean append) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("Append not supported for SCP");
        }
        this.a(remoteFile);
        FTPTransferType fTPTransferType = this.f;
        this.d(remoteFile);
        if (this.c != null) {
            this.c.transferStarted(TransferDirection.UPLOAD, remoteFile);
        }
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(bytes);
            this.d.put(byteArrayInputStream, remoteFile, (FileTransferProgress)this.b, append, this.k);
            ++this.uploadCount;
        }
        finally {
            this.f = fTPTransferType;
            this.k = false;
            if (this.c != null) {
                this.c.transferComplete(TransferDirection.UPLOAD, remoteFile);
            }
            try {
                ((InputStream)byteArrayInputStream).close();
            }
            catch (IOException iOException) {}
        }
        return remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(String localPath, String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            a.debug("SCP get");
            super.get(localPath, remoteFile);
            return;
        }
        File file = new File(localPath);
        if (file.isDirectory()) {
            localPath = localPath + File.separator + remoteFile;
            a.debug("Setting local path to " + localPath);
        }
        FTPTransferType fTPTransferType = this.f;
        this.d(remoteFile);
        if (this.c != null) {
            this.c.transferStarted(TransferDirection.DOWNLOAD, remoteFile);
        }
        try {
            this.d.get(remoteFile, localPath, this.b, this.k, this.l);
            ++this.downloadCount;
        }
        finally {
            this.f = fTPTransferType;
            this.k = false;
            this.l = 0L;
            if (this.c != null) {
                this.c.transferComplete(TransferDirection.DOWNLOAD, remoteFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(OutputStream destStream, String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("Get stream not supported for SCP");
        }
        FTPTransferType fTPTransferType = this.f;
        this.d(remoteFile);
        if (this.c != null) {
            this.c.transferStarted(TransferDirection.DOWNLOAD, remoteFile);
        }
        try {
            if (this.k && this.l != 0L) {
                a.debug("Resume marker set to: " + this.l);
            }
            this.d.get(remoteFile, destStream, this.b, this.l);
            ++this.downloadCount;
        }
        finally {
            this.f = fTPTransferType;
            this.k = false;
            this.l = 0L;
            if (this.c != null) {
                this.c.transferComplete(TransferDirection.DOWNLOAD, remoteFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("Get bytes not supported for SCP");
        }
        FTPTransferType fTPTransferType = this.f;
        this.d(remoteFile);
        try {
            if (this.k && this.l != 0L) {
                a.debug("Resume marker set to: " + this.l);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (this.c != null) {
                this.c.transferStarted(TransferDirection.DOWNLOAD, remoteFile);
            }
            this.d.get(remoteFile, byteArrayOutputStream, this.b, this.l);
            ++this.downloadCount;
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = null;
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            this.f = fTPTransferType;
            this.k = false;
            this.l = 0L;
            if (this.c != null) {
                this.c.transferComplete(TransferDirection.DOWNLOAD, remoteFile);
            }
        }
    }

    public FTPFile fileDetails(String name) throws IOException, FTPException {
        if (this.v) {
            throw new FTPException("File details not supported for SCP");
        }
        String string = this.d.getAbsolutePath(name);
        FileAttributes fileAttributes = this.d.stat(string);
        SftpFile sftpFile = new SftpFile(string, fileAttributes);
        return this.a(sftpFile);
    }

    @Override
    public void dirDetails(String dirname, DirectoryListCallback lister) throws IOException, FTPException, ParseException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("Dir details not supported for SCP");
        }
        this.a(dirname, lister);
    }

    @Override
    public FTPFile[] dirDetails(String dirname) throws IOException, FTPException, ParseException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("Dir details not supported for SCP");
        }
        List list = this.b(dirname);
        FTPFile[] fTPFileArray = new FTPFile[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SftpFile sftpFile = (SftpFile)list.get(i2);
            fTPFileArray[i2] = this.a(sftpFile);
        }
        return fTPFileArray;
    }

    private FTPFile a(SftpFile sftpFile) {
        FileAttributes fileAttributes = sftpFile.getAttributes();
        Date date = new Date(fileAttributes.getModifiedTime().longValue() * 1000L);
        FTPFile fTPFile = new FTPFile(sftpFile.getLongname(), sftpFile.getFilename(), fileAttributes.getSize().longValue(), fileAttributes.isDirectory(), date);
        fTPFile.setOwner(fileAttributes.getUID().toString());
        fTPFile.setGroup(fileAttributes.getGID().toString());
        fTPFile.setPath(sftpFile.getAbsolutePath());
        fTPFile.setPermissions(fileAttributes.getPermissionsString());
        fTPFile.setLink(fileAttributes.isLink());
        if (fileAttributes.isLink()) {
            try {
                String string = this.d.getSymbolicLinkTarget(sftpFile.getAbsolutePath());
                fTPFile.setLinkedName(string);
            }
            catch (Exception exception) {
                a.warn("Failed to get link target for '" + sftpFile.getFilename() + "'");
            }
        }
        return fTPFile;
    }

    @Override
    public String[] dir() throws IOException, FTPException {
        return this.dir(".");
    }

    @Override
    public String[] dir(String dirname) throws IOException, FTPException {
        return this.dir(dirname, false);
    }

    @Override
    public String[] dir(String dirname, boolean full) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("Dir not supported for SCP");
        }
        List list = this.b(dirname);
        String[] stringArray = new String[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SftpFile sftpFile = (SftpFile)list.get(i2);
            stringArray[i2] = full ? sftpFile.getLongname() : sftpFile.getFilename();
        }
        return stringArray;
    }

    private List b(String string) throws IOException, FTPException {
        a.debug("getFileListing(" + string + ")");
        List<SftpFile> list = new ArrayList();
        if (this.c(string)) {
            String string2 = string;
            String string3 = "";
            int n2 = -1;
            n2 = string.lastIndexOf(47);
            if (n2 > 0 && n2 < string.length()) {
                string2 = string.substring(n2 + 1);
                string3 = string.substring(0, n2);
            }
            a.debug("getFileListing(" + string3 + "," + string2 + ")");
            WildcardFilter wildcardFilter = new WildcardFilter(string2);
            list = this.d.ls(string3, wildcardFilter);
        } else {
            try {
                list = this.d.ls(string, null);
            }
            catch (FTPException fTPException) {
                String string4 = this.d.getAbsolutePath(string);
                FileAttributes fileAttributes = this.d.stat(string4);
                if (!fileAttributes.isFile()) {
                    throw fTPException;
                }
                SftpFile sftpFile = new SftpFile(string4, fileAttributes);
                list.add(sftpFile);
            }
        }
        return list;
    }

    private void a(String string, DirectoryListCallback directoryListCallback) throws IOException, FTPException {
        a a2 = new a(directoryListCallback);
        if (this.c(string)) {
            String string2 = string;
            String string3 = "";
            int n2 = -1;
            n2 = string.lastIndexOf(47);
            if (n2 > 0 && n2 < string.length()) {
                string2 = string.substring(n2 + 1);
                string3 = string.substring(0, n2);
            }
            WildcardFilter wildcardFilter = new WildcardFilter(string2);
            this.d.ls(string3, wildcardFilter, a2);
        } else {
            try {
                this.d.ls(string, null, a2);
            }
            catch (Exception exception) {
                String string4 = this.d.getAbsolutePath(string);
                FileAttributes fileAttributes = this.d.stat(string4);
                SftpFile sftpFile = new SftpFile(string4, fileAttributes);
                a2.listDirectoryEntry(sftpFile);
            }
        }
    }

    private boolean c(String string) {
        for (int i2 = 0; i2 < WildcardFilter.WILDCARD_CHARS.length; ++i2) {
            if (string.indexOf(WildcardFilter.WILDCARD_CHARS[i2]) < 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void delete(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("Delete not supported for SCP");
        }
        this.d.removeFile(remoteFile);
        ++this.deleteCount;
    }

    @Override
    public void rename(String from, String to) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("Rename not supported for SCP");
        }
        this.d.rename(from, to);
    }

    @Override
    public boolean exists(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("Exists not supported for SCP");
        }
        try {
            this.d.stat(remoteFile);
            return true;
        }
        catch (FTPException fTPException) {
            if (fTPException.getReplyCode() == 2) {
                return false;
            }
            throw fTPException;
        }
    }

    @Override
    public void rmdir(String dir) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("rmdir not supported for SCP");
        }
        FileAttributes fileAttributes = this.d.stat(dir);
        if (!fileAttributes.isDirectory()) {
            throw new FTPException(dir + " is not a directory.");
        }
        List list = this.d.ls(dir, null);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SftpFile sftpFile = (SftpFile)list.get(i2);
            if (sftpFile.getFilename().equals(".") || sftpFile.getFilename().equals("..")) continue;
            throw new FTPException("Directory " + dir + " is not empty");
        }
        this.d.rm(dir);
    }

    @Override
    public void mkdir(String dir) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("mkdir not supported for SCP");
        }
        this.d.mkdir(dir);
    }

    public void changeMode(int permissions, String path) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("chmod not supported for SCP");
        }
        this.d.chmod(permissions, path);
    }

    public void changeMode(String permissions, String path) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("chmod not supported for SCP");
        }
        this.d.chmod(Integer.parseInt(permissions, 8), path);
    }

    public void changeGroup(int gid, String path) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("chgrp not supported for SCP");
        }
        this.d.chgrp(gid, path);
    }

    public void changeOwner(int uid, String path) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("chown not supported for SCP");
        }
        this.d.chown(uid, path);
    }

    public void setUmask(String umask) throws FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("Cannot set umask in SCP");
        }
        this.d.setUmask(umask);
    }

    public String getUmask() throws FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("umask not supported for SCP");
        }
        return this.d.getUmask();
    }

    @Override
    public void chdir(String dir) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("chdir not supported for SCP");
        }
        this.d.cd(dir);
    }

    @Override
    public void cdup() throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("cdup not supported for SCP");
        }
        this.d.cd("..");
    }

    @Override
    public Date modtime(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("modtime not supported for SCP");
        }
        return this.d.getModTime(remoteFile);
    }

    @Override
    public void setModTime(String path, Date modTime) throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            throw new FTPException("modtime not supported for SCP");
        }
        this.d.setModTime(path, modTime);
    }

    @Override
    public String pwd() throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            return "";
        }
        return this.d.pwd();
    }

    @Override
    public void mdelete(String wildcard) throws IOException, FTPException, ParseException {
        if (this.v) {
            throw new FTPException("multi ops not supported for SCP");
        }
        a.debug("mdelete(" + wildcard + ")");
        this.g.deleteFilesCurrentDir(this, new WildcardFilter(wildcard));
    }

    @Override
    public void mdelete(FileFilter filter) throws IOException, FTPException, ParseException {
        if (this.v) {
            throw new FTPException("multi ops not supported for SCP");
        }
        a.debug("mdelete(" + filter.toString() + ")");
        this.g.deleteFilesCurrentDir(this, filter);
    }

    @Override
    public void mdelete(String remoteDir, String wildcard, boolean recurse) throws IOException, FTPException, ParseException {
        if (this.v) {
            throw new FTPException("multi ops not supported for SCP");
        }
        a.debug("mdelete(" + remoteDir + "," + wildcard + "," + recurse + ")");
        this.g.deleteFiles(this, remoteDir, new WildcardFilter(wildcard), recurse);
    }

    @Override
    public void mdelete(String remoteDir, FileFilter filter, boolean recurse) throws IOException, FTPException, ParseException {
        if (this.v) {
            throw new FTPException("multi ops not supported for SCP");
        }
        a.debug("mdelete(" + remoteDir + "," + filter.toString() + "," + recurse + ")");
        this.g.deleteFiles(this, remoteDir, filter, recurse);
    }

    @Override
    public void rmdir(String remoteDir, boolean recurse) throws IOException, FTPException, ParseException {
        if (this.v) {
            throw new FTPException("multi ops not supported for SCP");
        }
        if (!recurse) {
            this.rmdir(remoteDir);
        } else {
            this.g.delete(this, remoteDir);
        }
    }

    @Override
    public void mput(String localDir, String wildcard) throws IOException, FTPException {
        if (this.v) {
            throw new FTPException("multi ops not supported for SCP");
        }
        a.debug("mput(" + localDir + "," + wildcard + ")");
        this.g.putFilesIntoCurrentDir(this, localDir, new WildcardFilter(wildcard));
    }

    @Override
    public void mput(String localDir, FileFilter filter) throws IOException, FTPException {
        if (this.v) {
            throw new FTPException("multi ops not supported for SCP");
        }
        a.debug("mput(" + localDir + "," + filter.toString() + ")");
        this.g.putFilesIntoCurrentDir(this, localDir, filter);
    }

    @Override
    public void mput(String localDir, String remoteDir, String wildcard, boolean recurse) throws FTPException, IOException {
        if (this.v) {
            throw new FTPException("multi ops not supported for SCP");
        }
        a.debug("mput(" + localDir + "," + remoteDir + "," + wildcard + "," + recurse + ")");
        this.g.put(this, localDir, remoteDir, new WildcardFilter(wildcard), recurse);
    }

    @Override
    public void mput(String localDir, String remoteDir, FileFilter filter, boolean recurse) throws FTPException, IOException {
        if (this.v) {
            throw new FTPException("multi ops not supported for SCP");
        }
        a.debug("mput(" + localDir + "," + remoteDir + "," + filter.toString() + "," + recurse + ")");
        this.g.put(this, localDir, remoteDir, filter, recurse);
    }

    @Override
    public void mget(String localDir, String wildcard) throws IOException, FTPException, ParseException {
        if (this.v) {
            throw new FTPException("multi ops not supported for SCP");
        }
        a.debug("mget(" + localDir + "," + wildcard + ")");
        this.g.getFilesFromCurrentDir(this, localDir, new WildcardFilter(wildcard));
    }

    @Override
    public void mget(String localDir, FileFilter filter) throws IOException, FTPException, ParseException {
        if (this.v) {
            throw new FTPException("multi ops not supported for SCP");
        }
        a.debug("mget(" + localDir + "," + filter.toString() + ")");
        this.g.getFilesFromCurrentDir(this, localDir, filter);
    }

    @Override
    public void mget(String localDir, String remoteDir, String wildcard, boolean recurse) throws FTPException, IOException, ParseException {
        if (this.v) {
            throw new FTPException("multi ops not supported for SCP");
        }
        a.debug("mget(" + localDir + "," + remoteDir + "," + wildcard + "," + recurse + ")");
        this.g.get(this, localDir, remoteDir, new WildcardFilter(wildcard), recurse);
    }

    @Override
    public void mget(String localDir, String remoteDir, FileFilter filter, boolean recurse) throws FTPException, IOException, ParseException {
        if (this.v) {
            throw new FTPException("multi ops not supported for SCP");
        }
        a.debug("mget(" + localDir + "," + remoteDir + "," + filter.toString() + "," + recurse + ")");
        this.g.get(this, localDir, remoteDir, filter, recurse);
    }

    @Override
    public int getCountBeforeSleep() {
        return this.g.getCountBeforeSleep();
    }

    @Override
    public void setCountBeforeSleep(int countBeforeSleep) {
        this.g.setCountBeforeSleep(countBeforeSleep);
    }

    @Override
    public boolean isSleepEnabled() {
        return this.g.isSleepEnabled();
    }

    @Override
    public void setSleepEnabled(boolean sleepEnabled) {
        this.g.setSleepEnabled(sleepEnabled);
    }

    @Override
    public int getSleepTime() {
        return this.g.getSleepTime();
    }

    @Override
    public void setSleepTime(int sleepTime) {
        this.g.setSleepTime(sleepTime);
    }

    @Override
    public void keepAlive() throws IOException, FTPException {
        if (this.v) {
            a.debug("No keepalive in SCP");
            return;
        }
        a.debug("keepAlive() called - sending SSH_FXP_REALPATH");
        if (this.d != null) {
            this.d.getAbsolutePath(".");
        } else {
            a.warn("Could not send SSH_FXP_REALPATH for keepAlive()");
        }
    }

    @Override
    public void quit() throws IOException, FTPException {
        this.checkConnection(true);
        if (this.v) {
            super.quit();
        } else {
            this.d.quit();
            this.d = null;
            this.ssh.disconnect();
            this.ssh.close();
            this.ssh = new SshClient();
            this.a(this.ssh);
        }
    }

    @Override
    public void quitImmediately() throws IOException, FTPException {
        if (this.v) {
            super.quitImmediately();
        } else {
            if (this.d != null) {
                this.d.quitImmediately();
                this.d = null;
            }
            this.ssh.disconnectImmediately();
            this.ssh.close();
            this.d = null;
            this.ssh = new SshClient();
            this.a(this.ssh);
        }
    }

    private void a(SshClient sshClient) {
        this.ssh.setMaxPacketSize(this.i);
        this.ssh.setSocketTimeout((int)this.p);
    }

    private void d(String string) {
        if (this.h) {
            if (FileTypes.ASCII.matches(string) && this.f.equals(FTPTransferType.BINARY)) {
                this.setType(FTPTransferType.ASCII);
                a.debug("Autodetect on - changed transfer type to ASCII");
            } else if (FileTypes.BINARY.matches(string) && this.f.equals(FTPTransferType.ASCII)) {
                this.setType(FTPTransferType.BINARY);
                a.debug("Autodetect on - changed transfer type to binary");
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append("SFTP").append(",").append(this.getRemoteHost()).append(",").append(this.getRemotePort()).append(",").append(this.getId()).append("]");
        return stringBuffer.toString();
    }

    public static class ConfigFlags {
        public static int DISABLE_POST_CREATE_CHMOD = 1;
        public static int DISABLE_CHMOD_AFTER_PUT = 1;
        public static int DISABLE_WAIT_FOR_CHANNEL_CLOSE = 2;
        public static int DISABLE_CHMOD_AFTER_CREATE_DIR = 4;
    }
}

