/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssh;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPProgressMonitorEx;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import com.enterprisedt.net.ftp.ssh.AbstractSFTPInputStream;
import com.enterprisedt.net.ftp.ssh.SSHFTPClient;
import com.enterprisedt.net.ftp.ssh.c;
import com.enterprisedt.net.ftp.ssh.d;
import java.io.IOException;

public class SSHFTPInputStream
extends FileTransferInputStream {
    private AbstractSFTPInputStream a;

    public SSHFTPInputStream(SSHFTPClient client, String remoteFile) throws IOException, FTPException {
        this(client, remoteFile, 0L);
    }

    public SSHFTPInputStream(SSHFTPClient client, String remoteFile, long offset) throws IOException, FTPException {
        if (!client.exists(remoteFile)) {
            throw new FTPException("File " + remoteFile + " not found.");
        }
        this.remoteFile = remoteFile;
        boolean bl = client.getType().equals(FTPTransferType.ASCII);
        if (bl) {
            if (offset > 0L) {
                throw new FTPException("Offset for ASCII transfers must be 0");
            }
            this.a = new c(client, remoteFile);
        } else {
            this.a = new d(client, remoteFile, offset);
        }
        this.a.setMonitor(this.monitorEx, this.monitorInterval);
    }

    @Override
    public void setMonitor(FTPProgressMonitorEx monitor, long monitorInterval) {
        super.setMonitor(monitor, monitorInterval);
        this.a.setMonitor(monitor, monitorInterval);
    }

    @Override
    public int read() throws IOException {
        return this.a.read();
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        return this.a.read(b2, off, len);
    }

    @Override
    public void close() throws IOException {
        this.a.close();
    }

    @Override
    public long skip(long n2) throws IOException {
        return this.a.skip(n2);
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.a.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.a.reset();
    }

    @Override
    public boolean markSupported() {
        return this.a.markSupported();
    }
}

