/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssh;

import com.enterprisedt.net.ftp.ssh.SSHFTPException;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKeyFormat;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKeyFormatFactory;
import java.io.IOException;
import java.io.OutputStream;

public class SSHFTPPublicKey {
    public static final int OPENSSH_FORMAT = 0;
    public static final int IETF_SECSH_FORMAT = 1;
    private SshPublicKey a;

    SSHFTPPublicKey(SshPublicKey key) {
        this.a = key;
    }

    SshPublicKey a() {
        return this.a;
    }

    public String getAlgorithmName() {
        return this.a.getKeyFormatName();
    }

    public int getBitLength() {
        return this.a.getBitLength();
    }

    public byte[] getKeyData() {
        return this.a.getEncoded();
    }

    public String getFingerprint() {
        return this.a.getFingerprint();
    }

    public boolean equals(Object obj) {
        return this.a.equals(obj);
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    public int write(OutputStream outStr, int formatCode) throws SSHFTPException, IOException {
        SshPublicKeyFormat sshPublicKeyFormat = null;
        try {
            switch (formatCode) {
                case 0: {
                    sshPublicKeyFormat = SshPublicKeyFormatFactory.newInstance("OpenSSH-PublicKey");
                    break;
                }
                case 1: {
                    sshPublicKeyFormat = SshPublicKeyFormatFactory.newInstance("SECSH-PublicKey-Base64Encoded");
                }
            }
        }
        catch (InvalidSshKeyException invalidSshKeyException) {
            throw new SSHFTPException("Internal inconsistency in SSHFTPPublicKey.write: " + invalidSshKeyException.getMessage());
        }
        if (sshPublicKeyFormat == null) {
            throw new SSHFTPException("Unsupported key format-code: " + sshPublicKeyFormat);
        }
        byte[] byArray = sshPublicKeyFormat.formatKey(this.a.getEncoded());
        outStr.write(byArray);
        return byArray.length;
    }
}

