/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssl;

import com.enterprisedt.net.ftp.ssl.SSLFTPCertificate;
import com.enterprisedt.net.ftp.ssl.SSLFTPCertificateException;
import com.enterprisedt.net.ftp.ssl.SSLFTPException;
import com.enterprisedt.net.puretls.SSLDebug;
import com.enterprisedt.net.puretls.cert.CertificateDecodeException;
import com.enterprisedt.net.puretls.cert.WrappedObject;
import com.enterprisedt.net.puretls.cert.X509Cert;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class SSLFTPCertificateStore
implements List {
    private static Logger a = Logger.getLogger("SSLFTPCertificateStore");
    private Vector b = new Vector();
    private a c;

    public void importCertificates(String fileName) throws FileNotFoundException, IOException {
        try {
            if (this.a(fileName)) {
                this.importPEMFile(fileName);
            } else {
                this.importKeyStore(fileName);
            }
        }
        catch (SSLFTPCertificateException sSLFTPCertificateException) {
            String string = "Failed to read certificates from file '" + fileName + "': " + sSLFTPCertificateException.getMessage();
            a.error(string, sSLFTPCertificateException);
            throw new IOException(string);
        }
        catch (KeyStoreException keyStoreException) {
            String string = "Failed to read certificates from file '" + fileName + "': " + keyStoreException.getMessage();
            a.error(string, keyStoreException);
            throw new IOException(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(String string) throws FileNotFoundException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        try {
            if (WrappedObject.findObject(bufferedReader, "CERTIFICATE", null)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public void importPEMFile(String fileName) throws FileNotFoundException, IOException, SSLFTPCertificateException {
        a.debug("importPEMFile(" + fileName + ")");
        FileInputStream fileInputStream = new FileInputStream(fileName);
        this.importPEMFile(fileInputStream);
        fileInputStream.close();
    }

    public void importPEMFile(InputStream inputStream) throws IOException, SSLFTPCertificateException {
        byte[] byArray;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((byArray = WrappedObject.loadObject(bufferedReader, "CERTIFICATE", null)) != null) {
            SSLDebug.debug(16, "Loading root", byArray);
            try {
                X509Cert x509Cert = new X509Cert(byArray);
                this.b.add(new SSLFTPCertificate(x509Cert));
            }
            catch (CertificateDecodeException certificateDecodeException) {
                a.warn("Failed to decode certificate: " + certificateDecodeException.getMessage());
            }
        }
        this.a();
    }

    public void exportPEMFile(String fileName) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(fileName);
        this.exportPEMFile(fileOutputStream);
        fileOutputStream.close();
    }

    public void exportPEMFile(OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        for (SSLFTPCertificate sSLFTPCertificate : this) {
            bufferedWriter.write(sSLFTPCertificate.toString(true) + "\n");
            WrappedObject.writeHeader("CERTIFICATE", bufferedWriter);
            WrappedObject.writeObject(sSLFTPCertificate.getCertDER(), "CERTIFICATE", bufferedWriter);
            bufferedWriter.write("\n");
        }
        bufferedWriter.close();
    }

    public void importKeyStore(KeyStore keyStore) throws KeyStoreException, SSLFTPCertificateException {
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate certificate = keyStore.getCertificate(enumeration.nextElement());
            try {
                this.add(new SSLFTPCertificate(certificate));
            }
            catch (Exception exception) {
                a.warn("Failed to load certificate from store: " + exception.getMessage());
            }
        }
    }

    public void importKeyStore(String keystoreFile, String password) throws KeyStoreException, IOException, SSLFTPCertificateException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] cArray = password != null ? password.toCharArray() : null;
        try (FileInputStream fileInputStream = new FileInputStream(keystoreFile);){
            keyStore.load(fileInputStream, cArray);
            this.importKeyStore(keyStore);
        }
    }

    public void importKeyStore(String keystoreFile) throws KeyStoreException, IOException, SSLFTPCertificateException {
        this.importKeyStore(keystoreFile, null);
    }

    public void exportKeyStore(KeyStore keyStore) throws CertificateException, KeyStoreException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        for (SSLFTPCertificate sSLFTPCertificate : this) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                sSLFTPCertificate.writePEM(byteArrayOutputStream);
                byteArrayOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                Certificate certificate = certificateFactory.generateCertificate(byteArrayInputStream);
                String string = sSLFTPCertificate.getSubjectName().getCommonName();
                if (string == null) {
                    string = sSLFTPCertificate.getSubjectName().getOrganisationName();
                }
                keyStore.setCertificateEntry(string, certificate);
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {
                a.error("Error while exporting to KeyStore", iOException);
            }
        }
    }

    public void importDefaultKeyStore() throws KeyStoreException, IOException, SSLFTPException {
        String string = System.getProperty("javax.net.ssl.trustStore");
        if (string != null) {
            String string2 = System.getProperty("javax.net.ssl.trustStorePassword");
            this.importKeyStore(string, string2);
        } else {
            File file = new File(System.getProperty("java.home") + "/lib/security/jssecacerts");
            if (file.exists()) {
                this.importKeyStore(file.getPath());
            } else {
                this.importKeyStore(System.getProperty("java.home") + "/lib/security/cacerts");
            }
        }
    }

    private void a(Object object) {
        if (!(object instanceof SSLFTPCertificate)) {
            throw new ArrayStoreException("Cannot add an instance of " + object.getClass().toString() + " to a " + SSLFTPCertificateStore.class.toString() + " - must be " + SSLFTPCertificate.class.toString());
        }
    }

    public void add(int index, Object certificate) {
        this.a(certificate);
        this.b.add(index, certificate);
        this.a();
    }

    @Override
    public boolean add(Object certificate) {
        this.a(certificate);
        this.b.add(certificate);
        this.a();
        return true;
    }

    @Override
    public boolean addAll(Collection certificates) {
        Iterator iterator = certificates.iterator();
        while (iterator.hasNext()) {
            this.a(iterator.next());
        }
        this.b.addAll(certificates);
        this.a();
        return true;
    }

    public boolean addAll(int index, Collection certificates) {
        Iterator iterator = certificates.iterator();
        while (iterator.hasNext()) {
            this.a(iterator.next());
        }
        this.b.addAll(index, certificates);
        this.a();
        return true;
    }

    @Override
    public void clear() {
        this.b.clear();
        this.a();
    }

    @Override
    public boolean contains(Object certificate) {
        this.a(certificate);
        SSLFTPCertificate sSLFTPCertificate = (SSLFTPCertificate)certificate;
        for (SSLFTPCertificate sSLFTPCertificate2 : this) {
            if (!sSLFTPCertificate2.equals(sSLFTPCertificate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection certificates) {
        Iterator iterator = certificates.iterator();
        while (iterator.hasNext()) {
            if (this.contains((SSLFTPCertificate)iterator.next())) continue;
            return false;
        }
        return true;
    }

    public Object get(int index) {
        return this.b.get(index);
    }

    public SSLFTPCertificate getCertificate(int index) {
        return (SSLFTPCertificate)this.b.get(index);
    }

    @Override
    public int indexOf(Object certificate) {
        return this.b.indexOf(certificate);
    }

    @Override
    public int lastIndexOf(Object certificate) {
        return this.b.lastIndexOf(certificate);
    }

    @Override
    public boolean isEmpty() {
        return this.b.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return this.b.iterator();
    }

    public ListIterator listIterator() {
        return this.b.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.b.listIterator(index);
    }

    public Object remove(int index) {
        Object e2 = this.b.remove(index);
        if (e2 != null) {
            this.a();
        }
        return e2;
    }

    public SSLFTPCertificate removeCertificate(int index) {
        SSLFTPCertificate sSLFTPCertificate = (SSLFTPCertificate)this.b.remove(index);
        if (sSLFTPCertificate != null) {
            this.a();
        }
        return sSLFTPCertificate;
    }

    @Override
    public boolean remove(Object certificate) {
        if (this.b.remove(certificate)) {
            this.a();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection certificates) {
        if (this.b.removeAll(certificates)) {
            this.a();
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection certificates) {
        if (this.b.retainAll(certificates)) {
            this.a();
            return true;
        }
        return false;
    }

    public Object set(int index, Object certificate) {
        this.a(certificate);
        Object object = this.b.set(index, certificate);
        if (object != null) {
            this.a();
        }
        return object;
    }

    @Override
    public int size() {
        return this.b.size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.b.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.b.toArray();
    }

    @Override
    public Object[] toArray(Object[] certificates) {
        return this.b.toArray(certificates);
    }

    public SSLFTPCertificate[] toCertificateArray() {
        SSLFTPCertificate[] sSLFTPCertificateArray = new SSLFTPCertificate[this.size()];
        for (int i2 = 0; i2 < this.size(); ++i2) {
            sSLFTPCertificateArray[i2] = this.getCertificate(i2);
        }
        return sSLFTPCertificateArray;
    }

    void a(a a2) {
        this.c = a2;
    }

    void a() {
        if (this.c != null) {
            this.c.a(this);
        }
    }

    Vector b() {
        Vector<X509Cert> vector = new Vector<X509Cert>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            vector.add(((SSLFTPCertificate)iterator.next()).a());
        }
        return vector;
    }

    static interface a {
        public void a(SSLFTPCertificateStore var1);
    }
}

