/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssl;

import com.enterprisedt.net.ftp.ssl.SSLFTPCertificate;
import com.enterprisedt.net.ftp.ssl.SSLFTPCertificateStore;
import com.enterprisedt.net.ftp.ssl.SSLFTPException;
import com.enterprisedt.net.ftp.ssl.SSLFTPValidator;
import com.enterprisedt.util.debug.Logger;
import java.util.Date;
import java.util.Vector;

public class SSLFTPStandardValidator
implements SSLFTPValidator {
    private static Logger a = Logger.getLogger("SSLFTPStandardValidator");
    private static String b = "*.";
    public static int MAX_CERTIFICATE_CHAIN_LENGTH = 4;
    protected boolean hostNameCheckingEnabled = true;
    protected String[] serverCommonNames = null;
    protected SSLFTPCertificateStore rootCertificateStore;

    public SSLFTPStandardValidator() {
    }

    public SSLFTPStandardValidator(String serverCommonName) {
        this.serverCommonNames = new String[1];
        this.serverCommonNames[0] = serverCommonName;
    }

    public SSLFTPStandardValidator(String[] serverCommonNames) {
        this.serverCommonNames = serverCommonNames;
    }

    public SSLFTPStandardValidator(boolean checkHostNames) {
        this.hostNameCheckingEnabled = checkHostNames;
    }

    void a(SSLFTPCertificateStore sSLFTPCertificateStore) {
        this.rootCertificateStore = sSLFTPCertificateStore;
    }

    protected boolean checkChainLength(int chainLength) {
        return chainLength <= MAX_CERTIFICATE_CHAIN_LENGTH;
    }

    protected boolean checkCommonName(String certCommonName, String serverHostName) {
        if (!this.hostNameCheckingEnabled) {
            a.debug("Ignoring common name check (disabled)");
            return true;
        }
        if (this.serverCommonNames == null) {
            return this.a(certCommonName, serverHostName);
        }
        for (int i2 = 0; i2 < this.serverCommonNames.length; ++i2) {
            if (!this.a(certCommonName, this.serverCommonNames[i2])) continue;
            return true;
        }
        a.debug("Common names supplied explicitly - CN was not checked against '" + serverHostName + "'");
        return false;
    }

    private boolean a(String string, String string2) {
        if (!string.startsWith(b)) {
            return string.toLowerCase().equals(string2.toLowerCase());
        }
        string = string.substring(b.length());
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        boolean bl = true;
        int n2 = stringArray.length - 1;
        for (int i2 = stringArray2.length - 1; n2 >= 0 && i2 >= 0; --n2, --i2) {
            if (stringArray[n2].toLowerCase().equals(stringArray2[i2].toLowerCase())) continue;
            bl = false;
            break;
        }
        return bl && n2 < 0;
    }

    protected boolean checkDateRange(Date validFrom, Date validUntil) {
        Date date = new Date();
        return !date.before(validFrom) && !date.after(validUntil);
    }

    @Override
    public boolean validateServerCertificate(boolean recommendValidate, Vector certificateChain, String serverHostName) throws SSLFTPException {
        if (!recommendValidate) {
            return false;
        }
        if (!this.checkChainLength(certificateChain.size())) {
            throw new SSLFTPException("The server's certificate chain is too long");
        }
        SSLFTPCertificate sSLFTPCertificate = (SSLFTPCertificate)certificateChain.lastElement();
        String string = sSLFTPCertificate.getSubjectName().getCommonName();
        if (!this.checkCommonName(string, serverHostName)) {
            throw new SSLFTPException("The CN (Common Name), " + string + ", on the server's certificate does not match its hostname, " + serverHostName + ".");
        }
        if (!this.checkDateRange(sSLFTPCertificate.getValidityNotBefore(), sSLFTPCertificate.getValidityNotAfter())) {
            throw new SSLFTPException("The server's certificate is not currently valid.  It is valid from " + sSLFTPCertificate.getValidityNotBefore() + " until " + sSLFTPCertificate.getValidityNotAfter() + ".  This computer indicates the current date/time is " + new Date().toString() + ".");
        }
        return true;
    }
}

