/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.authentication;

import com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolClient;
import com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolException;
import com.enterprisedt.net.j2ssh.authentication.SshAuthenticationClient;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthRequest;
import com.enterprisedt.net.j2ssh.authentication.TerminatedStateException;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;

public class HostbasedAuthenticationClient
extends SshAuthenticationClient {
    private static Logger a = Logger.getLogger(HostbasedAuthenticationClient.class);
    protected SshPrivateKey key;
    private String b = null;
    private String c = null;

    public void setKey(SshPrivateKey key) {
        this.key = key;
    }

    @Override
    public void reset() {
        this.b = null;
        this.c = null;
    }

    public void setClientUsername(String clientUser) {
        this.c = clientUser;
    }

    @Override
    public String getMethodName() {
        return "hostbased";
    }

    @Override
    public void authenticate(AuthenticationProtocolClient authentication, String serviceToStart) throws IOException, TerminatedStateException {
        if (this.getUsername() == null || this.key == null) {
            throw new AuthenticationProtocolException("You must supply a username and a key");
        }
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        a.debug("Generating data to sign");
        SshPublicKey sshPublicKey = this.key.getPublicKey();
        InetAddress inetAddress = InetAddress.getLocalHost();
        String string = inetAddress.getHostName();
        a.debug("Preparing hostbased authentication request for " + string);
        byteArrayWriter.writeString(sshPublicKey.getKeyAlgorithmName());
        byteArrayWriter.writeBinaryString(sshPublicKey.getEncoded());
        byteArrayWriter.writeString(string);
        if (this.c != null) {
            byteArrayWriter.writeString(this.c);
        } else {
            byteArrayWriter.writeString(this.getUsername());
        }
        ByteArrayWriter byteArrayWriter2 = new ByteArrayWriter();
        byteArrayWriter2.writeBinaryString(authentication.getSessionIdentifier());
        byteArrayWriter2.write(50);
        byteArrayWriter2.writeString(this.getUsername());
        byteArrayWriter2.writeString(serviceToStart);
        byteArrayWriter2.writeString(this.getMethodName());
        byteArrayWriter2.writeString(sshPublicKey.getKeyAlgorithmName());
        byteArrayWriter2.writeBinaryString(sshPublicKey.getEncoded());
        byteArrayWriter2.writeString(string);
        if (this.c != null) {
            byteArrayWriter2.writeString(this.c);
        } else {
            byteArrayWriter2.writeString(this.getUsername());
        }
        byteArrayWriter.writeBinaryString(this.key.generateSignature(byteArrayWriter2.toByteArray()));
        SshMsgUserAuthRequest sshMsgUserAuthRequest = new SshMsgUserAuthRequest(this.getUsername(), serviceToStart, this.getMethodName(), byteArrayWriter.toByteArray());
        authentication.sendMessage(sshMsgUserAuthRequest);
    }

    @Override
    public Properties getPersistableProperties() {
        Properties properties = new Properties();
        if (this.getUsername() != null) {
            properties.setProperty("Username", this.getUsername());
        }
        if (this.b != null) {
            properties.setProperty("PrivateKey", this.b);
        }
        return properties;
    }

    @Override
    public void setPersistableProperties(Properties properties) {
        this.setUsername(properties.getProperty("Username"));
        if (properties.getProperty("PrivateKey") != null) {
            this.b = properties.getProperty("PrivateKey");
        }
    }

    @Override
    public boolean canAuthenticate() {
        return this.getUsername() != null && this.key != null;
    }
}

