/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.authentication;

import com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolClient;
import com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolException;
import com.enterprisedt.net.j2ssh.authentication.PasswordChangePrompt;
import com.enterprisedt.net.j2ssh.authentication.SshAuthenticationClient;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthPwdChangeReq;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthRequest;
import com.enterprisedt.net.j2ssh.authentication.TerminatedStateException;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.util.Properties;

public class PasswordAuthenticationClient
extends SshAuthenticationClient {
    private static Logger a = Logger.getLogger("PasswordAuthenticationClient");
    private PasswordChangePrompt b = null;
    protected String password = null;
    protected String newPassword = null;

    @Override
    public final String getMethodName() {
        return "password";
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    @Override
    public void reset() {
        this.password = null;
        this.newPassword = null;
    }

    public void setPasswordChangePrompt(PasswordChangePrompt changePrompt) {
        this.b = changePrompt;
    }

    @Override
    public void authenticate(AuthenticationProtocolClient authentication, String serviceToStart) throws IOException, TerminatedStateException {
        if (this.getUsername() == null || this.password == null) {
            throw new AuthenticationProtocolException("Username and password cannot be null!");
        }
        authentication.registerMessage(SshMsgUserAuthPwdChangeReq.class, 60);
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        if (this.newPassword == null) {
            byteArrayWriter.write(0);
        } else {
            byteArrayWriter.write(1);
        }
        byteArrayWriter.writeString(this.password);
        if (this.newPassword != null) {
            byteArrayWriter.writeString(this.newPassword);
        }
        SshMsgUserAuthRequest sshMsgUserAuthRequest = new SshMsgUserAuthRequest(this.getUsername(), serviceToStart, "password", byteArrayWriter.toByteArray());
        authentication.sendMessage(sshMsgUserAuthRequest);
        SshMsgUserAuthPwdChangeReq sshMsgUserAuthPwdChangeReq = (SshMsgUserAuthPwdChangeReq)authentication.readMessage(60);
        if (this.b != null) {
            int n2 = this.b.getMaxChangeAttempts();
            for (int i2 = 0; i2 < n2; ++i2) {
                a.debug("Password change attempt #" + i2);
                String string = this.b.getNewPassword(sshMsgUserAuthPwdChangeReq.getPrompt());
                if (string == null) {
                    throw new TerminatedStateException(2);
                }
                a.debug("Setting new password");
                byteArrayWriter = new ByteArrayWriter();
                byteArrayWriter.write(1);
                byteArrayWriter.writeString(this.password);
                byteArrayWriter.writeString(string);
                sshMsgUserAuthRequest = new SshMsgUserAuthRequest(this.getUsername(), serviceToStart, "password", byteArrayWriter.toByteArray());
                authentication.sendMessage(sshMsgUserAuthRequest);
                sshMsgUserAuthPwdChangeReq = (SshMsgUserAuthPwdChangeReq)authentication.readMessage(60);
            }
        } else {
            throw new TerminatedStateException(2);
        }
    }

    @Override
    public Properties getPersistableProperties() {
        Properties properties = new Properties();
        if (this.getUsername() != null) {
            properties.setProperty("Username", this.getUsername());
        }
        return properties;
    }

    @Override
    public void setPersistableProperties(Properties properties) {
        this.setUsername(properties.getProperty("Username"));
        if (properties.getProperty("Password") != null) {
            this.setPassword(properties.getProperty("Password"));
        }
    }

    @Override
    public boolean canAuthenticate() {
        return this.getUsername() != null && this.password != null;
    }
}

