/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.connection;

import com.enterprisedt.net.j2ssh.SshException;
import com.enterprisedt.net.j2ssh.connection.Channel;
import com.enterprisedt.net.j2ssh.connection.ChannelDataWindow;
import com.enterprisedt.net.j2ssh.connection.ChannelEventListener;
import com.enterprisedt.net.j2ssh.connection.ChannelFactory;
import com.enterprisedt.net.j2ssh.connection.GlobalRequestHandler;
import com.enterprisedt.net.j2ssh.connection.GlobalRequestResponse;
import com.enterprisedt.net.j2ssh.connection.InvalidChannelException;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelClose;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelData;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelEOF;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelExtendedData;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelFailure;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelOpen;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelOpenConfirmation;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelOpenFailure;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelRequest;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelSuccess;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelWindowAdjust;
import com.enterprisedt.net.j2ssh.connection.SshMsgGlobalRequest;
import com.enterprisedt.net.j2ssh.connection.SshMsgRequestFailure;
import com.enterprisedt.net.j2ssh.connection.SshMsgRequestSuccess;
import com.enterprisedt.net.j2ssh.transport.AsyncService;
import com.enterprisedt.net.j2ssh.transport.MessageNotAvailableException;
import com.enterprisedt.net.j2ssh.transport.MessageStoreEOFException;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ConnectionProtocol
extends AsyncService {
    private static Logger a = Logger.getLogger("ConnectionProtocol");
    private HashSet b = new HashSet();
    private Map c = new HashMap();
    private Map d = new HashMap();
    private Map e = new HashMap();
    private static long f = 0L;

    public ConnectionProtocol() {
        super("ssh-connection");
    }

    public void addChannelFactory(String channelName, ChannelFactory cf) throws IOException {
        this.d.put(channelName, cf);
    }

    public void removeChannelFactory(String channelName) {
        this.d.remove(channelName);
    }

    public boolean containsChannelFactory(String channelName) {
        return this.d.containsKey(channelName);
    }

    public void allowGlobalRequest(String requestName, GlobalRequestHandler handler) {
        this.e.put(requestName, handler);
    }

    public synchronized boolean openChannel(Channel channel) throws IOException {
        return this.openChannel(channel, null);
    }

    public boolean isConnected() {
        return this.transport != null && (this.transport.getState().getValue() == 4 || this.transport.getState().getValue() == 3) && this.getState().getValue() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long a() {
        Map map = this.c;
        synchronized (map) {
            if (this.b.size() <= 0) {
                return new Long(f++);
            }
            return (Long)this.b.iterator().next();
        }
    }

    public synchronized boolean openChannel(Channel channel, ChannelEventListener eventListener) throws IOException {
        Map map = this.c;
        synchronized (map) {
            Long l2 = this.a();
            SshMsgChannelOpen sshMsgChannelOpen = new SshMsgChannelOpen(channel.getChannelType(), l2, channel.getLocalWindow().getWindowSpace(), channel.getLocalPacketSize(), channel.getChannelOpenData());
            this.transport.sendMessage(sshMsgChannelOpen, this);
            int[] nArray = new int[]{91, 92};
            try {
                SshMessage sshMessage = this.messageStore.getMessage(nArray, this.timeout);
                if (sshMessage.getMessageId() == 91) {
                    SshMsgChannelOpenConfirmation sshMsgChannelOpenConfirmation = (SshMsgChannelOpenConfirmation)sshMessage;
                    this.c.put(l2, channel);
                    a.debug("Initiating channel");
                    channel.init(this, l2, sshMsgChannelOpenConfirmation.getSenderChannel(), sshMsgChannelOpenConfirmation.getInitialWindowSize(), sshMsgChannelOpenConfirmation.getMaximumPacketSize(), this.timeout, eventListener);
                    channel.open();
                    a.debug("Channel " + String.valueOf(channel.getLocalChannelId()) + " is open [" + channel.getName() + "]");
                    return true;
                }
                a.debug("Failed to open channel " + String.valueOf(channel.getLocalChannelId()) + " : " + sshMessage.toString());
                channel.getState().setValue(3);
                return false;
            }
            catch (MessageStoreEOFException messageStoreEOFException) {
                throw new IOException(messageStoreEOFException.getMessage());
            }
            catch (MessageNotAvailableException messageNotAvailableException) {
                throw new IOException(messageNotAvailableException.getMessage());
            }
            catch (InterruptedException interruptedException) {
                throw new SshException("The thread was interrupted whilst waiting for a connection protocol message", interruptedException);
            }
        }
    }

    @Override
    protected void onStop() {
        a.debug("Closing all active channels");
        try {
            for (Channel channel : this.c.values()) {
                if (channel == null) continue;
                if (a.isDebugEnabled()) {
                    a.debug("Closing " + channel.getName() + " id=" + String.valueOf(channel.getLocalChannelId()));
                }
                channel.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.c.clear();
    }

    public synchronized void sendChannelData(Channel channel, byte[] data) throws IOException {
        int n2 = 0;
        ChannelDataWindow channelDataWindow = channel.getRemoteWindow();
        long l2 = Math.min(channel.getLocalPacketSize(), channel.getRemotePacketSize());
        if (a.isDebugEnabled()) {
            a.debug("Sending " + String.valueOf(data.length) + " bytes for channel id " + String.valueOf(channel.getLocalChannelId()) + " (maxSize=" + String.valueOf(l2) + ")");
        }
        while (n2 < data.length) {
            int n3 = data.length - n2;
            long l3 = channelDataWindow.getWindowSpace() < l2 && channelDataWindow.getWindowSpace() > 0L ? channelDataWindow.getWindowSpace() : l2;
            int n4 = l3 < (long)n3 ? (int)l3 : n3;
            channelDataWindow.consumeWindowSpace(n4);
            byte[] byArray = new byte[n4];
            System.arraycopy(data, n2, byArray, 0, n4);
            SshMsgChannelData sshMsgChannelData = new SshMsgChannelData(channel.getRemoteChannelId(), byArray);
            this.transport.sendMessage(sshMsgChannelData, this);
            n2 += n4;
            if (!a.isDebugEnabled()) continue;
            a.debug("Sent " + String.valueOf(n4) + " bytes (" + String.valueOf(n2) + " total) for channel id " + String.valueOf(channel.getLocalChannelId()));
        }
        if (a.isDebugEnabled()) {
            a.debug("Sent total bytes " + String.valueOf(n2) + " for channel id " + String.valueOf(channel.getLocalChannelId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendChannelEOF(Channel channel) throws IOException {
        Map map = this.c;
        synchronized (map) {
            if (!this.c.containsValue(channel)) {
                throw new IOException("Attempt to send EOF for a non existent channel " + String.valueOf(channel.getLocalChannelId()));
            }
            a.debug("Local computer has set channel " + String.valueOf(channel.getLocalChannelId()) + " to EOF [" + channel.getName() + "]");
            SshMsgChannelEOF sshMsgChannelEOF = new SshMsgChannelEOF(channel.getRemoteChannelId());
            this.transport.sendMessage(sshMsgChannelEOF, this);
        }
    }

    public synchronized void sendChannelExtData(Channel channel, int extendedType, byte[] data) throws IOException {
        int n2 = 0;
        ChannelDataWindow channelDataWindow = channel.getRemoteWindow();
        long l2 = Math.min(channel.getLocalPacketSize(), channel.getRemotePacketSize());
        if (a.isDebugEnabled()) {
            a.debug("Sending ext " + String.valueOf(data.length) + " bytes for channel id " + String.valueOf(channel.getLocalChannelId()) + " (maxSize=" + String.valueOf(l2) + ")");
        }
        while (n2 < data.length) {
            int n3 = data.length - n2;
            long l3 = channelDataWindow.getWindowSpace() < l2 && channelDataWindow.getWindowSpace() > 0L ? channelDataWindow.getWindowSpace() : l2;
            int n4 = l3 < (long)n3 ? (int)l3 : n3;
            channelDataWindow.consumeWindowSpace(n4);
            byte[] byArray = new byte[n4];
            System.arraycopy(data, n2, byArray, 0, n4);
            SshMsgChannelExtendedData sshMsgChannelExtendedData = new SshMsgChannelExtendedData(channel.getRemoteChannelId(), extendedType, byArray);
            this.transport.sendMessage(sshMsgChannelExtendedData, this);
            n2 += n4;
            if (!a.isDebugEnabled()) continue;
            a.debug("Sent ext " + String.valueOf(n4) + " bytes (" + String.valueOf(n2) + " total) for channel id " + String.valueOf(channel.getLocalChannelId()));
        }
        if (a.isDebugEnabled()) {
            a.debug("Sent total bytes " + String.valueOf(n2) + " for channel id " + String.valueOf(channel.getLocalChannelId()));
        }
    }

    public synchronized boolean sendChannelRequest(Channel channel, String requestType, boolean wantReply, byte[] requestData) throws IOException {
        boolean bl = true;
        a.debug("Sending " + requestType + " request for the " + channel.getChannelType() + " channel");
        SshMsgChannelRequest sshMsgChannelRequest = new SshMsgChannelRequest(channel.getRemoteChannelId(), requestType, wantReply, requestData);
        this.transport.sendMessage(sshMsgChannelRequest, this);
        if (wantReply) {
            int[] nArray = new int[]{99, 100};
            a.debug("Waiting for channel request reply");
            try {
                SshMessage sshMessage = this.messageStore.getMessage(nArray, this.timeout);
                switch (sshMessage.getMessageId()) {
                    case 99: {
                        a.debug("Channel request succeeded");
                        bl = true;
                        break;
                    }
                    case 100: {
                        a.debug("Channel request failed");
                        bl = false;
                    }
                }
            }
            catch (MessageNotAvailableException messageNotAvailableException) {
                throw new IOException(messageNotAvailableException.getMessage());
            }
            catch (InterruptedException interruptedException) {
                throw new SshException("The thread was interrupted whilst waiting for a connection protocol message", interruptedException);
            }
        }
        return bl;
    }

    public void sendChannelRequestFailure(Channel channel) throws IOException {
        SshMsgChannelFailure sshMsgChannelFailure = new SshMsgChannelFailure(channel.getRemoteChannelId());
        this.transport.sendMessage(sshMsgChannelFailure, this);
    }

    public void sendChannelRequestSuccess(Channel channel) throws IOException {
        SshMsgChannelSuccess sshMsgChannelSuccess = new SshMsgChannelSuccess(channel.getRemoteChannelId());
        this.transport.sendMessage(sshMsgChannelSuccess, this);
    }

    public void sendChannelWindowAdjust(Channel channel, long bytesToAdd) throws IOException {
        a.debug("Increasing window size by " + String.valueOf(bytesToAdd) + " bytes");
        SshMsgChannelWindowAdjust sshMsgChannelWindowAdjust = new SshMsgChannelWindowAdjust(channel.getRemoteChannelId(), bytesToAdd);
        this.transport.sendMessage(sshMsgChannelWindowAdjust, this);
    }

    public synchronized byte[] sendGlobalRequest(String requestName, boolean wantReply, byte[] requestData) throws IOException {
        SshMsgGlobalRequest sshMsgGlobalRequest = new SshMsgGlobalRequest(requestName, true, requestData);
        this.transport.sendMessage(sshMsgGlobalRequest, this);
        if (wantReply) {
            int[] nArray = new int[]{81, 82};
            a.debug("Waiting for global request reply");
            try {
                SshMessage sshMessage = this.messageStore.getMessage(nArray, this.timeout);
                switch (sshMessage.getMessageId()) {
                    case 81: {
                        a.debug("Global request succeeded");
                        return ((SshMsgRequestSuccess)sshMessage).getRequestData();
                    }
                    case 82: {
                        a.debug("Global request failed");
                        throw new SshException("The request failed");
                    }
                }
            }
            catch (MessageNotAvailableException messageNotAvailableException) {
                throw new IOException(messageNotAvailableException.getMessage());
            }
            catch (InterruptedException interruptedException) {
                throw new SshException("The thread was interrupted whilst waiting for a connection protocol message", interruptedException);
            }
        }
        return null;
    }

    @Override
    protected int[] getAsyncMessageFilter() {
        int[] nArray = new int[]{93, 80, 90, 97, 96, 95, 94, 98};
        return nArray;
    }

    protected void closeChannel(Channel channel) throws IOException {
        SshMsgChannelClose sshMsgChannelClose = new SshMsgChannelClose(channel.getRemoteChannelId());
        a.debug("Local computer has closed channel " + String.valueOf(channel.getLocalChannelId()) + "[" + channel.getName() + "]");
        this.transport.sendMessage(sshMsgChannelClose, this);
    }

    protected void onGlobalRequest(String requestName, boolean wantReply, byte[] requestData) throws IOException {
        a.debug("Processing " + requestName + " global request");
        if (!this.e.containsKey(requestName)) {
            this.sendGlobalRequestFailure();
        } else {
            GlobalRequestHandler globalRequestHandler = (GlobalRequestHandler)this.e.get(requestName);
            GlobalRequestResponse globalRequestResponse = globalRequestHandler.processGlobalRequest(requestName, requestData);
            if (wantReply) {
                if (globalRequestResponse.hasSucceeded()) {
                    this.sendGlobalRequestSuccess(globalRequestResponse.getResponseData());
                } else {
                    this.sendGlobalRequestFailure();
                }
            }
        }
    }

    @Override
    protected void onMessageReceived(SshMessage msg) throws IOException {
        switch (msg.getMessageId()) {
            case 80: {
                this.a((SshMsgGlobalRequest)msg);
                break;
            }
            case 90: {
                this.a((SshMsgChannelOpen)msg);
                break;
            }
            case 97: {
                this.a((SshMsgChannelClose)msg);
                break;
            }
            case 96: {
                this.a((SshMsgChannelEOF)msg);
                break;
            }
            case 94: {
                this.a((SshMsgChannelData)msg);
                break;
            }
            case 95: {
                this.a((SshMsgChannelExtendedData)msg);
                break;
            }
            case 98: {
                this.a((SshMsgChannelRequest)msg);
                break;
            }
            case 93: {
                this.a((SshMsgChannelWindowAdjust)msg);
                break;
            }
            default: {
                a.debug("Message not handled");
                throw new IOException("Unregistered message received!");
            }
        }
    }

    @Override
    protected void onServiceAccept() {
    }

    @Override
    protected void onServiceInit(int startMode) throws IOException {
        a.debug("Registering connection protocol messages");
        this.messageStore.registerMessage(91, SshMsgChannelOpenConfirmation.class);
        this.messageStore.registerMessage(92, SshMsgChannelOpenFailure.class);
        this.messageStore.registerMessage(90, SshMsgChannelOpen.class);
        this.messageStore.registerMessage(97, SshMsgChannelClose.class);
        this.messageStore.registerMessage(96, SshMsgChannelEOF.class);
        this.messageStore.registerMessage(94, SshMsgChannelData.class);
        this.messageStore.registerMessage(95, SshMsgChannelExtendedData.class);
        this.messageStore.registerMessage(100, SshMsgChannelFailure.class);
        this.messageStore.registerMessage(98, SshMsgChannelRequest.class);
        this.messageStore.registerMessage(99, SshMsgChannelSuccess.class);
        this.messageStore.registerMessage(93, SshMsgChannelWindowAdjust.class);
        this.messageStore.registerMessage(80, SshMsgGlobalRequest.class);
        this.messageStore.registerMessage(82, SshMsgRequestFailure.class);
        this.messageStore.registerMessage(81, SshMsgRequestSuccess.class);
    }

    @Override
    protected void onServiceRequest() {
    }

    protected void sendChannelFailure(Channel channel) throws IOException {
        SshMsgChannelFailure sshMsgChannelFailure = new SshMsgChannelFailure(channel.getRemoteChannelId());
        this.transport.sendMessage(sshMsgChannelFailure, this);
    }

    protected void sendChannelOpenConfirmation(Channel channel) throws IOException {
        SshMsgChannelOpenConfirmation sshMsgChannelOpenConfirmation = new SshMsgChannelOpenConfirmation(channel.getRemoteChannelId(), channel.getLocalChannelId(), channel.getLocalWindow().getWindowSpace(), channel.getLocalPacketSize(), channel.getChannelConfirmationData());
        this.transport.sendMessage(sshMsgChannelOpenConfirmation, this);
    }

    protected void sendChannelOpenFailure(long remoteChannelId, long reasonCode, String additionalInfo, String languageTag) throws IOException {
        SshMsgChannelOpenFailure sshMsgChannelOpenFailure = new SshMsgChannelOpenFailure(remoteChannelId, reasonCode, additionalInfo, languageTag);
        this.transport.sendMessage(sshMsgChannelOpenFailure, this);
    }

    protected void sendGlobalRequestFailure() throws IOException {
        SshMsgRequestFailure sshMsgRequestFailure = new SshMsgRequestFailure();
        this.transport.sendMessage(sshMsgRequestFailure, this);
    }

    protected void sendGlobalRequestSuccess(byte[] requestData) throws IOException {
        SshMsgRequestSuccess sshMsgRequestSuccess = new SshMsgRequestSuccess(requestData);
        this.transport.sendMessage(sshMsgRequestSuccess, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel a(long l2) throws IOException {
        Map map = this.c;
        synchronized (map) {
            Long l3 = new Long(l2);
            if (!this.c.containsKey(l3)) {
                throw new IOException("Non existent channel " + l3.toString() + " requested");
            }
            return (Channel)this.c.get(l3);
        }
    }

    private void a(SshMsgChannelClose sshMsgChannelClose) throws IOException {
        Channel channel = this.a(sshMsgChannelClose.getRecipientChannel());
        if (channel == null) {
            throw new IOException("Remote computer tried to close a non existent channel " + String.valueOf(sshMsgChannelClose.getRecipientChannel()));
        }
        a.debug("Remote computer has closed channel " + String.valueOf(channel.getLocalChannelId()) + "[" + channel.getName() + "]");
        if (channel.getState().getValue() != 3) {
            channel.remoteClose();
        }
    }

    private void a(SshMsgChannelData sshMsgChannelData) throws IOException {
        if (a.isDebugEnabled()) {
            a.debug("Received " + String.valueOf(sshMsgChannelData.getChannelData().length) + " bytes of data for channel id " + String.valueOf(sshMsgChannelData.getRecipientChannel()));
        }
        Channel channel = this.a(sshMsgChannelData.getRecipientChannel());
        channel.processChannelData(sshMsgChannelData);
    }

    private void a(SshMsgChannelEOF sshMsgChannelEOF) throws IOException {
        Channel channel = this.a(sshMsgChannelEOF.getRecipientChannel());
        try {
            a.debug("Remote computer has set channel " + String.valueOf(sshMsgChannelEOF.getRecipientChannel()) + " to EOF [" + channel.getName() + "]");
            channel.setRemoteEOF();
        }
        catch (IOException iOException) {
            a.debug("Failed to close the ChannelInputStream after EOF event");
        }
    }

    private void a(SshMsgChannelExtendedData sshMsgChannelExtendedData) throws IOException {
        Channel channel = this.a(sshMsgChannelExtendedData.getRecipientChannel());
        if (channel == null) {
            throw new IOException("Remote computer sent data for non existent channel");
        }
        channel.processChannelData(sshMsgChannelExtendedData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(SshMsgChannelOpen sshMsgChannelOpen) throws IOException {
        Map map = this.c;
        synchronized (map) {
            a.debug("Request for " + sshMsgChannelOpen.getChannelType() + " channel recieved");
            ChannelFactory channelFactory = (ChannelFactory)this.d.get(sshMsgChannelOpen.getChannelType());
            if (channelFactory == null) {
                this.sendChannelOpenFailure(sshMsgChannelOpen.getSenderChannelId(), 2L, "The channel type is not supported", "");
                a.debug("Request for channel type " + sshMsgChannelOpen.getChannelType() + " refused");
                return;
            }
            try {
                a.debug("Creating channel " + sshMsgChannelOpen.getChannelType());
                Channel channel = channelFactory.createChannel(sshMsgChannelOpen.getChannelType(), sshMsgChannelOpen.getChannelData());
                a.debug("Initiating channel");
                Long l2 = this.a();
                channel.init(this, l2, sshMsgChannelOpen.getSenderChannelId(), sshMsgChannelOpen.getInitialWindowSize(), sshMsgChannelOpen.getMaximumPacketSize(), this.timeout);
                this.c.put(l2, channel);
                a.debug("Sending channel open confirmation");
                this.sendChannelOpenConfirmation(channel);
                channel.open();
            }
            catch (InvalidChannelException invalidChannelException) {
                this.sendChannelOpenFailure(sshMsgChannelOpen.getSenderChannelId(), 2L, invalidChannelException.getMessage(), "");
            }
        }
    }

    private void a(SshMsgChannelRequest sshMsgChannelRequest) throws IOException {
        Channel channel = this.a(sshMsgChannelRequest.getRecipientChannel());
        if (channel == null) {
            a.warn("Remote computer tried to make a request for a non existence channel!");
        }
        channel.onChannelRequest(sshMsgChannelRequest.getRequestType(), sshMsgChannelRequest.getWantReply(), sshMsgChannelRequest.getChannelData());
    }

    private void a(SshMsgChannelWindowAdjust sshMsgChannelWindowAdjust) throws IOException {
        Channel channel = this.a(sshMsgChannelWindowAdjust.getRecipientChannel());
        if (channel == null) {
            throw new IOException("Remote computer tried to increase window space for non existent channel " + String.valueOf(sshMsgChannelWindowAdjust.getRecipientChannel()));
        }
        channel.getRemoteWindow().increaseWindowSpace(sshMsgChannelWindowAdjust.getBytesToAdd());
        if (a.isDebugEnabled()) {
            a.debug(String.valueOf(sshMsgChannelWindowAdjust.getBytesToAdd()) + " bytes added to remote window");
            a.debug("Remote window space is " + String.valueOf(channel.getRemoteWindow().getWindowSpace()));
        }
    }

    private void a(SshMsgGlobalRequest sshMsgGlobalRequest) throws IOException {
        this.onGlobalRequest(sshMsgGlobalRequest.getRequestName(), sshMsgGlobalRequest.getWantReply(), sshMsgGlobalRequest.getRequestData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeChannel(Channel channel) {
        Map map = this.c;
        synchronized (map) {
            a.debug("Freeing channel " + String.valueOf(channel.getLocalChannelId()) + " [" + channel.getName() + "]");
            Long l2 = new Long(channel.getLocalChannelId());
            this.c.remove(l2);
        }
    }
}

