/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.openssh;

import com.enterprisedt.bouncycastle.asn1.ASN1BitString;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.nist.NISTNamedCurves;
import com.enterprisedt.bouncycastle.asn1.sec.ECPrivateKey;
import com.enterprisedt.bouncycastle.asn1.sec.SECObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECParameters;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.net.j2ssh.openssh.KeyInfo;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.util.SimpleASNReader;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.KeySpec;

public class ECDSAKeyInfo
implements KeyInfo {
    private BigInteger a;
    private X9ECParameters b;
    private ASN1ObjectIdentifier c;
    private ECPoint d;

    public ECDSAKeyInfo(X9ECParameters x9EC, ASN1ObjectIdentifier namedCurveOID, ECPoint QSPoint, BigInteger d2) {
        this.b = x9EC;
        this.c = namedCurveOID;
        this.d = QSPoint;
        this.a = d2;
    }

    public ECPoint getQSPoint() {
        return this.d;
    }

    public BigInteger getD() {
        return this.a;
    }

    @Override
    public KeySpec getPrivateKeySpec() {
        return null;
    }

    @Override
    public KeySpec getPublicKeySpec() {
        return null;
    }

    public String getAlgorithm() {
        if (this.c.getId().equals(SECObjectIdentifiers.secp256r1.getId())) {
            return SshKeyPairFactory.ECDSA_SHA2_NISTP256;
        }
        if (this.c.getId().equals(SECObjectIdentifiers.secp384r1.getId())) {
            return SshKeyPairFactory.ECDSA_SHA2_NISTP384;
        }
        if (this.c.getId().equals(SECObjectIdentifiers.secp521r1.getId())) {
            return SshKeyPairFactory.ECDSA_SHA2_NISTP521;
        }
        return null;
    }

    public String getCurveName() {
        if (this.c.getId().equals(SECObjectIdentifiers.secp256r1.getId())) {
            return "nistp256";
        }
        if (this.c.getId().equals(SECObjectIdentifiers.secp384r1.getId())) {
            return "nistp384";
        }
        if (this.c.getId().equals(SECObjectIdentifiers.secp521r1.getId())) {
            return "nistp521";
        }
        return null;
    }

    public static ECDSAKeyInfo getECDSAKeyInfo(SimpleASNReader asn) throws IOException {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(asn.getBytes());
        ECPrivateKey eCPrivateKey = ECPrivateKey.getInstance(aSN1Sequence);
        BigInteger bigInteger = eCPrivateKey.getKey();
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)eCPrivateKey.getParameters();
        X9ECParameters x9ECParameters = NISTNamedCurves.getByOID(aSN1ObjectIdentifier);
        ASN1BitString aSN1BitString = eCPrivateKey.getPublicKey();
        ECPoint eCPoint = x9ECParameters.getCurve().decodePoint(aSN1BitString.getBytes());
        return new ECDSAKeyInfo(x9ECParameters, aSN1ObjectIdentifier, eCPoint, bigInteger);
    }
}

