/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.openssh;

import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.openssh.BCrypt;
import com.enterprisedt.net.j2ssh.openssh.PEMReader;
import com.enterprisedt.net.j2ssh.transport.cipher.AES_CBC_256;
import com.enterprisedt.net.j2ssh.transport.cipher.AES_CTR_256;
import com.enterprisedt.net.j2ssh.transport.cipher.SshCipher;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKeyFile;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKeyFormat;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.transport.publickey.ecdsa.SshEcdsaNistpPublicKey;
import com.enterprisedt.net.puretls.LoadProviders;
import com.enterprisedt.util.debug.Logger;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;

public class OpenSSHNewPrivateKeyFormat
implements SshPrivateKeyFormat {
    private static Logger a = Logger.getLogger("OpenSSHNewPrivateKeyFormat");
    private BCrypt b = new BCrypt();

    @Override
    public String getFormatType() {
        return "OpenSSH-NewPrivateKey";
    }

    public String toString() {
        return this.getFormatType();
    }

    @Override
    public byte[] decryptKeyblob(byte[] formattedKey, String passphrase) throws InvalidSshKeyException {
        try {
            a.info("Unpacking OpenSSH new format private key");
            StringReader stringReader = new StringReader(new String(formattedKey, "US-ASCII"));
            PEMReader pEMReader = new PEMReader(stringReader);
            byte[] byArray = pEMReader.getPayload();
            if ("OPENSSH PRIVATE KEY".equals(pEMReader.getType())) {
                long l2;
                long l3;
                Object object;
                byte[] byArray2;
                a.info("New format OpenSSH private key");
                ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
                String string = this.a(byteArrayReader);
                String string2 = byteArrayReader.readString();
                ByteArrayReader byteArrayReader2 = new ByteArrayReader(byteArrayReader.readBinaryString());
                SshCipher sshCipher = null;
                if (!string2.equals("none")) {
                    if (!string2.equals("bcrypt")) {
                        throw new IOException("Unknown KDF " + string2);
                    }
                    byte[] byArray3 = byteArrayReader2.readBinaryString();
                    int n2 = (int)byteArrayReader2.readInt();
                    sshCipher = this.a(string);
                    byArray2 = new byte[this.c(string)];
                    object = new byte[this.b(string)];
                    byte[] byArray4 = new byte[byArray2.length + ((Object)object).length];
                    this.b.pbkdf(passphrase.getBytes("UTF-8"), byArray3, n2, byArray4);
                    System.arraycopy(byArray4, 0, object, 0, ((Object)object).length);
                    System.arraycopy(byArray4, ((Object)object).length, byArray2, 0, byArray2.length);
                    sshCipher.init(1, byArray2, (byte[])object);
                }
                int n3 = (int)byteArrayReader.readInt();
                byte[] byArray5 = byteArrayReader.readBinaryString();
                byArray2 = byteArrayReader.readBinaryString();
                if (sshCipher != null) {
                    byArray2 = sshCipher.transform(byArray2);
                }
                if ((l3 = ((ByteArrayReader)(object = new ByteArrayReader(byArray2))).readInt()) != (l2 = ((ByteArrayReader)object).readInt())) {
                    throw new InvalidSshKeyException("Failed validity check");
                }
                String string3 = ((ByteArrayReader)object).readString();
                if (string3.equals("ecdsa-sha2-nistp256") || string3.equals("ecdsa-sha2-nistp384") || string3.equals("ecdsa-sha2-nistp521")) {
                    String string4 = ((ByteArrayReader)object).readString();
                    ((ByteArrayReader)object).readBinaryString();
                    SshPublicKey sshPublicKey = SshKeyPairFactory.decodePublicKey(byArray5);
                    ECPublicKeyParameters eCPublicKeyParameters = ((SshEcdsaNistpPublicKey)sshPublicKey).getPublicKeyParameters();
                    byte[] byArray6 = ((ByteArrayReader)object).readBinaryString();
                    BigInteger bigInteger = new BigInteger(1, byArray6);
                    ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                    byteArrayWriter.writeString(string3);
                    byteArrayWriter.writeString(string4);
                    byteArrayWriter.writeBinaryString(eCPublicKeyParameters.getQ().getEncoded(false));
                    byteArrayWriter.writeBigInteger(bigInteger);
                    return byteArrayWriter.toByteArray();
                }
                if (string3.equals("ssh-ed25519")) {
                    ((ByteArrayReader)object).readBinaryString();
                    byte[] byArray7 = ((ByteArrayReader)object).readBinaryString();
                    byte[] byArray8 = new byte[32];
                    System.arraycopy(byArray7, 0, byArray8, 0, byArray8.length);
                    ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                    byteArrayWriter.writeString(string3);
                    byteArrayWriter.writeBinaryString(byArray8);
                    return byteArrayWriter.toByteArray();
                }
                if (string3.equals("ssh-rsa")) {
                    BigInteger bigInteger = ((ByteArrayReader)object).readBigInteger();
                    BigInteger bigInteger2 = ((ByteArrayReader)object).readBigInteger();
                    BigInteger bigInteger3 = ((ByteArrayReader)object).readBigInteger();
                    ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                    byteArrayWriter.writeString(string3);
                    byteArrayWriter.writeBigInteger(bigInteger2);
                    byteArrayWriter.writeBigInteger(bigInteger);
                    byteArrayWriter.writeBigInteger(bigInteger3);
                    return byteArrayWriter.toByteArray();
                }
                if (string3.equals("ssh-dss")) {
                    BigInteger bigInteger = ((ByteArrayReader)object).readBigInteger();
                    BigInteger bigInteger4 = ((ByteArrayReader)object).readBigInteger();
                    BigInteger bigInteger5 = ((ByteArrayReader)object).readBigInteger();
                    BigInteger bigInteger6 = ((ByteArrayReader)object).readBigInteger();
                    BigInteger bigInteger7 = ((ByteArrayReader)object).readBigInteger();
                    ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                    byteArrayWriter.writeString(string3);
                    byteArrayWriter.writeBigInteger(bigInteger);
                    byteArrayWriter.writeBigInteger(bigInteger4);
                    byteArrayWriter.writeBigInteger(bigInteger5);
                    byteArrayWriter.writeBigInteger(bigInteger7);
                    return byteArrayWriter.toByteArray();
                }
                throw new InvalidSshKeyException("Unsupported algorithm: " + string3);
            }
            throw new InvalidSshKeyException("Unsupported type: " + pEMReader.getType());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidSshKeyException("Can't read key due to cryptography problems", generalSecurityException);
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException("Can't read key due to internal IO problems:", iOException);
        }
    }

    private String a(ByteArrayReader byteArrayReader) throws IOException {
        byte[] byArray = new byte["openssh-key-v1".length()];
        byteArrayReader.read(byArray);
        if (!Arrays.equals(byArray, "openssh-key-v1".getBytes("UTF-8"))) {
            throw new IOException("Format error: " + new String(byArray));
        }
        byteArrayReader.skip(1L);
        return byteArrayReader.readString();
    }

    private SshCipher a(String string) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidSshKeyException {
        if ("AES256-CBC".equalsIgnoreCase(string)) {
            return new AES_CBC_256();
        }
        if ("AES256-CTR".equalsIgnoreCase(string)) {
            return new AES_CTR_256();
        }
        throw new NoSuchAlgorithmException("Unknown cipher " + string);
    }

    private int b(String string) throws NoSuchAlgorithmException {
        if ("AES256-CBC".equalsIgnoreCase(string) || "AES256-CTR".equalsIgnoreCase(string)) {
            return 32;
        }
        throw new NoSuchAlgorithmException("Unknown cipher " + string);
    }

    private int c(String string) throws NoSuchAlgorithmException {
        if ("AES256-CBC".equalsIgnoreCase(string) || "AES256-CTR".equalsIgnoreCase(string)) {
            return 16;
        }
        throw new NoSuchAlgorithmException("Unknown cipher " + string);
    }

    @Override
    public byte[] encryptKeyblob(byte[] keyblob, String passphrase) throws InvalidSshKeyException {
        throw new InvalidSshKeyException("Unsupported operation");
    }

    @Override
    public boolean isFormatted(byte[] formattedKey) {
        try {
            StringReader stringReader = new StringReader(new String(formattedKey, "US-ASCII"));
            PEMReader pEMReader = new PEMReader(stringReader);
            return "OPENSSH PRIVATE KEY".equals(pEMReader.getType());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public boolean isPassphraseProtected(byte[] formattedKey) {
        try {
            StringReader stringReader = new StringReader(new String(formattedKey, "US-ASCII"));
            PEMReader pEMReader = new PEMReader(stringReader);
            byte[] byArray = pEMReader.getPayload();
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = this.a(byteArrayReader);
            return !string.equals("none");
        }
        catch (IOException iOException) {
            return true;
        }
    }

    @Override
    public boolean supportsAlgorithm(String algorithm) {
        return SshKeyPairFactory.DSA.equals(algorithm) || SshKeyPairFactory.RSA.equals(algorithm) || SshKeyPairFactory.ECDSA_SHA2_NISTP256.equals(algorithm) || SshKeyPairFactory.ECDSA_SHA2_NISTP256.equals(algorithm) || SshKeyPairFactory.ECDSA_SHA2_NISTP256.equals(algorithm);
    }

    public static void main(String[] args) {
        try {
            LoadProviders.init();
            SshPrivateKeyFile sshPrivateKeyFile = SshPrivateKeyFile.parse(new File(args[0]));
            byte[] byArray = sshPrivateKeyFile.getKeyBlob("password");
        }
        catch (IOException iOException) {
            a.debug(iOException.getMessage());
        }
    }
}

