/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.openssh;

import com.enterprisedt.cryptix.util.core.Hex;
import com.enterprisedt.net.j2ssh.openssh.PEM;
import com.enterprisedt.net.j2ssh.util.Base64;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import xjava.security.Cipher;
import xjava.security.FeedbackCipher;

public class PEMReader
extends PEM {
    private LineNumberReader a;
    private String b;
    private Map c;
    private byte[] d;

    public PEMReader(Reader r2) throws IOException {
        this.a = new LineNumberReader(r2);
        this.a();
    }

    private void a() throws IOException {
        int n2;
        String string;
        while ((string = this.a.readLine()) != null) {
            if (!string.startsWith("-----") || !string.endsWith("-----")) continue;
            if (string.startsWith("-----BEGIN ")) {
                this.b = string.substring("-----BEGIN ".length(), string.length() - "-----".length());
                break;
            }
            throw new IOException("Invalid PEM boundary at line " + this.a.getLineNumber() + ": " + string);
        }
        this.c = new HashMap();
        block1: while ((string = this.a.readLine()) != null && (n2 = string.indexOf(58)) != -1) {
            String string2;
            String string3 = string.substring(0, n2).trim();
            if (string.endsWith("\\")) {
                string2 = string.substring(n2 + 1, string.length() - 1).trim();
                StringBuffer stringBuffer = new StringBuffer(string2);
                while ((string = this.a.readLine()) != null) {
                    if (string.endsWith("\\")) {
                        stringBuffer.append(" ").append(string.substring(0, string.length() - 1).trim());
                        continue;
                    }
                    stringBuffer.append(" ").append(string.trim());
                    continue block1;
                }
                continue;
            }
            string2 = string.substring(n2 + 1).trim();
            this.c.put(string3, string2);
        }
        if (string == null) {
            throw new IOException("The key format is invalid! OpenSSH formatted keys must begin with -----BEGIN RSA or -----BEGIN DSA");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while ((string = this.a.readLine()) != null) {
            if (string.startsWith("-----") && string.endsWith("-----")) {
                if (string.startsWith("-----END " + this.b)) break;
                throw new IOException("Invalid PEM end boundary at line " + this.a.getLineNumber() + ": " + string);
            }
            stringBuffer.append(string);
        }
        this.d = Base64.decode(stringBuffer.toString());
    }

    public Map getHeader() {
        return this.c;
    }

    public byte[] getPayload() {
        return this.d;
    }

    public String getType() {
        return this.b;
    }

    public byte[] decryptPayload(String passphrase) throws GeneralSecurityException {
        String string = (String)this.c.get("DEK-Info");
        if (string != null) {
            byte[] byArray;
            int n2 = string.indexOf(44);
            String string2 = string.substring(0, n2).toUpperCase();
            int n3 = 24;
            String string3 = null;
            if ("DES-EDE3-CBC".equals(string2)) {
                string3 = "DESede/CBC/NONE";
            } else if ("DES-EDE3-CFB".equals(string2)) {
                string3 = "DESede/CFB/NONE";
            } else if ("AES-128-CBC".equals(string2)) {
                string3 = "AES/CBC/PKCS7";
                n3 = 16;
            } else if ("AES-192-CBC".equals(string2)) {
                string3 = "AES/CBC/PKCS7";
                n3 = 24;
            } else if ("AES-256-CBC".equals(string2)) {
                string3 = "AES/CBC/PKCS7";
                n3 = 32;
            } else {
                throw new NoSuchAlgorithmException("Unsupported passphrase algorithm: " + string2);
            }
            String string4 = string.substring(n2 + 1);
            byte[] byArray2 = byArray = Hex.fromString(string4);
            if (byArray.length > 8) {
                byArray2 = new byte[8];
                System.arraycopy(byArray, 0, byArray2, 0, 8);
            }
            Cipher cipher = Cipher.getInstance(string3, "CryptixEDT");
            Key key = PEMReader.getKeyFromPassphrase(passphrase, string2, byArray2, n3);
            if (cipher instanceof FeedbackCipher) {
                ((FeedbackCipher)((Object)cipher)).setInitializationVector(byArray);
            }
            cipher.initDecrypt(key);
            byte[] byArray3 = new byte[this.d.length];
            cipher.update(this.d, 0, this.d.length, byArray3, 0);
            byte by = byArray3[byArray3.length - 1];
            int n4 = byArray3.length - by;
            byte[] byArray4 = new byte[n4];
            System.arraycopy(byArray3, 0, byArray4, 0, n4);
            return byArray4;
        }
        return this.d;
    }
}

