/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.session;

import com.enterprisedt.net.j2ssh.connection.ChannelInputStream;
import com.enterprisedt.net.j2ssh.connection.IOChannel;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelExtendedData;
import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.io.UnsignedInteger32;
import com.enterprisedt.net.j2ssh.session.PseudoTerminal;
import com.enterprisedt.net.j2ssh.session.SignalListener;
import com.enterprisedt.net.j2ssh.subsystem.SubsystemClient;
import com.enterprisedt.net.j2ssh.transport.SshMessageStore;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.io.InputStream;

public class SessionChannelClient
extends IOChannel {
    private static Logger a = Logger.getLogger(SessionChannelClient.class);
    private Integer b = null;
    private String c = "Uninitialized";
    private SubsystemClient d;
    private boolean e = false;
    private SignalListener f;
    private SshMessageStore g = new SshMessageStore();
    private ChannelInputStream h = new ChannelInputStream(this.g, new Integer(1));

    public SessionChannelClient() {
        this.setName("session");
    }

    @Override
    public byte[] getChannelOpenData() {
        return null;
    }

    @Override
    public byte[] getChannelConfirmationData() {
        return null;
    }

    @Override
    public String getChannelType() {
        return "session";
    }

    @Override
    protected int getMinimumWindowSpace() {
        return DEFAULT_MIN_WINDOW_SPACE;
    }

    @Override
    protected int getMaximumWindowSpace() {
        return DEFAULT_MAX_WINDOW_SPACE;
    }

    @Override
    protected int getMaximumPacketSize() {
        return DEFAULT_MAX_PACKET_SIZE;
    }

    public void setSignalListener(SignalListener signalListener) {
        this.f = signalListener;
    }

    public boolean setEnvironmentVariable(String name, String value) throws IOException {
        a.debug("Requesting environment variable to be set [" + name + "=" + value + "]");
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(name);
        byteArrayWriter.writeString(value);
        return this.connection.sendChannelRequest(this, "env", true, byteArrayWriter.toByteArray());
    }

    public boolean requestX11Forwarding(int display, String cookie) throws IOException {
        a.debug("Requesting X11 forwarding for display " + display + " using cookie " + cookie);
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeBoolean(false);
        byteArrayWriter.writeString("MIT-MAGIC-COOKIE-1");
        byteArrayWriter.writeString(cookie);
        byteArrayWriter.writeUINT32(new UnsignedInteger32(String.valueOf(display)));
        return this.connection.sendChannelRequest(this, "x11-req", true, byteArrayWriter.toByteArray());
    }

    public Integer getExitCode() {
        return this.b;
    }

    public void changeTerminalDimensions(PseudoTerminal term) throws IOException {
        a.debug("Changing terminal dimensions");
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeInt(term.getColumns());
        byteArrayWriter.writeInt(term.getRows());
        byteArrayWriter.writeInt(term.getWidth());
        byteArrayWriter.writeInt(term.getHeight());
        this.connection.sendChannelRequest(this, "window-change", false, byteArrayWriter.toByteArray());
    }

    public boolean executeCommand(String command) throws IOException {
        a.debug("Requesting command execution");
        a.debug("Command is " + command);
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(command);
        if (this.connection.sendChannelRequest(this, "exec", true, byteArrayWriter.toByteArray())) {
            if (this.c.equals("Uninitialized")) {
                this.c = command;
            }
            return true;
        }
        return false;
    }

    public boolean requestPseudoTerminal(String term, int cols, int rows, int width, int height, String terminalModes) throws IOException {
        a.debug("Requesting pseudo terminal");
        if (a.isDebugEnabled()) {
            a.debug("Terminal Type is " + term);
            a.debug("Columns=" + String.valueOf(cols));
            a.debug("Rows=" + String.valueOf(rows));
            a.debug("Width=" + String.valueOf(width));
            a.debug("Height=" + String.valueOf(height));
        }
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(term);
        byteArrayWriter.writeInt(cols);
        byteArrayWriter.writeInt(rows);
        byteArrayWriter.writeInt(width);
        byteArrayWriter.writeInt(height);
        byteArrayWriter.writeString(terminalModes);
        return this.connection.sendChannelRequest(this, "pty-req", true, byteArrayWriter.toByteArray());
    }

    public boolean requestPseudoTerminal(PseudoTerminal term) throws IOException {
        return this.requestPseudoTerminal(term.getTerm(), term.getColumns(), term.getRows(), term.getWidth(), term.getHeight(), term.getEncodedTerminalModes());
    }

    public boolean startShell() throws IOException {
        a.debug("Requesting users shell");
        if (this.connection.sendChannelRequest(this, "shell", true, null)) {
            if (this.c.equals("Uninitialized")) {
                this.c = "shell";
            }
            return true;
        }
        return false;
    }

    public boolean startSubsystem(String subsystem) throws IOException {
        a.debug("Starting " + subsystem + " subsystem");
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(subsystem);
        if (this.connection.sendChannelRequest(this, "subsystem", true, byteArrayWriter.toByteArray())) {
            if (this.c.equals("Uninitialized")) {
                this.c = subsystem;
            }
            return true;
        }
        return false;
    }

    public boolean startSubsystem(SubsystemClient subsystem) throws IOException {
        boolean bl = this.startSubsystem(subsystem.getName());
        if (bl) {
            this.d = subsystem;
            subsystem.setSessionChannel(this);
            subsystem.start();
        }
        return bl;
    }

    public boolean isLocalFlowControlEnabled() {
        return this.e;
    }

    public String getSessionType() {
        return this.c;
    }

    public void setSessionType(String sessionType) {
        this.c = sessionType;
    }

    public SubsystemClient getSubsystem() {
        return this.d;
    }

    @Override
    protected void onChannelClose() throws IOException {
        super.onChannelClose();
        try {
            this.h.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Integer n2 = this.getExitCode();
        if (n2 != null) {
            a.debug("Exit code " + n2.toString());
        }
    }

    @Override
    protected void onChannelOpen() throws IOException {
    }

    public InputStream getStderrInputStream() throws IOException {
        return this.h;
    }

    @Override
    protected void onChannelExtData(SshMsgChannelExtendedData msg) throws IOException {
        this.g.addMessage(msg);
    }

    @Override
    protected void onChannelRequest(String requestType, boolean wantReply, byte[] requestData) throws IOException {
        a.debug("Channel Request received: " + requestType);
        if (requestType.equals("exit-status")) {
            this.b = new Integer((int)ByteArrayReader.readInt(requestData, 0));
            a.debug("Exit code of " + this.b.toString() + " received");
        } else if (requestType.equals("exit-signal")) {
            ByteArrayReader byteArrayReader = new ByteArrayReader(requestData);
            String string = byteArrayReader.readString();
            boolean bl = byteArrayReader.read() != 0;
            String string2 = byteArrayReader.readString();
            byteArrayReader.readString();
            a.debug("Exit signal " + string + " received");
            a.debug("Signal message: " + string2);
            a.debug("Core dumped: " + String.valueOf(bl));
            if (this.f != null) {
                this.f.onExitSignal(string, bl, string2);
            }
        } else if (requestType.equals("xon-xoff")) {
            if (requestData.length >= 1) {
                this.e = requestData[0] != 0;
            }
        } else if (requestType.equals("signal")) {
            String string = ByteArrayReader.readString(requestData, 0);
            a.debug("Signal " + string + " received");
            if (this.f != null) {
                this.f.onSignal(string);
            }
        } else if (wantReply) {
            this.connection.sendChannelRequestFailure(this);
        }
    }
}

