/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.sftp;

import com.enterprisedt.net.ftp.DirectoryListArgument;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.io.UnsignedInteger32;
import com.enterprisedt.net.j2ssh.io.UnsignedInteger64;
import com.enterprisedt.net.j2ssh.sftp.DirectoryListCallback;
import com.enterprisedt.net.j2ssh.sftp.FileAttributes;
import com.enterprisedt.net.j2ssh.sftp.SftpFile;
import com.enterprisedt.net.j2ssh.sftp.SshFxpAttrs;
import com.enterprisedt.net.j2ssh.sftp.SshFxpClose;
import com.enterprisedt.net.j2ssh.sftp.SshFxpData;
import com.enterprisedt.net.j2ssh.sftp.SshFxpFSetStat;
import com.enterprisedt.net.j2ssh.sftp.SshFxpFStat;
import com.enterprisedt.net.j2ssh.sftp.SshFxpHandle;
import com.enterprisedt.net.j2ssh.sftp.SshFxpInit;
import com.enterprisedt.net.j2ssh.sftp.SshFxpMkdir;
import com.enterprisedt.net.j2ssh.sftp.SshFxpName;
import com.enterprisedt.net.j2ssh.sftp.SshFxpOpen;
import com.enterprisedt.net.j2ssh.sftp.SshFxpOpenDir;
import com.enterprisedt.net.j2ssh.sftp.SshFxpRead;
import com.enterprisedt.net.j2ssh.sftp.SshFxpReadDir;
import com.enterprisedt.net.j2ssh.sftp.SshFxpReadlink;
import com.enterprisedt.net.j2ssh.sftp.SshFxpRealPath;
import com.enterprisedt.net.j2ssh.sftp.SshFxpRemove;
import com.enterprisedt.net.j2ssh.sftp.SshFxpRename;
import com.enterprisedt.net.j2ssh.sftp.SshFxpRmdir;
import com.enterprisedt.net.j2ssh.sftp.SshFxpSetStat;
import com.enterprisedt.net.j2ssh.sftp.SshFxpStat;
import com.enterprisedt.net.j2ssh.sftp.SshFxpStatus;
import com.enterprisedt.net.j2ssh.sftp.SshFxpSymlink;
import com.enterprisedt.net.j2ssh.sftp.SshFxpVersion;
import com.enterprisedt.net.j2ssh.sftp.SshFxpWrite;
import com.enterprisedt.net.j2ssh.sftp.b;
import com.enterprisedt.net.j2ssh.subsystem.SubsystemChannel;
import com.enterprisedt.net.j2ssh.subsystem.SubsystemMessage;
import com.enterprisedt.net.j2ssh.transport.InvalidMessageException;
import com.enterprisedt.net.j2ssh.transport.MessageNotAvailableException;
import com.enterprisedt.net.j2ssh.transport.MessageStoreEOFException;
import com.enterprisedt.util.debug.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class SftpSubsystemClient
extends SubsystemChannel {
    public static final int OPEN_READ = 1;
    public static final int OPEN_WRITE = 2;
    public static final int OPEN_APPEND = 4;
    public static final int OPEN_CREATE = 8;
    public static final int OPEN_TRUNCATE = 16;
    public static final int OPEN_EXCLUSIVE = 32;
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    public static final int VERSION_4 = 4;
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static Logger e = Logger.getLogger("SftpSubsystemClient");
    private List f = new Vector();
    private UnsignedInteger32 g = new UnsignedInteger32(1L);
    private int h = 3;
    private b i = (b)this.messageStore;
    private String j = "UTF-8";
    private String k = "test -x /usr/lib/sftp-server && exec /usr/lib/sftp-server\ntest -x /usr/local/lib/sftp-server && exec /usr/local/lib/sftp-server\nexec sftp-server";
    private boolean l = true;

    public SftpSubsystemClient() {
        super("sftp", new b());
        this.b();
    }

    public void setControlEncoding(String controlEncoding) {
        this.i.a(controlEncoding);
        this.j = controlEncoding;
        e.info("Using control encoding: " + controlEncoding);
    }

    public void setServerResponseTimeout(long serverResponseTimeout) {
        this.i.a(serverResponseTimeout);
    }

    @Override
    protected byte[] toByteArray(SubsystemMessage msg) throws InvalidMessageException {
        return msg.toByteArray(this.j);
    }

    @Override
    public String getName() {
        return "sftp";
    }

    protected long availableRemoteWindowSpace() {
        return this.getRemoteWindow().getWindowSpace();
    }

    protected void waitForRemoteWindowSpace(int count) throws IOException {
        this.getRemoteWindow().waitForWindowSpace(count);
    }

    protected long maximumRemotePacketSize() {
        return this.getRemotePacketSize();
    }

    public synchronized void closeHandle(byte[] handle) throws IOException {
        if (!this.isValidHandle(handle)) {
            throw new IOException("The handle is invalid!");
        }
        this.f.remove(handle);
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpClose sshFxpClose = new SshFxpClose(unsignedInteger32, handle);
        this.sendMessage(sshFxpClose);
        try {
            this.getOKRequestStatus(unsignedInteger32);
        }
        catch (FTPException fTPException) {
            throw new IOException(fTPException.getMessage());
        }
    }

    public void closeFile(SftpFile file) throws IOException {
        e.debug("Closing file " + file.getAbsolutePath());
        this.closeHandle(file.getHandle());
    }

    protected boolean isValidHandle(byte[] handle) {
        return this.f.contains(handle);
    }

    public synchronized int listChildren(String path, byte[] handle, List children) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpReadDir sshFxpReadDir = new SshFxpReadDir(unsignedInteger32, handle);
        this.sendMessage(sshFxpReadDir);
        try {
            SubsystemMessage subsystemMessage = this.i.b(unsignedInteger32);
            if (subsystemMessage instanceof SshFxpName) {
                SshFxpName sshFxpName = (SshFxpName)subsystemMessage;
                SftpFile[] sftpFileArray = sshFxpName.getFiles();
                for (int i2 = 0; i2 < sftpFileArray.length; ++i2) {
                    SftpFile sftpFile = new SftpFile(path + "/" + sftpFileArray[i2].getFilename(), sftpFileArray[i2].getAttributes());
                    sftpFile.setSFTPSubsystem(this);
                    children.add(sftpFile);
                }
                return sftpFileArray.length;
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
                if (sshFxpStatus.getErrorCode().intValue() == 1) {
                    return -1;
                }
                throw new FTPException(sshFxpStatus.getErrorMessage(), sshFxpStatus.getErrorCode().toString());
            }
            this.a(subsystemMessage);
            return -1;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    private void a(SubsystemMessage subsystemMessage) throws IOException {
        String string = "Unexpected server response " + (subsystemMessage != null ? subsystemMessage.getMessageName() : "null");
        e.error(string);
        throw new IOException(string);
    }

    public synchronized int listChildren(SftpFile file, List children, FileFilter filter, DirectoryListCallback lister) throws IOException, FTPException {
        if (!this.isValidHandle(file.getHandle())) {
            e.debug("Invalid handle - reopening directory " + file.getAbsolutePath());
            this.openDirectory(file);
            if (!this.isValidHandle(file.getHandle())) {
                throw new IOException("Failed to open directory");
            }
        }
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpReadDir sshFxpReadDir = new SshFxpReadDir(unsignedInteger32, file.getHandle());
        this.sendMessage(sshFxpReadDir);
        try {
            SubsystemMessage subsystemMessage = this.i.b(unsignedInteger32);
            if (subsystemMessage instanceof SshFxpName) {
                SshFxpName sshFxpName = (SshFxpName)subsystemMessage;
                SftpFile[] sftpFileArray = sshFxpName.getFiles();
                if (sftpFileArray.length == 0) {
                    e.debug("Zero length listing - assuming listing terminated");
                    return -1;
                }
                for (int i2 = 0; i2 < sftpFileArray.length; ++i2) {
                    DirectoryListArgument directoryListArgument;
                    if (filter != null && !filter.accept(new File(sftpFileArray[i2].getFilename()))) continue;
                    SftpFile sftpFile = new SftpFile(file.getAbsolutePath() + "/" + sftpFileArray[i2].getFilename(), sftpFileArray[i2].getAttributes());
                    sftpFile.setSFTPSubsystem(this);
                    if (lister != null && (directoryListArgument = lister.listDirectoryEntry(sftpFile)) != null && directoryListArgument.isListingAborted()) {
                        e.warn("Aborting listing");
                        return -1;
                    }
                    if (children == null) continue;
                    children.add(sftpFile);
                }
                return sftpFileArray.length;
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
                if (sshFxpStatus.getErrorCode().intValue() == 1) {
                    return -1;
                }
                throw new FTPException(sshFxpStatus.getErrorMessage(), sshFxpStatus.getErrorCode().toString());
            }
            this.a(subsystemMessage);
            return -1;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    public synchronized void makeDirectory(String path) throws IOException, FTPException {
        String string = this.getAbsolutePath(path);
        e.debug("Make directory: " + string);
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpMkdir sshFxpMkdir = new SshFxpMkdir(unsignedInteger32, string, new FileAttributes());
        this.sendMessage(sshFxpMkdir);
        this.getOKRequestStatus(unsignedInteger32);
    }

    public void recurseMakeDirectory(String path) throws IOException, FTPException {
        if (path.trim().length() > 0) {
            try {
                SftpFile sftpFile = this.openDirectory(path);
                sftpFile.close();
            }
            catch (FTPException fTPException) {
                StringTokenizer stringTokenizer = new StringTokenizer(path, "/", true);
                String string = "";
                while (stringTokenizer.hasMoreElements()) {
                    string = string + stringTokenizer.nextElement();
                    try {
                        SftpFile sftpFile = this.openDirectory(string);
                        sftpFile.close();
                    }
                    catch (FTPException fTPException2) {
                        e.debug("Creating " + string);
                        this.makeDirectory(string);
                    }
                }
            }
        }
    }

    @Override
    protected void onChannelClose() throws IOException {
        this.i.close();
    }

    public synchronized SftpFile openDirectory(String path) throws IOException, FTPException {
        String string = this.getAbsolutePath(path);
        e.debug("Opening directory " + string);
        UnsignedInteger32 unsignedInteger32 = this.a();
        SubsystemMessage subsystemMessage = new SshFxpOpenDir(unsignedInteger32, string);
        this.sendMessage(subsystemMessage);
        byte[] byArray = this.a(unsignedInteger32);
        unsignedInteger32 = this.a();
        subsystemMessage = new SshFxpStat(unsignedInteger32, string);
        this.sendMessage(subsystemMessage);
        try {
            SubsystemMessage subsystemMessage2 = this.i.b(unsignedInteger32);
            if (subsystemMessage2 instanceof SshFxpAttrs) {
                SftpFile sftpFile = new SftpFile(string, ((SshFxpAttrs)subsystemMessage2).getAttributes());
                sftpFile.setHandle(byArray);
                sftpFile.setSFTPSubsystem(this);
                return sftpFile;
            }
            if (subsystemMessage2 instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage2;
                e.warn("openDirectory: " + sshFxpStatus.getErrorMessage());
                FileAttributes fileAttributes = new FileAttributes();
                fileAttributes.isDirectory(true);
                SftpFile sftpFile = new SftpFile(string, fileAttributes);
                sftpFile.setHandle(byArray);
                sftpFile.setSFTPSubsystem(this);
                return sftpFile;
            }
            this.a(subsystemMessage2);
            return null;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    public synchronized void openDirectory(SftpFile dir) throws IOException, FTPException {
        e.debug("Opening directory " + dir.getAbsolutePath());
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpOpenDir sshFxpOpenDir = new SshFxpOpenDir(unsignedInteger32, dir.getAbsolutePath());
        this.sendMessage(sshFxpOpenDir);
        byte[] byArray = this.a(unsignedInteger32);
        dir.setHandle(byArray);
    }

    public String getDefaultDirectory() throws IOException, FTPException {
        return this.getAbsolutePath("");
    }

    public synchronized String getAbsolutePath(String path) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpRealPath sshFxpRealPath = new SshFxpRealPath(unsignedInteger32, path);
        this.sendMessage(sshFxpRealPath);
        try {
            SubsystemMessage subsystemMessage = this.i.b(unsignedInteger32);
            if (subsystemMessage == null) {
                throw new IOException("Null response to FXP_REAL_PATH");
            }
            if (subsystemMessage instanceof SshFxpName) {
                SftpFile[] sftpFileArray = ((SshFxpName)subsystemMessage).getFiles();
                String string = "Server responded to SSH_FXP_REALPATH with too many files";
                if (sftpFileArray.length != 1) {
                    e.warn(string);
                    return path;
                }
                return sftpFileArray[0].getAbsolutePath();
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
                e.warn("getAbsolutePath: " + sshFxpStatus.getErrorMessage());
                return path;
            }
            this.a(subsystemMessage);
            return null;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    public String getAbsolutePath(SftpFile file) throws IOException, FTPException {
        return this.getAbsolutePath(file.getFilename());
    }

    public SftpFile openFile(String filename, int flags) throws IOException, FTPException {
        return this.openFile(filename, flags, null);
    }

    public synchronized SftpFile openFile(String absolutePath, int flags, FileAttributes attrs) throws IOException, FTPException {
        if (attrs == null) {
            attrs = new FileAttributes();
        }
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpOpen sshFxpOpen = new SshFxpOpen(unsignedInteger32, absolutePath, new UnsignedInteger32(flags), attrs);
        this.sendMessage(sshFxpOpen);
        byte[] byArray = this.a(unsignedInteger32);
        SftpFile sftpFile = new SftpFile(absolutePath, null);
        sftpFile.setHandle(byArray);
        sftpFile.setSFTPSubsystem(this);
        return sftpFile;
    }

    public synchronized FileAttributes getAttributes(String path) throws IOException, FTPException {
        e.debug("getAttributes('" + path + "')");
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpStat sshFxpStat = new SshFxpStat(unsignedInteger32, path);
        this.sendMessage(sshFxpStat);
        try {
            SubsystemMessage subsystemMessage = this.i.b(unsignedInteger32);
            if (subsystemMessage instanceof SshFxpAttrs) {
                return ((SshFxpAttrs)subsystemMessage).getAttributes();
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
                throw new FTPException(sshFxpStatus.getErrorMessage() + " : " + path, sshFxpStatus.getErrorCode().toString());
            }
            if (this.getState().getValue() != 1) {
                String string = "Connection closed unexpectedly.";
                e.error(string);
                throw new IOException(string);
            }
            this.a(subsystemMessage);
            return null;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    public synchronized FileAttributes getAttributes(SftpFile file) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.a();
        SubsystemMessage subsystemMessage = !this.isValidHandle(file.getHandle()) ? new SshFxpStat(unsignedInteger32, file.getAbsolutePath()) : new SshFxpFStat(unsignedInteger32, file.getHandle());
        this.sendMessage(subsystemMessage);
        try {
            SubsystemMessage subsystemMessage2 = this.i.b(unsignedInteger32);
            if (subsystemMessage2 instanceof SshFxpAttrs) {
                return ((SshFxpAttrs)subsystemMessage2).getAttributes();
            }
            if (subsystemMessage2 instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage2;
                throw new FTPException(sshFxpStatus.getErrorMessage() + " : " + file.getAbsolutePath(), sshFxpStatus.getErrorCode().toString());
            }
            this.a(subsystemMessage2);
            return null;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    public synchronized SshFxpRead createReadRequest(byte[] handle, long offset, int len) throws IOException {
        if (!this.f.contains(handle)) {
            throw new IOException("The file handle is invalid!");
        }
        UnsignedInteger32 unsignedInteger32 = this.a();
        return new SshFxpRead(unsignedInteger32, handle, UnsignedInteger64.add(UnsignedInteger64.ZERO, offset), new UnsignedInteger32(len));
    }

    public synchronized int receiveReadResponse(byte[] output, int off, UnsignedInteger32 requestId) throws IOException {
        try {
            SubsystemMessage subsystemMessage = this.i.b(requestId);
            if (subsystemMessage instanceof SshFxpData) {
                byte[] byArray = ((SshFxpData)subsystemMessage).getData();
                System.arraycopy(byArray, 0, output, off, byArray.length);
                return byArray.length;
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
                if (sshFxpStatus.getErrorCode().intValue() == 1) {
                    return -1;
                }
                e.error("read failed: " + sshFxpStatus.getErrorMessage());
                throw new IOException(sshFxpStatus.getErrorMessage());
            }
            this.a(subsystemMessage);
            return -1;
        }
        catch (InterruptedException interruptedException) {
            String string = "read: interrupted";
            e.error(string);
            throw new IOException(string);
        }
    }

    protected synchronized int readFile(byte[] handle, UnsignedInteger64 offset, byte[] output, int off, int len) throws IOException {
        if (!this.f.contains(handle)) {
            throw new IOException("The file handle is invalid!");
        }
        if (output.length - off < len) {
            throw new IOException("Output array size is smaller than read length!");
        }
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpRead sshFxpRead = new SshFxpRead(unsignedInteger32, handle, offset, new UnsignedInteger32(len));
        this.sendMessage(sshFxpRead);
        try {
            SubsystemMessage subsystemMessage = this.i.b(unsignedInteger32);
            if (subsystemMessage instanceof SshFxpData) {
                byte[] byArray = ((SshFxpData)subsystemMessage).getData();
                System.arraycopy(byArray, 0, output, off, byArray.length);
                return byArray.length;
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
                if (sshFxpStatus.getErrorCode().intValue() == 1) {
                    return -1;
                }
                e.error("readFile failed: " + sshFxpStatus.getErrorMessage());
                throw new IOException(sshFxpStatus.getErrorMessage());
            }
            this.a(subsystemMessage);
            return -1;
        }
        catch (InterruptedException interruptedException) {
            String string = "readFile: interrupted";
            e.error(string);
            throw new IOException(string);
        }
    }

    public synchronized void removeDirectory(String path) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpRmdir sshFxpRmdir = new SshFxpRmdir(unsignedInteger32, path);
        this.sendMessage(sshFxpRmdir);
        this.getOKRequestStatus(unsignedInteger32);
    }

    public synchronized void removeFile(String filename) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpRemove sshFxpRemove = new SshFxpRemove(unsignedInteger32, filename);
        this.sendMessage(sshFxpRemove);
        this.getOKRequestStatus(unsignedInteger32);
    }

    public synchronized void renameFile(String oldpath, String newpath) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpRename sshFxpRename = new SshFxpRename(unsignedInteger32, oldpath, newpath);
        this.sendMessage(sshFxpRename);
        this.getOKRequestStatus(unsignedInteger32);
    }

    protected synchronized void writeFile(byte[] handle, UnsignedInteger64 offset, byte[] data, int off, int len) throws IOException {
        if (!this.f.contains(handle)) {
            throw new IOException("The handle is not valid!");
        }
        if (data.length - off < len) {
            throw new IOException("Incorrect data array size!");
        }
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpWrite sshFxpWrite = new SshFxpWrite(unsignedInteger32, handle, offset, data, off, len);
        this.sendMessage(sshFxpWrite);
        try {
            this.getOKRequestStatus(unsignedInteger32);
        }
        catch (FTPException fTPException) {
            throw new IOException(fTPException.getMessage());
        }
    }

    protected synchronized UnsignedInteger32 writeFileAsync(byte[] handle, UnsignedInteger64 offset, byte[] data, int off, int len) throws IOException {
        if (!this.f.contains(handle)) {
            throw new IOException("The handle is not valid!");
        }
        if (data.length - off < len) {
            throw new IOException("Incorrect data array size!");
        }
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpWrite sshFxpWrite = new SshFxpWrite(unsignedInteger32, handle, offset, data, off, len);
        this.sendMessage(sshFxpWrite);
        return unsignedInteger32;
    }

    protected synchronized UnsignedInteger32[] writeAsTwoSwappedMessagesFileAsync(byte[] handle, UnsignedInteger64 offset, byte[] data, int off, int len) throws IOException {
        if (!this.f.contains(handle)) {
            throw new IOException("The handle is not valid!");
        }
        if (data.length - off < len) {
            throw new IOException("Incorrect data array size!");
        }
        int n2 = len / 2;
        int n3 = len - n2;
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpWrite sshFxpWrite = new SshFxpWrite(unsignedInteger32, handle, offset, data, off, n2);
        UnsignedInteger32 unsignedInteger322 = this.a();
        offset = UnsignedInteger64.add(offset, n2);
        SshFxpWrite sshFxpWrite2 = new SshFxpWrite(unsignedInteger322, handle, offset, data, off + n2, n3);
        this.sendMessage(sshFxpWrite2);
        this.sendMessage(sshFxpWrite);
        UnsignedInteger32[] unsignedInteger32Array = new UnsignedInteger32[]{unsignedInteger32, unsignedInteger322};
        return unsignedInteger32Array;
    }

    public synchronized void createSymbolicLink(String targetpath, String linkpath) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpSymlink sshFxpSymlink = new SshFxpSymlink(unsignedInteger32, targetpath, linkpath);
        this.sendMessage(sshFxpSymlink);
        this.getOKRequestStatus(unsignedInteger32);
    }

    public synchronized String getSymbolicLinkTarget(String linkpath) throws IOException {
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpReadlink sshFxpReadlink = new SshFxpReadlink(unsignedInteger32, linkpath);
        this.sendMessage(sshFxpReadlink);
        try {
            SubsystemMessage subsystemMessage = this.i.b(unsignedInteger32);
            if (subsystemMessage instanceof SshFxpName) {
                SftpFile[] sftpFileArray = ((SshFxpName)subsystemMessage).getFiles();
                if (sftpFileArray.length != 1) {
                    throw new IOException("Server responded to SSH_FXP_REALLINK with too many files!");
                }
                return sftpFileArray[0].getAbsolutePath();
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                throw new IOException(((SshFxpStatus)subsystemMessage).getErrorMessage());
            }
            this.a(subsystemMessage);
            return null;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    public synchronized void setAttributes(String path, FileAttributes attrs) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpSetStat sshFxpSetStat = new SshFxpSetStat(unsignedInteger32, path, attrs);
        this.sendMessage(sshFxpSetStat);
        this.getOKRequestStatus(unsignedInteger32);
    }

    public synchronized void setAttributes(SftpFile file, FileAttributes attrs) throws IOException, FTPException {
        if (!this.isValidHandle(file.getHandle())) {
            throw new IOException("The handle is not an open file handle!");
        }
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpFSetStat sshFxpFSetStat = new SshFxpFSetStat(unsignedInteger32, file.getHandle(), attrs);
        this.sendMessage(sshFxpFSetStat);
        this.getOKRequestStatus(unsignedInteger32);
    }

    public void changePermissions(SftpFile file, String permissions) throws IOException, FTPException {
        FileAttributes fileAttributes = new FileAttributes();
        fileAttributes.setPermissions(permissions);
        this.setAttributes(file, fileAttributes);
    }

    public void changePermissions(SftpFile file, int permissions) throws IOException, FTPException {
        FileAttributes fileAttributes = new FileAttributes();
        fileAttributes.setPermissions(new UnsignedInteger32(permissions));
        this.setAttributes(file, fileAttributes);
    }

    public void changePermissions(String filename, int permissions) throws IOException, FTPException {
        FileAttributes fileAttributes = new FileAttributes();
        fileAttributes.setPermissions(new UnsignedInteger32(permissions));
        this.setAttributes(filename, fileAttributes);
    }

    public void changePermissions(String filename, String permissions) throws IOException, FTPException {
        FileAttributes fileAttributes = new FileAttributes();
        fileAttributes.setPermissions(permissions);
        this.setAttributes(filename, fileAttributes);
    }

    public synchronized boolean initialize(String sftpSubsystemPath) throws IOException {
        Object object;
        e.debug("Initializing SFTP protocol version " + String.valueOf(this.h));
        boolean bl = true;
        if (sftpSubsystemPath == null) {
            bl = this.startSubsystem();
        } else {
            e.debug("SFTP command is " + sftpSubsystemPath);
            object = new ByteArrayWriter();
            ((ByteArrayWriter)object).writeString(sftpSubsystemPath);
            if (!this.connection.sendChannelRequest(this, "exec", true, ((ByteArrayOutputStream)object).toByteArray())) {
                bl = false;
            }
        }
        if (!bl) {
            e.debug("Opening SFTP subsystem failed: trying fallback");
            object = new ByteArrayWriter();
            ((ByteArrayWriter)object).writeString(this.k);
            if (!this.connection.sendChannelRequest(this, "exec", true, ((ByteArrayOutputStream)object).toByteArray())) {
                return false;
            }
        }
        bl = false;
        object = new SshFxpInit(new UnsignedInteger32(this.h), null);
        this.sendMessage((SubsystemMessage)object);
        SubsystemMessage subsystemMessage = null;
        for (int i2 = 0; i2 < 300; ++i2) {
            try {
                subsystemMessage = this.i.nextMessage(100);
                e.debug("Received reply to init msg");
                break;
            }
            catch (MessageNotAvailableException messageNotAvailableException) {
                e.debug("Timed out attempt #" + i2);
            }
            catch (MessageStoreEOFException messageStoreEOFException) {
                e.error("Failed to retrieve reply");
                return false;
            }
            if (this.getState().getValue() == 2) continue;
            e.error("State is not CHANNEL_OPEN - initialize failed");
            return false;
        }
        if (subsystemMessage instanceof SshFxpVersion) {
            bl = true;
            this.h = ((SshFxpVersion)subsystemMessage).getVersion().intValue();
            e.debug("Server responded with version " + String.valueOf(this.h));
        }
        return bl;
    }

    private byte[] a(UnsignedInteger32 unsignedInteger32) throws IOException, FTPException {
        try {
            SubsystemMessage subsystemMessage = this.i.b(unsignedInteger32);
            if (subsystemMessage instanceof SshFxpHandle) {
                byte[] byArray = ((SshFxpHandle)subsystemMessage).getHandle();
                this.f.add(byArray);
                return byArray;
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                throw new FTPException(((SshFxpStatus)subsystemMessage).getErrorMessage(), ((SshFxpStatus)subsystemMessage).getErrorCode().toString());
            }
            this.a(subsystemMessage);
            return null;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    public void getOKRequestStatus(UnsignedInteger32 requestId) throws IOException, FTPException {
        try {
            if (e.isDebugEnabled()) {
                e.debug("Waiting for response");
            }
            SubsystemMessage subsystemMessage = this.i.b(requestId);
            e.debug("Received response");
            if (subsystemMessage instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
                int n2 = sshFxpStatus.getErrorCode().intValue();
                if (n2 != 0) {
                    throw new FTPException(sshFxpStatus.getErrorMessage(), sshFxpStatus.getErrorCode().toString());
                }
            } else {
                this.a(subsystemMessage);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    public boolean getOKRequestStatusAsync(UnsignedInteger32 requestId) throws IOException {
        try {
            SubsystemMessage subsystemMessage = this.i.a(requestId);
            if (subsystemMessage == null) {
                return false;
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
                int n2 = sshFxpStatus.getErrorCode().intValue();
                if (n2 != 0) {
                    throw new IOException(sshFxpStatus.getErrorMessage());
                }
                return true;
            }
            this.a(subsystemMessage);
            return true;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    private UnsignedInteger32 a() {
        this.g = UnsignedInteger32.add(this.g, 1);
        return this.g;
    }

    private void b() {
        this.i.registerMessage(2, SshFxpVersion.class);
        this.i.registerMessage(105, SshFxpAttrs.class);
        this.i.registerMessage(103, SshFxpData.class);
        this.i.registerMessage(102, SshFxpHandle.class);
        this.i.registerMessage(101, SshFxpStatus.class);
        this.i.registerMessage(104, SshFxpName.class);
    }

    @Override
    protected int getMinimumWindowSpace() {
        return DEFAULT_MIN_WINDOW_SPACE;
    }

    @Override
    protected int getMaximumWindowSpace() {
        return DEFAULT_MAX_WINDOW_SPACE;
    }

    @Override
    protected int getMaximumPacketSize() {
        return DEFAULT_MAX_PACKET_SIZE;
    }
}

