/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.subsystem;

import com.enterprisedt.net.j2ssh.connection.Channel;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelData;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelExtendedData;
import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.io.DynamicBuffer;
import com.enterprisedt.net.j2ssh.subsystem.SubsystemMessage;
import com.enterprisedt.net.j2ssh.subsystem.SubsystemMessageStore;
import com.enterprisedt.net.j2ssh.transport.InvalidMessageException;
import com.enterprisedt.util.debug.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;

public abstract class SubsystemChannel
extends Channel {
    private static Logger e = Logger.getLogger("SubsystemChannel");
    Integer a = null;
    String b;
    protected SubsystemMessageStore messageStore;
    DynamicBuffer c = new DynamicBuffer();
    int d = -1;

    public SubsystemChannel(String name) {
        this.b = name;
        this.messageStore = new SubsystemMessageStore();
    }

    public SubsystemChannel(String name, SubsystemMessageStore messageStore) {
        this.b = name;
        this.messageStore = messageStore;
    }

    @Override
    public String getChannelType() {
        return "session";
    }

    protected void sendMessage(SubsystemMessage msg) throws InvalidMessageException, IOException {
        if (e.isDebugEnabled()) {
            e.debug("Sending " + msg.toString());
        }
        byte[] byArray = this.a(msg);
        this.sendChannelData(byArray);
    }

    private byte[] a(SubsystemMessage subsystemMessage) throws InvalidMessageException {
        byte[] byArray = this.toByteArray(subsystemMessage);
        byte[] byArray2 = ByteArrayWriter.encodeInt(byArray.length);
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        return byArray3;
    }

    public void sendMessages(List<SubsystemMessage> requests) throws InvalidMessageException, IOException {
        e.debug("Sending " + requests.size() + " messages");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ListIterator<SubsystemMessage> listIterator = requests.listIterator();
        while (listIterator.hasNext()) {
            SubsystemMessage subsystemMessage = listIterator.next();
            byte[] byArray = this.toByteArray(subsystemMessage);
            byteArrayOutputStream.write(ByteArrayWriter.encodeInt(byArray.length));
            byteArrayOutputStream.write(byArray);
        }
        this.sendChannelData(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.close();
    }

    public void sendMessagesSeparately(List<SubsystemMessage> requests) throws InvalidMessageException, IOException {
        e.info("Sending " + requests.size() + " messages");
        ListIterator<SubsystemMessage> listIterator = requests.listIterator();
        while (listIterator.hasNext()) {
            SubsystemMessage subsystemMessage = listIterator.next();
            this.sendMessage(subsystemMessage);
        }
    }

    protected byte[] toByteArray(SubsystemMessage msg) throws InvalidMessageException {
        return msg.toByteArray();
    }

    @Override
    protected void onChannelRequest(String requestType, boolean wantReply, byte[] requestData) throws IOException {
        e.debug("Channel Request received: " + requestType);
        if (requestType.equals("exit-status")) {
            this.a = new Integer((int)ByteArrayReader.readInt(requestData, 0));
            e.debug("Exit code of " + this.a.toString() + " received");
        } else if (requestType.equals("exit-signal")) {
            ByteArrayReader byteArrayReader = new ByteArrayReader(requestData);
            String string = byteArrayReader.readString();
            boolean bl = byteArrayReader.read() != 0;
            String string2 = byteArrayReader.readString();
            byteArrayReader.readString();
            e.debug("Exit signal " + string + " received");
            e.debug("Signal message: " + string2);
            e.debug("Core dumped: " + String.valueOf(bl));
        } else if (!requestType.equals("xon-xoff")) {
            if (requestType.equals("signal")) {
                String string = ByteArrayReader.readString(requestData, 0);
                e.debug("Signal " + string + " received");
            } else if (requestType.equals("keepalive@openssh.com")) {
                if (wantReply) {
                    this.connection.sendChannelRequestSuccess(this);
                }
            } else if (wantReply) {
                this.connection.sendChannelRequestFailure(this);
            }
        }
    }

    @Override
    protected void onChannelExtData(SshMsgChannelExtendedData msg) throws IOException {
    }

    @Override
    protected void onChannelData(SshMsgChannelData msg) throws IOException {
        this.c.getOutputStream().write(msg.getChannelData());
        byte[] byArray = new byte[4];
        while (this.c.getInputStream().available() > 4) {
            if (this.d == -1) {
                int n2 = 0;
                while ((n2 += this.c.getInputStream().read(byArray)) < 4) {
                }
                this.d = (int)ByteArrayReader.readInt(byArray, 0);
            }
            if (this.c.getInputStream().available() < this.d) break;
            byte[] byArray2 = new byte[this.d];
            this.c.getInputStream().read(byArray2);
            this.messageStore.addMessage(byArray2);
            this.d = -1;
        }
    }

    @Override
    protected void onChannelEOF() throws IOException {
    }

    @Override
    protected void onChannelClose() throws IOException {
    }

    @Override
    public byte[] getChannelOpenData() {
        return null;
    }

    @Override
    protected void onChannelOpen() throws IOException {
    }

    public boolean startSubsystem() throws IOException {
        e.debug("Starting " + this.b + " subsystem");
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(this.b);
        return this.connection.sendChannelRequest(this, "subsystem", true, byteArrayWriter.toByteArray());
    }

    @Override
    public byte[] getChannelConfirmationData() {
        return null;
    }
}

