/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport;

import com.enterprisedt.net.j2ssh.SshThread;
import com.enterprisedt.net.j2ssh.transport.MessageStoreEOFException;
import com.enterprisedt.net.j2ssh.transport.Service;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;

public abstract class AsyncService
extends Service
implements Runnable {
    private static Logger a = Logger.getLogger("AsyncService");
    protected SshThread thread;

    public AsyncService(String serviceName) {
        super(serviceName);
    }

    public Thread getThread() {
        return this.thread;
    }

    @Override
    protected void onStart() throws IOException {
        this.thread = Thread.currentThread() instanceof SshThread ? ((SshThread)Thread.currentThread()).cloneThread(this, this.getServiceName()) : new SshThread(this, this.getServiceName(), true);
        a.debug("Starting " + this.getServiceName() + " service thread");
        this.thread.start();
    }

    @Override
    public final void run() {
        int[] nArray = this.getAsyncMessageFilter();
        this.state.setValue(2);
        SshMessage sshMessage = null;
        while (this.state.getValue() == 2 && this.transport.isConnected()) {
            try {
                sshMessage = this.messageStore.getMessage(nArray, this.timeout);
                if (this.state.getValue() == 3) break;
                if (a.isDebugEnabled()) {
                    a.debug("Routing " + sshMessage.getMessageName());
                }
                this.onMessageReceived(sshMessage);
                if (!a.isDebugEnabled()) continue;
                a.debug("Finished processing " + sshMessage.getMessageName());
            }
            catch (MessageStoreEOFException messageStoreEOFException) {
                this.stop();
            }
            catch (Exception exception) {
                if (this.state.getValue() == 3 || !this.transport.isConnected()) continue;
                a.fatal("Service message loop failed!", exception);
                this.stop();
            }
        }
        a.debug(this.getServiceName() + " main loop finished");
        this.onStop();
        a.debug(this.getServiceName() + " thread is exiting");
    }

    protected abstract void onStop();

    protected abstract int[] getAsyncMessageFilter();

    protected abstract void onMessageReceived(SshMessage var1) throws IOException;
}

