/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport;

import com.enterprisedt.net.j2ssh.transport.ServiceState;
import com.enterprisedt.net.j2ssh.transport.SshMessageStore;
import com.enterprisedt.net.j2ssh.transport.SshMsgServiceAccept;
import com.enterprisedt.net.j2ssh.transport.TransportProtocol;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;

public abstract class Service {
    private static Logger a = Logger.getLogger("Service");
    public static final int REQUESTING_SERVICE = 1;
    public static final int ACCEPTING_SERVICE = 2;
    protected SshMessageStore messageStore = new SshMessageStore();
    protected TransportProtocol transport;
    protected Integer startMode = null;
    protected ServiceState state = new ServiceState();
    private String b;
    protected int timeout = 60000;

    public Service(String serviceName) {
        this.b = serviceName;
    }

    public final String getServiceName() {
        return this.b;
    }

    public final void start() throws IOException {
        if (this.startMode == null) {
            throw new IOException("Service must be initialized first!");
        }
        if (this.startMode == 1) {
            a.debug(this.b + " has been accepted");
            this.onServiceAccept();
        } else {
            a.debug(this.b + " has been requested");
            this.onServiceRequest();
        }
        this.onStart();
        this.state.setValue(2);
    }

    public void setTimeout(int milliseconds) {
        this.timeout = milliseconds;
    }

    protected abstract void onStart() throws IOException;

    public ServiceState getState() {
        return this.state;
    }

    public void init(int startMode, TransportProtocol transport) throws IOException {
        if (startMode != 1 && startMode != 2) {
            throw new IOException("Invalid start mode!");
        }
        this.transport = transport;
        this.startMode = new Integer(startMode);
        this.onServiceInit(startMode);
        transport.addMessageStore(this.messageStore);
    }

    public final void stop() {
        this.messageStore.close();
        this.state.setValue(3);
    }

    protected abstract void onServiceAccept() throws IOException;

    protected abstract void onServiceInit(int var1) throws IOException;

    protected abstract void onServiceRequest() throws IOException;

    protected void sendServiceAccept() throws IOException {
        SshMsgServiceAccept sshMsgServiceAccept = new SshMsgServiceAccept(this.b);
        this.transport.sendMessage(sshMsgServiceAccept, this);
    }
}

