/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.InvalidMessageException;
import java.io.IOException;

public abstract class SshMessage {
    protected int messageId;

    public SshMessage(int messageId) {
        this.messageId = messageId;
    }

    public final int getMessageId() {
        return this.messageId;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Name=");
        stringBuffer.append(this.getMessageName()).append(",").append("MessageId=").append(this.getMessageId());
        return stringBuffer.toString();
    }

    public abstract String getMessageName();

    public final byte[] toByteArray() throws InvalidMessageException {
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.write(this.messageId);
        this.constructByteArray(byteArrayWriter);
        return byteArrayWriter.toByteArray();
    }

    public final byte[] toByteArray(byte[] appendBuf) throws InvalidMessageException {
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.write(this.messageId);
        this.constructByteArray(byteArrayWriter);
        try {
            byteArrayWriter.write(appendBuf);
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Failed to write append buffer");
        }
        return byteArrayWriter.toByteArray();
    }

    public void fromByteArray(ByteArrayReader data) throws InvalidMessageException {
        data.skip(5L);
        int n2 = data.read();
        if (n2 != this.messageId) {
            throw new InvalidMessageException("The message id " + String.valueOf(n2) + " is not the same as the message implementation id " + String.valueOf(this.messageId));
        }
        this.constructMessage(data);
    }

    public static Integer getMessageId(byte[] msgdata) {
        return new Integer(msgdata[5]);
    }

    protected abstract void constructByteArray(ByteArrayWriter var1) throws InvalidMessageException;

    protected abstract void constructMessage(ByteArrayReader var1) throws InvalidMessageException;
}

