/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.cipher;

import com.enterprisedt.cryptix.provider.key.RijndaelKeyGenerator;
import com.enterprisedt.net.j2ssh.transport.AlgorithmOperationException;
import com.enterprisedt.net.j2ssh.transport.cipher.SshCipher;
import com.enterprisedt.util.debug.Logger;
import java.security.InvalidParameterException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import xjava.security.Cipher;
import xjava.security.FeedbackCipher;
import xjava.security.SecretKey;

public abstract class AES_CBC
extends SshCipher {
    private static Logger a = Logger.getLogger(AES_CBC.class);
    private Cipher b;
    private int c = 0;

    public AES_CBC(int keylen) {
        this.c = keylen;
    }

    @Override
    public int getBlockSize() {
        return this.b.blockSize();
    }

    protected byte[] copyKey(byte[] keydata) {
        byte[] byArray = new byte[this.c];
        System.arraycopy(keydata, 0, byArray, 0, byArray.length);
        return byArray;
    }

    @Override
    public void init(int mode, byte[] iv, byte[] keydata) throws AlgorithmOperationException {
        try {
            this.b = Cipher.getInstance("Rijndael/CBC/NONE", "CryptixEDT");
            byte[] byArray = this.copyKey(keydata);
            SecretKey secretKey = new RijndaelKeyGenerator().generateKey(byArray);
            if (this.b instanceof FeedbackCipher) {
                byte[] byArray2 = new byte[this.b.blockSize()];
                System.arraycopy(iv, 0, byArray2, 0, this.b.blockSize());
                ((FeedbackCipher)((Object)this.b)).setInitializationVector(byArray2);
            }
            if (mode == 0) {
                this.b.initEncrypt(secretKey);
            } else {
                this.b.initDecrypt(secretKey);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.error("Rijndael initialization failed", noSuchAlgorithmException);
            throw new AlgorithmOperationException("Algorithm not supported", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            a.error("Rijndael initialization failed", noSuchProviderException);
            throw new AlgorithmOperationException("Algorithm not supported", noSuchProviderException);
        }
        catch (KeyException keyException) {
            a.error("Rijndael initialization failed", keyException);
            throw new AlgorithmOperationException("Invalid encryption key", keyException);
        }
        catch (InvalidParameterException invalidParameterException) {
            a.error("Rijndael initialization failed", invalidParameterException);
            throw new AlgorithmOperationException("Invalid algorithm parameter", invalidParameterException);
        }
    }

    @Override
    public byte[] transform(byte[] data, int offset, int len) throws AlgorithmOperationException {
        return this.b.update(data, offset, len);
    }
}

