/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.cipher;

import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.engines.AESEngine;
import com.enterprisedt.bouncycastle.crypto.modes.GCMBlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.AEADParameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.net.j2ssh.transport.AlgorithmOperationException;
import com.enterprisedt.net.j2ssh.transport.cipher.SshCipher;

public class AesGcmCipher
extends SshCipher {
    public static final int TAG_LENGTH = 16;
    public static final int NONCE_LENGTH = 12;
    private GCMBlockCipher a = new GCMBlockCipher(new AESEngine());
    private KeyParameter b;
    private byte[] c;
    private byte[] d;
    private int e;

    @Override
    public void init(int mode, byte[] iv, byte[] keydata) throws AlgorithmOperationException {
        if (keydata.length != 16 && keydata.length != 32) {
            throw new AlgorithmOperationException("Key must be 16 bytes (AES-128) or 32 bytes (AES-256)");
        }
        this.e = mode;
        this.b = new KeyParameter(keydata);
        this.c = new byte[12];
        System.arraycopy(iv, 0, this.c, 0, 12);
        this.d = new byte[8];
        System.arraycopy(this.c, 4, this.d, 0, 8);
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    public byte[] getNextNonce() {
        byte[] byArray = new byte[12];
        System.arraycopy(this.c, 0, byArray, 0, 4);
        System.arraycopy(this.d, 0, byArray, 4, 8);
        this.a(this.d);
        return byArray;
    }

    private void a(byte[] byArray) {
        int n2 = byArray.length - 1;
        while (n2 >= 0) {
            int n3 = n2--;
            byArray[n3] = (byte)(byArray[n3] + 1);
            if (byArray[n3] == 0) continue;
            return;
        }
    }

    public void encrypt(byte[] data, int offset, int len, byte[] result, int resultOffset, byte[] aad, byte[] nonce) throws AlgorithmOperationException {
        try {
            this.a.init(true, new AEADParameters(this.b, 128, nonce));
            if (aad != null && aad.length > 0) {
                this.a.processAADBytes(aad, 0, aad.length);
            }
            int n2 = this.a.processBytes(data, offset, len, result, resultOffset);
            this.a.doFinal(result, resultOffset + n2);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new AlgorithmOperationException("AES-GCM encryption failed: " + invalidCipherTextException.getMessage());
        }
    }

    public void decrypt(byte[] data, int offset, int len, byte[] result, int resultOffset, byte[] aad, byte[] nonce) throws AlgorithmOperationException {
        try {
            this.a.init(false, new AEADParameters(this.b, 128, nonce));
            if (aad != null && aad.length > 0) {
                this.a.processAADBytes(aad, 0, aad.length);
            }
            int n2 = this.a.processBytes(data, offset, len, result, resultOffset);
            this.a.doFinal(result, resultOffset + n2);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new AlgorithmOperationException("AES-GCM decryption failed: " + invalidCipherTextException.getMessage());
        }
    }

    @Override
    public byte[] transform(byte[] data, int offset, int len) throws AlgorithmOperationException {
        throw new AlgorithmOperationException("AES-GCM requires special handling with AAD and nonce. Use encrypt() or decrypt() methods instead.");
    }

    public boolean isAesGcm() {
        return true;
    }
}

