/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.cipher;

import com.enterprisedt.net.j2ssh.transport.AlgorithmNotSupportedException;
import com.enterprisedt.net.j2ssh.transport.cipher.AES_CBC_128;
import com.enterprisedt.net.j2ssh.transport.cipher.AES_CBC_192;
import com.enterprisedt.net.j2ssh.transport.cipher.AES_CBC_256;
import com.enterprisedt.net.j2ssh.transport.cipher.AES_CTR_128;
import com.enterprisedt.net.j2ssh.transport.cipher.AES_CTR_192;
import com.enterprisedt.net.j2ssh.transport.cipher.AES_CTR_256;
import com.enterprisedt.net.j2ssh.transport.cipher.AesGcmCipher;
import com.enterprisedt.net.j2ssh.transport.cipher.ArcFour;
import com.enterprisedt.net.j2ssh.transport.cipher.BlowfishCbc;
import com.enterprisedt.net.j2ssh.transport.cipher.SshCipher;
import com.enterprisedt.net.j2ssh.transport.cipher.TripleDesCbc;
import com.enterprisedt.util.debug.Logger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SshCipherFactory {
    public static String DES3_CBC = "3des-cbc";
    public static String BLOWFISH_CBC = "blowfish-cbc";
    public static final String AES128_GCM_OPENSSH = "aes128-gcm@openssh.com";
    public static final String AES256_GCM_OPENSSH = "aes256-gcm@openssh.com";
    private static Map a;
    private static String b;
    private static Logger c;
    private ArrayList d = new ArrayList(a.keySet());

    public static void initialize() {
    }

    public static String getDefaultCipher() {
        return b;
    }

    public static List getSupportedCiphers() {
        return new ArrayList(a.keySet());
    }

    public List getEnabledCiphers() {
        return this.d;
    }

    public void disableAllCiphers() {
        this.d.clear();
    }

    public void setCipherEnabled(String algorithmName, boolean enable) throws AlgorithmNotSupportedException {
        if (!a.containsKey(algorithmName)) {
            throw new AlgorithmNotSupportedException(algorithmName + " is not supported!");
        }
        if (enable) {
            if (!this.d.contains(algorithmName)) {
                this.d.add(algorithmName);
            }
        } else {
            this.d.remove(algorithmName);
        }
    }

    public boolean isCipherEnabled(String algorithmName) {
        return this.d.contains(algorithmName);
    }

    public static SshCipher newInstance(String algorithmName) throws AlgorithmNotSupportedException {
        c.debug("Creating new " + algorithmName + " cipher instance");
        try {
            return (SshCipher)((Class)a.get(algorithmName)).newInstance();
        }
        catch (Throwable throwable) {
            throw new AlgorithmNotSupportedException(algorithmName + " is not supported!", throwable);
        }
    }

    static {
        c = Logger.getLogger("SshCipherFactory");
        a = new LinkedHashMap();
        c.debug("Loading supported cipher algorithms");
        a.put("aes128-cbc", AES_CBC_128.class);
        a.put("aes192-cbc", AES_CBC_192.class);
        a.put("aes256-cbc", AES_CBC_256.class);
        a.put("aes128-ctr", AES_CTR_128.class);
        a.put("aes192-ctr", AES_CTR_192.class);
        a.put("aes256-ctr", AES_CTR_256.class);
        a.put(AES128_GCM_OPENSSH, AesGcmCipher.class);
        a.put(AES256_GCM_OPENSSH, AesGcmCipher.class);
        a.put(DES3_CBC, TripleDesCbc.class);
        a.put(BLOWFISH_CBC, BlowfishCbc.class);
        a.put("arcfour", ArcFour.class);
        b = BLOWFISH_CBC;
    }
}

