/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.compression;

import com.enterprisedt.net.j2ssh.transport.AlgorithmNotSupportedException;
import com.enterprisedt.net.j2ssh.transport.compression.DelayedZlibCompression;
import com.enterprisedt.net.j2ssh.transport.compression.SshCompression;
import com.enterprisedt.net.j2ssh.transport.compression.ZlibCompression;
import com.enterprisedt.util.debug.Logger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SshCompressionFactory {
    public static final String COMP_NONE = "none";
    private static String a;
    private static Map b;
    private static Logger c;
    private ArrayList d = new ArrayList(b.keySet());

    public static void initialize() {
    }

    public static String getDefaultCompression() {
        return a;
    }

    public static List getSupportedCompression() {
        return new ArrayList(b.keySet());
    }

    public List getEnabledCompressions() {
        return this.d;
    }

    public void disableAllCompressions() {
        this.d.clear();
    }

    public void setCompressionEnabled(String algorithmName, boolean enable) throws AlgorithmNotSupportedException {
        if (!b.containsKey(algorithmName)) {
            throw new AlgorithmNotSupportedException(algorithmName + " is not supported!");
        }
        if (enable) {
            if (!this.d.contains(algorithmName)) {
                this.d.add(algorithmName);
            }
        } else {
            this.d.remove(algorithmName);
        }
    }

    public boolean isCompressionEnabled(String algorithmName) {
        return this.d.contains(algorithmName);
    }

    public static SshCompression newInstance(String algorithmName) throws AlgorithmNotSupportedException {
        try {
            if (algorithmName.equals(COMP_NONE)) {
                return null;
            }
            return (SshCompression)((Class)b.get(algorithmName)).newInstance();
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(algorithmName + " is not supported!", exception);
        }
    }

    static {
        c = Logger.getLogger("SshCompressionFactory");
        b = new LinkedHashMap();
        c.debug("Loading compression methods");
        b.put(COMP_NONE, "");
        c.debug("Installed none compression");
        b.put("zlib", ZlibCompression.class);
        c.debug("Installed zlib compression");
        b.put("zlib@openssh.com", DelayedZlibCompression.class);
        c.debug("Installed zlib@openssh.com compression");
        a = COMP_NONE;
    }
}

