/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.hmac;

import com.enterprisedt.net.j2ssh.transport.AlgorithmInitializationException;
import com.enterprisedt.net.j2ssh.transport.AlgorithmOperationException;
import com.enterprisedt.net.j2ssh.transport.hmac.SshHmac;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import xjava.security.InvalidParameterTypeException;
import xjava.security.NoSuchParameterException;
import xjava.security.Parameterized;

public class HmacSha
extends SshHmac {
    private MessageDigest a;
    private byte[] b = new byte[20];

    @Override
    public int getMacLength() {
        return this.a.getDigestLength();
    }

    @Override
    public byte[] generate(long sequenceNo, byte[] data, int offset, int len) throws AlgorithmOperationException {
        byte[] byArray = new byte[]{(byte)(sequenceNo >> 24), (byte)(sequenceNo >> 16), (byte)(sequenceNo >> 8), (byte)(sequenceNo >> 0)};
        this.a.update(byArray);
        this.a.update(data, offset, len);
        byte[] byArray2 = this.a.digest();
        try {
            ((Parameterized)((Object)this.a)).setParameter("key", this.b);
        }
        catch (InvalidParameterTypeException invalidParameterTypeException) {
            throw new AlgorithmOperationException("Initialization error for the HmacSha1 algorithm", invalidParameterTypeException);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            throw new AlgorithmOperationException("Initialization error for the HmacSha1 algorithm", noSuchParameterException);
        }
        return byArray2;
    }

    @Override
    public void init(byte[] keydata) throws AlgorithmInitializationException {
        try {
            this.a = MessageDigest.getInstance("HMAC-SHA-1", "CryptixEDT");
            System.arraycopy(keydata, 0, this.b, 0, 20);
            ((Parameterized)((Object)this.a)).setParameter("key", this.b);
        }
        catch (InvalidParameterTypeException invalidParameterTypeException) {
            throw new AlgorithmInitializationException("Initialization error for the HmacSha1 algorithm", invalidParameterTypeException);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            throw new AlgorithmInitializationException("Initialization error for the HmacSha1 algorithm", noSuchParameterException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new AlgorithmInitializationException("No provider exists for the HmacSha1 algorithm", noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AlgorithmInitializationException("No provider exists for the HmacSha1 algorithm", noSuchAlgorithmException);
        }
    }
}

