/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.hmac;

import com.enterprisedt.net.j2ssh.transport.AlgorithmNotSupportedException;
import com.enterprisedt.net.j2ssh.transport.hmac.HmacMd5;
import com.enterprisedt.net.j2ssh.transport.hmac.HmacMd596;
import com.enterprisedt.net.j2ssh.transport.hmac.HmacSha;
import com.enterprisedt.net.j2ssh.transport.hmac.HmacSha256;
import com.enterprisedt.net.j2ssh.transport.hmac.HmacSha256ETM;
import com.enterprisedt.net.j2ssh.transport.hmac.HmacSha512;
import com.enterprisedt.net.j2ssh.transport.hmac.HmacSha512ETM;
import com.enterprisedt.net.j2ssh.transport.hmac.HmacSha96;
import com.enterprisedt.net.j2ssh.transport.hmac.SshHmac;
import com.enterprisedt.util.debug.Logger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SshHmacFactory {
    private static String a;
    private static Map b;
    private static Logger c;
    private ArrayList d = new ArrayList(b.keySet());

    public static void initialize() {
    }

    public static final String getDefaultHmac() {
        return a;
    }

    public static List getSupportedMacs() {
        return new ArrayList(b.keySet());
    }

    public List getEnabledMacs() {
        return this.d;
    }

    public void disableAllMacs() {
        this.d.clear();
    }

    public void setMacEnabled(String algorithmName, boolean enable) throws AlgorithmNotSupportedException {
        if (!b.containsKey(algorithmName)) {
            throw new AlgorithmNotSupportedException(algorithmName + " is not supported!");
        }
        if (enable) {
            if (!this.d.contains(algorithmName)) {
                this.d.add(algorithmName);
            }
        } else {
            this.d.remove(algorithmName);
        }
    }

    public boolean isMacEnabled(String algorithmName) {
        return this.d.contains(algorithmName);
    }

    public static SshHmac newInstance(String methodName) throws AlgorithmNotSupportedException {
        try {
            return (SshHmac)((Class)b.get(methodName)).newInstance();
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(methodName + " is not supported!", exception);
        }
    }

    static {
        c = Logger.getLogger("SshHmacFactory");
        b = new LinkedHashMap();
        c.debug("Loading message authentication methods");
        b.put("hmac-sha1", HmacSha.class);
        b.put("hmac-sha1-96", HmacSha96.class);
        b.put("hmac-md5", HmacMd5.class);
        b.put("hmac-md5-96", HmacMd596.class);
        b.put("hmac-sha2-256", HmacSha256.class);
        b.put("hmac-sha256", HmacSha256.class);
        b.put("hmac-sha2-256-etm@openssh.com", HmacSha256ETM.class);
        b.put("hmac-sha2-512", HmacSha512.class);
        b.put("hmac-sha512", HmacSha512.class);
        b.put("hmac-sha2-512-etm@openssh.com", HmacSha512ETM.class);
        a = "hmac-sha1";
    }
}

